@extends('admin.layouts.home')

@section('title', 'Live Stream Settings')

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-camera-video fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Live Stream Settings</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('admin/dashboard') }}" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Live Stream Settings</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Manage Live Stream Settings</h5>
                                <p class="text-muted mb-0">Configure your platform's live streaming features</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <!-- Left Column -->
                    <div class="col-md-6">
                        <!-- Live Streaming Settings Card -->
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-camera-video"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Live Streaming Settings</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Live Streaming -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-broadcast"></i>
                                            </div>
                                            <strong>Live Streaming</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Users can go live instantly.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_live_streaming" name="enable_live_streaming" {{active_value_check(setting('enable_live_streaming') ?? 1)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Live Streaming Storage -->
                                <div class="row mb-3">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-save"></i>
                                            </div>
                                            <strong>Live Streaming Storage</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Let the live stream save streams to watch again later.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_stream_storage" name="enable_stream_storage" {{active_value_check(setting('enable_stream_storage') ?? 0)}}>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Millicast API Configuration Card -->
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-code-square"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Millicast API Configuration</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-info">
                                    <small>To start using this feature, you'll need to create an account in MilliCast.</small>
                                </div>

                                <!-- Millicast Live Streaming -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-broadcast"></i>
                                            </div>
                                            <strong>Millicast Live Streaming</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Users can go live instantly using Millicast.</small>
                                        </p>
                                        <p class="text-muted mb-0">
                                            <small>Note you can only choose one provider at the same time.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_millicast" name="enable_millicast" {{active_value_check(setting('enable_millicast') ?? 0)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Publishing Token -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form-label">Publishing Token</label>
                                            <input type="text" class="form-control" id="millicast_publishing_token" name="millicast_publishing_token" value="{{ setting('millicast_publishing_token') }}" placeholder="Your Millicast Publishing Token">
                                            <small class="text-muted">Your Millicast Publishing Token.</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Account ID -->
                                <div class="row mb-3">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form-label">Account ID</label>
                                            <input type="text" class="form-control" id="millicast_account_id" name="millicast_account_id" value="{{ setting('millicast_account_id') }}" placeholder="Your Millicast Account ID">
                                            <small class="text-muted">Your Millicast Account ID.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Right Column -->
                    <div class="col-md-6">
                        <!-- Agora API Configuration Card -->
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-code-square"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Agora API Configuration</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-info">
                                    <small>To start using this feature, you'll need to create an account in Agora.</small>
                                </div>

                                <!-- Agora Live Streaming -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-broadcast"></i>
                                            </div>
                                            <strong>Agora Live Streaming</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Users can go live instantly using Agora.</small>
                                        </p>
                                        <p class="text-muted mb-0">
                                            <small>Note you can only choose one provider at the same time.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_agora" name="enable_agora" {{active_value_check(setting('enable_agora') ?? 0)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- App ID -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form-label">App ID</label>
                                            <input type="text" class="form-control" id="agora_app_id" name="agora_app_id" value="{{ setting('agora_app_id') }}" placeholder="Your Agora App ID">
                                        </div>
                                    </div>
                                </div>

                                <!-- App Certificate -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form-label">App Certificate</label>
                                            <div class="alert alert-danger">
                                                <small>The secret key is not showing due security reasons, you can still overwrite the current one.</small>
                                            </div>
                                            <input type="text" class="form-control" id="agora_app_certificate" name="agora_app_certificate" value="{{ setting('agora_app_certificate') }}" placeholder="Your Agora App Certificate">
                                        </div>
                                    </div>
                                </div>

                                <!-- Customer ID -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form-label">Customer ID</label>
                                            <input type="text" class="form-control" id="agora_customer_id" name="agora_customer_id" value="{{ setting('agora_customer_id') }}" placeholder="Your Agora Customer ID">
                                        </div>
                                    </div>
                                </div>

                                <!-- Customer Secret -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form-label">Customer Secret</label>
                                            <div class="alert alert-danger">
                                                <small>The secret key is not showing due security reasons, you can still overwrite the current one.</small>
                                            </div>
                                            <input type="text" class="form-control" id="agora_customer_secret" name="agora_customer_secret" value="{{ setting('agora_customer_secret') }}" placeholder="Your Agora Customer Secret">
                                        </div>
                                    </div>
                                </div>

                                <!-- Amazon S3 Live Streaming Storage -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-cloud"></i>
                                            </div>
                                            <strong>Amazon S3 Live Streaming Storage</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Used to store video streams if "Live Streaming Storage" is enabled.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_s3_storage" name="enable_s3_storage" {{active_value_check(setting('enable_s3_storage') ?? 0)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Amazon S3 Configuration -->
                                <div class="row mb-3">
                                    <div class="col-12">
                                        <!-- Bucket Name -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Amazon Bucket Name</label>
                                            <input type="text" class="form-control" id="aws_bucket_name" name="aws_bucket_name" value="{{ setting('aws_bucket_name') }}" placeholder="Your Amazon S3 Bucket Name">
                                        </div>

                                        <!-- AWS Key -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Amazon S3 Key</label>
                                            <input type="text" class="form-control" id="aws_access_key" name="aws_access_key" value="{{ setting('aws_access_key') }}" placeholder="Your Amazon Key from AWS credentials">
                                        </div>

                                        <!-- AWS Secret -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Amazon S3 Secret Key</label>
                                            <div class="alert alert-danger">
                                                <small>The secret key is not showing due security reasons, you can still overwrite the current one.</small>
                                            </div>
                                            <input type="password" class="form-control" id="aws_secret_key" name="aws_secret_key" placeholder="Your Amazon Secret from AWS credentials">
                                        </div>

                                        <!-- AWS Region -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Amazon S3 bucket Region</label>
                                            <select class="form-select" id="aws_default_region" name="aws_default_region">
                                                <option value="us-west-2" {{ setting('aws_default_region') == 'us-west-2' ? 'selected' : '' }}>US West (Oregon)</option>
                                                <option value="us-east-1" {{ setting('aws_default_region') == 'us-east-1' ? 'selected' : '' }}>US East (N. Virginia)</option>
                                                <option value="eu-west-1" {{ setting('aws_default_region') == 'eu-west-1' ? 'selected' : '' }}>EU (Ireland)</option>
                                            </select>
                                        </div>

                                        <!-- Info Box -->
                                        <div class="alert alert-info mt-3">
                                            <small>
                                                <ul class="mb-0">
                                                    <li>Before enabling Amazon S3, make sure you upload the whole "upload" folder to your bucket.</li>
                                                    <li>Before disabling Amazon S3, make sure you download the whole "upload" folder to your server.</li>
                                                    <li>We recommend to upload the folder and files via S3cmd.</li>
                                                    <li>If your site is still brand new, you can escape the upload step, but make sure to click on "Test Connection".</li>
                                                </ul>
                                            </small>
                                        </div>

                                        <!-- Test Connection Button -->
                                        <button type="button" class="btn btn-info mt-3" id="test_connection">Test Server Connection</button>

                                        <!-- Video Call Configuration Link -->
                                        <div class="mt-3">
                                            <small>Looking for Video Call Configuration? <a href="#" class="text-primary">Click here</a></small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
@include('admin.update_settings')
@endsection