@extends('admin.layouts.home')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-envelope-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Mail Configuration</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i
                                                        class="bi bi-speedometer2 me-1"></i><a
                                                        href="index.html"
                                                        class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white"
                                                    aria-current="page">Mail Configuration</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Email Server Settings</h5>
                                <p class="text-muted mb-0">Configure your mail server for sending system
                                    emails</p>
                            </div>
                            <div>
                                <button type="button" class="btn btn-outline-primary me-2">
                                    <i class="bi bi-envelope-check me-1"></i> Test Connection
                                </button>
                                <button type="button" class="btn btn-success">
                                    <i class="bi bi-save me-1"></i> Save Configuration
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-envelope-paper"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Mail Configuration</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="#" method="post">
                                    <div class="row g-3">
                                        <!-- Protocol (MAIL_MAILER) -->
                                        <div class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                            <div class="form-group">
                                                <label for="mail_mailer" class="form-label fw-bold">Protocol
                                                    (MAIL_MAILER)</label>
                                                <select name="mail_mailer" id="mail_mailer"
                                                    class="form-select" required>
                                                    <option value="smtp" selected>SMTP</option>
                                                    <option value="sendmail">SendMail</option>
                                                </select>
                                                <small class="text-muted">Select the email protocol to
                                                    use</small>
                                            </div>
                                        </div>

                                        <!-- SMTP Settings -->
                                        <div class="col-12">
                                            <div class="card bg-light mb-3">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0"><i class="bi bi-gear me-1"></i> SMTP
                                                        Server Settings</h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row g-3">
                                                        <!-- SMTP Host -->
                                                        <div
                                                            class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                                            <div class="form-group">
                                                                <label for="mail_host"
                                                                    class="form-label fw-bold">SMTP
                                                                    Host</label>
                                                                <div class="input-group">
                                                                    <span class="input-group-text"><i
                                                                            class="bi bi-hdd-network"></i></span>
                                                                    <input type="text" id="mail_host"
                                                                        name="mail_host"
                                                                        class="form-control"
                                                                        value="smtp.example.com">
                                                                </div>
                                                                <small class="text-muted">Your mail server
                                                                    hostname</small>
                                                            </div>
                                                        </div>

                                                        <!-- SMTP Port -->
                                                        <div
                                                            class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                                            <div class="form-group">
                                                                <label for="mail_port"
                                                                    class="form-label fw-bold">SMTP
                                                                    Port</label>
                                                                <div class="input-group">
                                                                    <span class="input-group-text"><i
                                                                            class="bi bi-signpost"></i></span>
                                                                    <input type="text" id="mail_port"
                                                                        name="mail_port"
                                                                        class="form-control" value="465">
                                                                </div>
                                                                <small class="text-muted">Common ports: 25,
                                                                    465, 587, 2525</small>
                                                            </div>
                                                        </div>

                                                        <!-- SMTP Username -->
                                                        <div
                                                            class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                                            <div class="form-group">
                                                                <label for="mail_username"
                                                                    class="form-label fw-bold">SMTP
                                                                    Username</label>
                                                                <div class="input-group">
                                                                    <span class="input-group-text"><i
                                                                            class="bi bi-person"></i></span>
                                                                    <input type="text" id="mail_username"
                                                                        name="mail_username"
                                                                        class="form-control"
                                                                        value="username@example.com">
                                                                </div>
                                                                <small class="text-muted">Your mail server
                                                                    username</small>
                                                            </div>
                                                        </div>

                                                        <!-- SMTP Password -->
                                                        <div
                                                            class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                                            <div class="form-group">
                                                                <label for="mail_password"
                                                                    class="form-label fw-bold">SMTP
                                                                    Password</label>
                                                                <div class="input-group">
                                                                    <span class="input-group-text"><i
                                                                            class="bi bi-key"></i></span>
                                                                    <input type="password"
                                                                        id="mail_password"
                                                                        name="mail_password"
                                                                        class="form-control"
                                                                        value="password">
                                                                    <button
                                                                        class="btn btn-outline-secondary"
                                                                        type="button" id="togglePassword">
                                                                        <i class="bi bi-eye"></i>
                                                                    </button>
                                                                </div>
                                                                <small class="text-muted">Your mail server
                                                                    password</small>
                                                            </div>
                                                        </div>

                                                        <!-- SMTP Encryption -->
                                                        <div
                                                            class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                                            <div class="form-group">
                                                                <label for="mail_encryption"
                                                                    class="form-label fw-bold">SMTP
                                                                    Encryption</label>
                                                                <select name="mail_encryption"
                                                                    id="mail_encryption"
                                                                    class="form-select">
                                                                    <option value="tls" selected>TLS
                                                                    </option>
                                                                    <option value="ssl">SSL</option>
                                                                    <option value="none">None</option>
                                                                </select>
                                                                <small class="text-muted">Encryption
                                                                    protocol for secure email</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Email Identity Settings -->
                                        <div class="col-12">
                                            <div class="card bg-light mb-3">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0"><i class="bi bi-person-badge me-1"></i>
                                                        Email Identity</h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row g-3">
                                                        <!-- MAIL_FROM_ADDRESS -->
                                                        <div
                                                            class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                                            <div class="form-group">
                                                                <label for="email_from_address"
                                                                    class="form-label fw-bold">From
                                                                    Address</label>
                                                                <div class="input-group">
                                                                    <span class="input-group-text"><i
                                                                            class="bi bi-at"></i></span>
                                                                    <input type="email"
                                                                        id="email_from_address"
                                                                        name="email_from_address"
                                                                        class="form-control"
                                                                        value="info@linkon.social">
                                                                </div>
                                                                <small class="text-muted">Email address that
                                                                    appears in the From field</small>
                                                            </div>
                                                        </div>

                                                        <!-- MAIL_FROM_NAME -->
                                                        <div
                                                            class="col-sm-6 col-md-6 col-lg-6 col-xl-4 mb-3">
                                                            <div class="form-group">
                                                                <label for="mail_from_name"
                                                                    class="form-label fw-bold">From
                                                                    Name</label>
                                                                <div class="input-group">
                                                                    <span class="input-group-text"><i
                                                                            class="bi bi-person-circle"></i></span>
                                                                    <input type="text" id="mail_from_name"
                                                                        name="mail_from_name"
                                                                        class="form-control" value="LinkOn">
                                                                </div>
                                                                <small class="text-muted">Name that appears
                                                                    in the From field</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Save Changes Button -->
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <div class="card bg-light">
                                                <div class="card-body p-3">
                                                    <div
                                                        class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <p class="mb-0"><i
                                                                    class="bi bi-info-circle me-1"></i>
                                                                Changes will be applied to all outgoing
                                                                emails.</p>
                                                        </div>
                                                        <div>
                                                            <button type="button"
                                                                class="btn btn-outline-secondary me-2">
                                                                <i
                                                                    class="bi bi-arrow-counterclockwise me-1"></i>
                                                                Reset
                                                            </button>
                                                            <button type="submit" class="btn btn-success">
                                                                <i class="bi bi-save me-1"></i> Save
                                                                Configuration
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
@include('admin.update_settings')
@endsection