@extends('admin.layouts.home')

@section('title', 'Dashboard')

@section('content')


<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-cloud-upload-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Upload Configuration</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="index.html" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Upload Configuration</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Upload & File Sharing Configuration</h5>
                                <p class="text-muted mb-0">Configure file upload settings and storage options</p>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-file-earmark-arrow-up"></i>
                            </div>
                            <h5 class="card-title mb-0">Upload & File Sharing Configuration</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info py-2">
                            <i class="bi bi-info-circle-fill me-2"></i> <strong>Feature Toggles:</strong> Enable or disable specific upload features for your users.
                        </div>

                        <form class="upload-settings" method="POST">
                            <!-- File Upload & Sharing -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-fileSharing" class="form-label fw-bold mb-0">File Upload & Sharing</label>
                                    <p class="text-muted mb-0 small">By enabling this feature, the user can share and upload files in your site.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="fileSharing" value="0">
                                    <input class="form-check-input" type="checkbox" name="fileSharing" id="chck-fileSharing" value="1" checked>
                                </div>
                            </div>

                            <!-- Video Upload & Sharing -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-video_upload" class="form-label fw-bold mb-0">Video Upload & Sharing</label>
                                    <p class="text-muted mb-0 small">Turn on the ability for users to share and upload videos.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="video_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="video_upload" id="chck-video_upload" value="1" checked>
                                </div>
                            </div>

                            <!-- Reels Upload -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-reels_upload" class="form-label fw-bold mb-0">Reels Upload</label>
                                    <p class="text-muted mb-0 small">Turn on the ability for users to share and upload reels.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="reels_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="reels_upload" id="chck-reels_upload" value="1" checked>
                                </div>
                            </div>

                            <!-- Audio Upload & Sharing -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-audio_upload" class="form-label fw-bold mb-0">Audio Upload & Sharing</label>
                                    <p class="text-muted mb-0 small">Turn on the ability for users to share and upload music and audio files.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="audio_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="audio_upload" id="chck-audio_upload" value="1" checked>
                                </div>
                            </div>

                            <!-- CSS Upload & Modifications -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="chck-css_upload" class="form-label fw-bold mb-0">CSS Upload & Modifications</label>
                                    <p class="text-muted mb-0 small">Allow users to upload their own CSS file to design their profile.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="css_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="css_upload" id="chck-css_upload" value="1" checked>
                                </div>
                            </div>

                            <input type="hidden" name="hash_id" value="00ddcc06d83d0faf07a6899229ca696359406f2a">
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-info text-white me-3">
                                <i class="bi bi-info-circle"></i>
                            </div>
                            <h5 class="card-title mb-0">Media System Information</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info py-2">
                            <i class="bi bi-info-circle-fill me-2"></i> <strong>Advanced Media System:</strong> This system provides granular control over file uploads with type-specific settings.
                        </div>

                        <div class="alert alert-warning py-2">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> <strong>Security Note:</strong> The system automatically blocks dangerous file types like PHP, JS, HTML, XML, etc.
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <div class="text-center p-3 border rounded">
                                    <i class="bi bi-image text-primary fs-1"></i>
                                    <h6 class="mt-2">Image Processing</h6>
                                    <small class="text-muted">Auto-resize, compress & optimize</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 border rounded">
                                    <i class="bi bi-shield-check text-success fs-1"></i>
                                    <h6 class="mt-2">Security</h6>
                                    <small class="text-muted">MIME validation & threat scanning</small>
                                </div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <p class="text-muted small mb-0">
                                <i class="bi bi-gear me-1"></i> All file upload settings are now managed through the Media System Configuration below.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <!-- Media System Configuration -->
        <div class="col-lg-12 col-md-12 mb-3">
            <div class="d-flex align-items-center">
                <div class="icon-circle bg-primary text-white me-3">
                    <i class="bi bi-gear-wide-connected"></i>
                </div>
                <h4 class="mb-0">Media System Configuration</h4>
            </div>
            <hr>
            <div class="alert alert-info py-2 mb-3">
                <i class="bi bi-info-circle-fill me-2"></i> <strong>Info:</strong> Configure the advanced media system settings for file handling and storage.
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-image"></i>
                            </div>
                            <h5 class="card-title mb-0">Image Processing Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="media-settings" method="POST" action="{{ route('admin.media.update') }}">
                            @csrf
                            <input type="hidden" name="settings_type" value="image_processing">
                            
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-media_image_processing" class="form-label fw-bold mb-0">Enable Image Processing</label>
                                    <p class="text-muted mb-0 small">Automatically resize, compress, and optimize uploaded images</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="media_image_processing" value="0">
                                    <input class="form-check-input" type="checkbox" name="media_image_processing" 
                                           id="chck-media_image_processing" value="1" 
                                           {{ setting('media_image_processing', true) ? 'checked' : '' }}>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="media_image_quality" class="form-label">Image Quality</label>
                                <select class="form-select" id="media_image_quality" name="media_image_quality">
                                    <option value="99" {{ setting('media_image_quality', 85) == 99 ? 'selected' : '' }}>Very High (99%)</option>
                                    <option value="90" {{ setting('media_image_quality', 85) == 90 ? 'selected' : '' }}>High (90%)</option>
                                    <option value="85" {{ setting('media_image_quality', 85) == 85 ? 'selected' : '' }}>Medium (85%)</option>
                                    <option value="75" {{ setting('media_image_quality', 85) == 75 ? 'selected' : '' }}>Low (75%)</option>
                                    <option value="60" {{ setting('media_image_quality', 85) == 60 ? 'selected' : '' }}>Very Low (60%)</option>
                                </select>
                                <small class="text-muted">Higher quality means larger file sizes</small>
                            </div>

                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-media_resize_large_images" class="form-label fw-bold mb-0">Auto-resize Large Images</label>
                                    <p class="text-muted mb-0 small">Automatically resize images that exceed maximum dimensions</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="media_resize_large_images" value="0">
                                    <input class="form-check-input" type="checkbox" name="media_resize_large_images" 
                                           id="chck-media_resize_large_images" value="1" 
                                           {{ setting('media_resize_large_images', true) ? 'checked' : '' }}>
                                </div>
                            </div>

                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-media_create_thumbnails" class="form-label fw-bold mb-0">Generate Thumbnails</label>
                                    <p class="text-muted mb-0 small">Automatically create multiple thumbnail sizes for images</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="media_create_thumbnails" value="0">
                                    <input class="form-check-input" type="checkbox" name="media_create_thumbnails" 
                                           id="chck-media_create_thumbnails" value="1" 
                                           {{ setting('media_create_thumbnails', true) ? 'checked' : '' }}>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Image Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-shield-check"></i>
                            </div>
                            <h5 class="card-title mb-0">Security Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="media-settings" method="POST" action="{{ route('admin.media.update') }}">
                            @csrf
                            <input type="hidden" name="settings_type" value="security">
                            
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-media_scan_uploads" class="form-label fw-bold mb-0">Scan Uploads</label>
                                    <p class="text-muted mb-0 small">Scan uploaded files for potential security threats</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="media_scan_uploads" value="0">
                                    <input class="form-check-input" type="checkbox" name="media_scan_uploads" 
                                           id="chck-media_scan_uploads" value="1" 
                                           {{ setting('media_scan_uploads', false) ? 'checked' : '' }}>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="media_allowed_mime_types" class="form-label">Allowed MIME Types</label>
                                <textarea class="form-control" id="media_allowed_mime_types" name="media_allowed_mime_types" 
                                          rows="4" placeholder="image/jpeg,image/png,image/gif,image/webp,video/mp4,application/pdf">{{ setting('media_allowed_mime_types', 'image/jpeg,image/png,image/gif,image/webp,video/mp4,application/pdf') }}</textarea>
                                <small class="text-muted">Comma-separated list of allowed MIME types</small>
                            </div>

                            <div class="mb-3">
                                <label for="media_blocked_extensions" class="form-label">Blocked Extensions</label>
                                <input type="text" class="form-control" id="media_blocked_extensions" name="media_blocked_extensions" 
                                       value="{{ setting('media_blocked_extensions', 'php,php3,php4,php5,phtml,pl,py,jsp,asp,sh,cgi') }}">
                                <small class="text-muted">Comma-separated list of blocked file extensions</small>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Security Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Media Types Configuration -->
        <div class="col-lg-12 col-md-12 mb-3">
            <div class="d-flex align-items-center">
                <div class="icon-circle bg-primary text-white me-3">
                    <i class="bi bi-file-earmark-text"></i>
                </div>
                <h4 class="mb-0">Media Types Configuration</h4>
            </div>
            <hr>
            <div class="alert alert-info py-2 mb-3">
                <i class="bi bi-info-circle-fill me-2"></i> <strong>Info:</strong> Configure file size limits and allowed extensions for different media types.
            </div>
        </div>

        <div class="row">
            <!-- Avatar Configuration -->
            <div class="col-lg-4">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-success text-white me-3">
                                <i class="bi bi-person-circle"></i>
                            </div>
                            <h5 class="card-title mb-0">Avatar Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="media-settings" method="POST" action="{{ route('admin.media.update') }}">
                            @csrf
                            <input type="hidden" name="settings_type" value="avatar_config">
                            
                            <div class="mb-3">
                                <label for="avatar_max_size" class="form-label">Max File Size (KB)</label>
                                <input type="number" class="form-control" id="avatar_max_size" name="avatar_max_size" 
                                       value="{{ setting('avatar_max_size', 2048) }}" min="100" max="10240">
                                <small class="text-muted">Maximum file size for avatar uploads (in KB)</small>
                            </div>

                            <div class="mb-3">
                                <label for="avatar_allowed_extensions" class="form-label">Allowed Extensions</label>
                                <input type="text" class="form-control" id="avatar_allowed_extensions" name="avatar_allowed_extensions" 
                                       value="{{ setting('avatar_allowed_extensions', 'jpg,jpeg,png,gif') }}">
                                <small class="text-muted">Comma-separated list of allowed file extensions</small>
                            </div>

                            <div class="mb-3">
                                <label for="avatar_max_width" class="form-label">Max Width (px)</label>
                                <input type="number" class="form-control" id="avatar_max_width" name="avatar_max_width" 
                                       value="{{ setting('avatar_max_width', 500) }}" min="100" max="2000">
                            </div>

                            <div class="mb-3">
                                <label for="avatar_max_height" class="form-label">Max Height (px)</label>
                                <input type="number" class="form-control" id="avatar_max_height" name="avatar_max_height" 
                                       value="{{ setting('avatar_max_height', 500) }}" min="100" max="2000">
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Avatar Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Cover Image Configuration -->
            <div class="col-lg-4">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-warning text-white me-3">
                                <i class="bi bi-image"></i>
                            </div>
                            <h5 class="card-title mb-0">Cover Image Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="media-settings" method="POST" action="{{ route('admin.media.update') }}">
                            @csrf
                            <input type="hidden" name="settings_type" value="cover_config">
                            
                            <div class="mb-3">
                                <label for="cover_max_size" class="form-label">Max File Size (KB)</label>
                                <input type="number" class="form-control" id="cover_max_size" name="cover_max_size" 
                                       value="{{ setting('cover_max_size', 5120) }}" min="100" max="20480">
                                <small class="text-muted">Maximum file size for cover image uploads (in KB)</small>
                            </div>

                            <div class="mb-3">
                                <label for="cover_allowed_extensions" class="form-label">Allowed Extensions</label>
                                <input type="text" class="form-control" id="cover_allowed_extensions" name="cover_allowed_extensions" 
                                       value="{{ setting('cover_allowed_extensions', 'jpg,jpeg,png') }}">
                                <small class="text-muted">Comma-separated list of allowed file extensions</small>
                            </div>

                            <div class="mb-3">
                                <label for="cover_max_width" class="form-label">Max Width (px)</label>
                                <input type="number" class="form-control" id="cover_max_width" name="cover_max_width" 
                                       value="{{ setting('cover_max_width', 1920) }}" min="100" max="4000">
                            </div>

                            <div class="mb-3">
                                <label for="cover_max_height" class="form-label">Max Height (px)</label>
                                <input type="number" class="form-control" id="cover_max_height" name="cover_max_height" 
                                       value="{{ setting('cover_max_height', 1080) }}" min="100" max="4000">
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Cover Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- General Image Configuration -->
            <div class="col-lg-4">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-info text-white me-3">
                                <i class="bi bi-images"></i>
                            </div>
                            <h5 class="card-title mb-0">General Image Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="media-settings" method="POST" action="{{ route('admin.media.update') }}">
                            @csrf
                            <input type="hidden" name="settings_type" value="image_config">
                            
                            <div class="mb-3">
                                <label for="image_max_size" class="form-label">Max File Size (KB)</label>
                                <input type="number" class="form-control" id="image_max_size" name="image_max_size" 
                                       value="{{ setting('image_max_size', 10240) }}" min="100" max="51200">
                                <small class="text-muted">Maximum file size for general image uploads (in KB)</small>
                            </div>

                            <div class="mb-3">
                                <label for="image_allowed_extensions" class="form-label">Allowed Extensions</label>
                                <input type="text" class="form-control" id="image_allowed_extensions" name="image_allowed_extensions" 
                                       value="{{ setting('image_allowed_extensions', 'jpg,jpeg,png,gif,webp') }}">
                                <small class="text-muted">Comma-separated list of allowed file extensions</small>
                            </div>

                            <div class="mb-3">
                                <label for="image_max_width" class="form-label">Max Width (px)</label>
                                <input type="number" class="form-control" id="image_max_width" name="image_max_width" 
                                       value="{{ setting('image_max_width', 4096) }}" min="100" max="8192">
                            </div>

                            <div class="mb-3">
                                <label for="image_max_height" class="form-label">Max Height (px)</label>
                                <input type="number" class="form-control" id="image_max_height" name="image_max_height" 
                                       value="{{ setting('image_max_height', 4096) }}" min="100" max="8192">
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Image Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Video and Document Configuration -->
        <div class="row">
            <!-- Video Configuration -->
            <div class="col-lg-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-danger text-white me-3">
                                <i class="bi bi-camera-video"></i>
                            </div>
                            <h5 class="card-title mb-0">Video Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="media-settings" method="POST" action="{{ route('admin.media.update') }}">
                            @csrf
                            <input type="hidden" name="settings_type" value="video_config">
                            
                            <div class="mb-3">
                                <label for="video_max_size" class="form-label">Max File Size (KB)</label>
                                <input type="number" class="form-control" id="video_max_size" name="video_max_size" 
                                       value="{{ setting('video_max_size', 102400) }}" min="1000" max="1048576">
                                <small class="text-muted">Maximum file size for video uploads (in KB)</small>
                            </div>

                            <div class="mb-3">
                                <label for="video_allowed_extensions" class="form-label">Allowed Extensions</label>
                                <input type="text" class="form-control" id="video_allowed_extensions" name="video_allowed_extensions" 
                                       value="{{ setting('video_allowed_extensions', 'mp4,avi,mov,wmv,flv') }}">
                                <small class="text-muted">Comma-separated list of allowed file extensions</small>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Video Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Document Configuration -->
            <div class="col-lg-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-secondary text-white me-3">
                                <i class="bi bi-file-earmark-text"></i>
                            </div>
                            <h5 class="card-title mb-0">Document Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="media-settings" method="POST" action="{{ route('admin.media.update') }}">
                            @csrf
                            <input type="hidden" name="settings_type" value="document_config">
                            
                            <div class="mb-3">
                                <label for="document_max_size" class="form-label">Max File Size (KB)</label>
                                <input type="number" class="form-control" id="document_max_size" name="document_max_size" 
                                       value="{{ setting('document_max_size', 51200) }}" min="100" max="204800">
                                <small class="text-muted">Maximum file size for document uploads (in KB)</small>
                            </div>

                            <div class="mb-3">
                                <label for="document_allowed_extensions" class="form-label">Allowed Extensions</label>
                                <input type="text" class="form-control" id="document_allowed_extensions" name="document_allowed_extensions" 
                                       value="{{ setting('document_allowed_extensions', 'pdf,doc,docx,txt,rtf') }}">
                                <small class="text-muted">Comma-separated list of allowed file extensions</small>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Document Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Storage Configuration Link -->
        <div class="col-lg-12 col-md-12 mb-3">
            <div class="alert alert-primary">
                <div class="d-flex align-items-center">
                    <i class="bi bi-cloud-fill me-3 fs-4"></i>
                    <div>
                        <h5 class="mb-1">Storage Configuration</h5>
                        <p class="mb-2">Configure your storage providers (S3, Wasabi, DigitalOcean, etc.) and CDN settings.</p>
                        <a href="{{ route('admin.storage.config') }}" class="btn btn-primary">
                            <i class="bi bi-gear me-1"></i> Configure Storage
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>


</div>
@include('admin.update_settings')
@endsection