@extends('admin.layouts.home')

@section('title', 'Manage Spaces')

@section('content')
<style>
    .min-width-150 {
        min-width: 150px;
    }

    .min-width-200 {
        min-width: 200px;
    }
</style>
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="fas fa-microphone-alt fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Manage Spaces</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('/admin') }}" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Manage Spaces</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards Row -->
        <div class="row mb-4">
            <!-- Total Spaces Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Spaces</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalSpaces ?? 0 }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-microphone-alt fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Active Spaces Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Active Spaces</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $activeSpaces ?? 0 }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="bi bi-check-circle-fill fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Completed Spaces Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Completed Spaces</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $completedSpaces ?? 0 }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="bi bi-check-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Scheduled Spaces Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Scheduled Spaces</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $scheduledSpaces ?? 0 }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="bi bi-clock-fill fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Spaces List Table -->
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">All Spaces</h6>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12">
                        <form action="{{ route('admin.spaces.index') }}" method="GET" class="form-inline bg-white rounded shadow-sm p-3">
                            <div class="d-flex flex-wrap gap-3">
                                <div class="flex-grow-1 min-width-200">
                                    <label class="form-label text-muted small mb-1">Search Spaces</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light border-0"><i class="bi bi-search"></i></span>
                                        <input type="text" name="search" class="form-control border-0 bg-light" placeholder="Search by title, description, or topic..." value="{{ request('search') }}">
                                    </div>
                                </div>
                                <div class="min-width-150">
                                    <label class="form-label text-muted small mb-1">Status</label>
                                    <select name="status" class="form-select border-0 bg-light">
                                        <option value="">All Status</option>
                                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                                        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Completed</option>
                                        <option value="scheduled" {{ request('status') === 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                    </select>
                                </div>
                                <div class="min-width-150">
                                    <label class="form-label text-muted small mb-1">Privacy</label>
                                    <select name="privacy" class="form-select border-0 bg-light">
                                        <option value="">All Privacy</option>
                                        <option value="1" {{ request('privacy') === '1' ? 'selected' : '' }}>Public</option>
                                        <option value="2" {{ request('privacy') === '2' ? 'selected' : '' }}>Followers Only</option>
                                        <option value="3" {{ request('privacy') === '3' ? 'selected' : '' }}>Private</option>
                                    </select>
                                </div>
                                <div class="min-width-150">
                                    <label class="form-label text-muted small mb-1">Sort By</label>
                                    <select name="sort" class="form-select border-0 bg-light">
                                        <option value="newest" {{ request('sort') === 'newest' ? 'selected' : '' }}>Newest First</option>
                                        <option value="oldest" {{ request('sort') === 'oldest' ? 'selected' : '' }}>Oldest First</option>
                                        <option value="members" {{ request('sort') === 'members' ? 'selected' : '' }}>Most Members</option>
                                    </select>
                                </div>
                                <div class="flex-grow-1 min-width-200">
                                    <label class="form-label text-muted small mb-1">Date Range</label>
                                    <div class="d-flex gap-2">
                                        <input type="date" name="date_from" class="form-control border-0 bg-light" value="{{ request('date_from') }}" placeholder="From">
                                        <input type="date" name="date_to" class="form-control border-0 bg-light" value="{{ request('date_to') }}" placeholder="To">
                                    </div>
                                </div>
                                <div class="d-flex gap-2 align-items-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-funnel me-1"></i> Filter
                                    </button>
                                    <a href="{{ route('admin.spaces.index') }}" class="btn btn-light">
                                        <i class="bi bi-x-circle"></i>
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered" id="spacesTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Title</th>
                                <th>Topic</th>
                                <th>Status</th>
                                <th>Privacy</th>
                                <th>Host</th>
                                <th>Members</th>
                                <th>Paid</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($spaces as $space)
                            <tr>
                                <td>{{ $space->id }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div>
                                            <strong>{{ \Str::limit($space->title, 50) }}</strong>
                                            @if($space->description)
                                                <div class="small text-muted">{{ \Str::limit($space->description, 60) }}</div>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ $space->topic ?? 'N/A' }}</span>
                                </td>
                                <td>
                                    @if($space->status === 'active')
                                        <span class="badge bg-success">Active</span>
                                    @elseif($space->status === 'completed')
                                        <span class="badge bg-secondary">Completed</span>
                                    @elseif($space->status === 'scheduled')
                                        <span class="badge bg-warning">Scheduled</span>
                                    @else
                                        <span class="badge bg-dark">{{ ucfirst($space->status) }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($space->privacy == 1)
                                        <span class="badge bg-success">Public</span>
                                    @elseif($space->privacy == 2)
                                        <span class="badge bg-info">Followers Only</span>
                                    @elseif($space->privacy == 3)
                                        <span class="badge bg-warning">Private</span>
                                    @else
                                        <span class="badge bg-secondary">Unknown</span>
                                    @endif
                                </td>
                                <td>
                                    @if($space->user)
                                        <div class="d-flex align-items-center">
                                            <img src="{{ getMedia($space->user->profile_photo) ?? asset('assets/images/default-avatar.png') }}" class="rounded-circle me-2" width="24" height="24" onerror="this.src='{{ asset('assets/images/default-avatar.png') }}'">
                                            <span>{{ $space->user->name }}</span>
                                        </div>
                                    @else
                                        <span class="text-muted">Unknown</span>
                                    @endif
                                </td>
                                <td>{{ $space->members_count ?? 0 }}</td>
                                <td>
                                    @if($space->is_paid)
                                        <span class="badge bg-warning">${{ number_format($space->amount, 2) }}</span>
                                    @else
                                        <span class="badge bg-success">Free</span>
                                    @endif
                                </td>
                                <td>{{ $space->created_at->format('M d, Y') }}</td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.spaces.show', $space->id) }}" class="btn btn-sm btn-info" title="View Details">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="10" class="text-center">No spaces found</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="paginatior mt-3">
                    {{ $spaces->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

