@extends('admin.layouts.home')

@section('title', 'Fake User Generator - Admin Dashboard')

@section('content')
<div class="container-fluid p-0">
    <div class="row mb-3">
        <div class="col">
            <h1 class="h3 mb-1">Fake User Generator</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('admin') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.tools.index') }}">Tools</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Fake User Generator</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6 col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Generate Fake Users</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <div class="d-flex">
                            <i class="fas fa-info-circle fs-4 me-3 align-self-center"></i>
                            <div>
                                <h5 class="alert-heading mb-1">About This Tool</h5>
                                <p class="mb-0">This tool allows you to generate realistic fake users for testing purposes. All generated users will be marked as fake in the database.</p>
                            </div>
                        </div>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <div class="d-flex">
                                <i class="fas fa-check-circle fs-4 me-3 align-self-center"></i>
                                <div>{{ session('success') }}</div>
                            </div>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert">
                            <div class="d-flex">
                                <i class="fas fa-exclamation-circle fs-4 me-3 align-self-center"></i>
                                <div>{{ session('error') }}</div>
                            </div>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <form action="{{ route('admin.tools.generate-fake-users') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="count_users" class="form-label fw-bold">Number of Users to Generate</label>
                            <input type="number" id="count_users" name="count_users" class="form-control @error('count_users') is-invalid @enderror" value="{{ old('count_users', 10) }}" min="1" max="100">
                            <div class="form-text">Enter a number between 1 and 100</div>
                            @error('count_users')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label fw-bold">Password</label>
                            <div class="input-group">
                                <input type="text" id="password" name="password" class="form-control @error('password') is-invalid @enderror" value="{{ old('password') }}" placeholder="123456789">
                                <button class="btn btn-outline-secondary" type="button" id="generate-password">
                                    <i class="fas fa-sync-alt"></i>
                                </button>
                            </div>
                            <div class="form-text">Leave empty to use the default password: 123456789</div>
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label class="form-label fw-bold d-block">Generate Random Avatars</label>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="avatar" id="avatar-yes" value="1" {{ old('avatar') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label" for="avatar-yes">Yes</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="avatar" id="avatar-no" value="0" {{ old('avatar', '0') == '0' ? 'checked' : '' }}>
                                <label class="form-check-label" for="avatar-no">No</label>
                            </div>
                            <div class="form-text">Random avatars will be generated from randomuser.me API</div>
                        </div>

                        <div class="d-flex gap-2 mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-user-plus me-1"></i> Generate Users
                            </button>
                            
                            <a href="{{ route('admin.tools.delete-fake-users') }}" class="btn btn-danger"
                               onclick="return confirm('Are you sure you want to delete all fake users? This action cannot be undone.');">
                                <i class="fas fa-trash-alt me-1"></i> Delete All Fake Users
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-6 col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Fake Users Statistics</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center mb-3">
                        <div class="text-center bg-light p-4 rounded shadow-sm" style="width: 200px; height: 200px; display: flex; flex-direction: column; justify-content: center;">
                            <h2 class="display-4 mb-1" style="font-weight: 600; color: #3498db;">{{ $fakeUsersCount }}</h2>
                            <p class="mb-0 text-muted">Fake Users in Database</p>
                        </div>
                    </div>

                    <div class="alert alert-secondary mb-0">
                        <div class="d-flex">
                            <i class="fas fa-lightbulb fs-4 me-3 align-self-center"></i>
                            <div>
                                <h5 class="alert-heading mb-1">What are Fake Users?</h5>
                                <p class="mb-0">
                                    Fake users are generated accounts that can be used for testing, demonstrations, 
                                    or to populate your platform. All fake users are safely marked in the database 
                                    and can be deleted at any time without affecting real user accounts.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Password generator
    document.getElementById('generate-password').addEventListener('click', function() {
        const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        let password = '';
        for (let i = 0; i < 10; i++) {
            password += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        document.getElementById('password').value = password;
    });
});
</script>
@endsection 