@extends('admin.layouts.home')

@section('title', 'Sitemap Generator')

@section('content')
<div class="container-fluid">
    <div>
        <h3>Sitemap Generator</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('admin') }}">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ route('admin.tools.index') }}">Tools</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Sitemap Generator</li>
            </ol>
        </nav>
    </div>
    
    <div class="row">
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Generate Sitemap</h5>
                    
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> A sitemap helps search engines better understand and crawl your website structure.
                    </div>
                    
                    <form action="{{ route('admin.tools.generate-sitemap') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="frequency" class="form-label">Update Frequency</label>
                            <select name="frequency" id="frequency" class="form-select @error('frequency') is-invalid @enderror" required>
                                <option value="always">Always</option>
                                <option value="hourly">Hourly</option>
                                <option value="daily">Daily</option>
                                <option value="weekly">Weekly</option>
                                <option value="monthly">Monthly</option>
                                <option value="yearly">Yearly</option>
                                <option value="never">Never</option>
                            </select>
                            @error('frequency')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> Generating a sitemap might take some time depending on your website size.
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-sitemap"></i> Generate Sitemap
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Sitemap Information</h5>
                    
                    <div class="list-group">
                        <a href="{{ url('sitemap.xml') }}" class="list-group-item list-group-item-action" target="_blank">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1"><i class="fas fa-file-code"></i> View Current Sitemap</h6>
                                <small><i class="fas fa-external-link-alt"></i></small>
                            </div>
                            <p class="mb-1">Open the current sitemap.xml file in a new tab.</p>
                        </a>
                    </div>
                    
                    <div class="mt-4">
                        <h6>Sitemap Tips</h6>
                        <ul class="list-group">
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Submit your sitemap to search engines
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Update sitemap regularly for new content
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Include only public and important pages
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Set appropriate update frequencies
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection