<!-- User Profile Left Sidebar -->
<div class="card shadow-sm mb-4">
    <div class="card-body text-center">
        <!-- Profile Picture -->
        <div class="position-relative d-inline-block mb-3">
            <img src="{{ $user->avatar ? getMedia($user->avatar) : asset('assets/images/avatar/07.jpg') }}" 
                 alt="{{ $user->first_name }}" 
                 class="rounded-circle" 
                 style="width: 100px; height: 100px; object-fit: cover; border: 3px solid #fff; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
        </div>
        
        <!-- User Name -->
        <h5 class="mb-1">{{ $user->first_name }} {{ $user->last_name }}</h5>
        <p class="text-muted small mb-3">@<span>{{ $user->username }}</span></p>
        
        <!-- Quick Stats -->
        <div class="row text-center mb-3">
            <div class="col-4 border-end">
                <div class="fw-bold text-primary">{{ $friendsCount ?? 0 }}</div>
                <small class="text-muted">Friends</small>
            </div>
            <div class="col-4 border-end">
                <div class="fw-bold text-success">{{ $followersCount ?? 0 }}</div>
                <small class="text-muted">Followers</small>
            </div>
            <div class="col-4">
                <div class="fw-bold text-info">{{ $followingCount ?? 0 }}</div>
                <small class="text-muted">Following</small>
            </div>
        </div>
        
        @if(isset($isOwnProfile) && $isOwnProfile)
        <!-- View/Edit Profile Button -->
        <a href="{{ route('settings.profile') }}" class="btn btn-primary btn-sm w-100">
            <i class="bi bi-pencil me-1"></i> Edit Profile
        </a>
        @endif
    </div>
</div>

<!-- Profile Navigation -->
<div class="card shadow-sm mb-4">
    <div class="list-group list-group-flush">
        <a href="{{ route('user.detail', ['username' => $user->username]) }}" 
           class="list-group-item list-group-item-action d-flex align-items-center {{ request()->is('user/'.$user->username) && !request()->has('tab') ? 'active' : '' }}">
            <i class="bi bi-grid-3x3 me-3"></i>
            <span>Timeline</span>
        </a>
        <a href="{{ route('user.detail', ['username' => $user->username]) }}?tab=about" 
           class="list-group-item list-group-item-action d-flex align-items-center {{ request()->get('tab') == 'about' ? 'active' : '' }}">
            <i class="bi bi-info-circle me-3"></i>
            <span>About</span>
        </a>
        <a href="{{ route('user.detail', ['username' => $user->username]) }}?tab=friends" 
           class="list-group-item list-group-item-action d-flex align-items-center {{ request()->get('tab') == 'friends' ? 'active' : '' }}">
            <i class="bi bi-people me-3"></i>
            <span>Friends</span>
        </a>
        <a href="{{ route('user.detail', ['username' => $user->username]) }}?tab=photos" 
           class="list-group-item list-group-item-action d-flex align-items-center {{ request()->get('tab') == 'photos' ? 'active' : '' }}">
            <i class="bi bi-images me-3"></i>
            <span>Photos</span>
        </a>
    </div>
</div>

<!-- Quick Info Card -->
@if($user->workspace || $user->address || $user->relationship)
<div class="card shadow-sm mb-4">
    <div class="card-header bg-white">
        <h6 class="mb-0"><i class="bi bi-info-circle me-2"></i>Quick Info</h6>
    </div>
    <div class="card-body">
        <div class="list-unstyled mb-0">
            @if($user->workspace)
            <div class="mb-2 d-flex align-items-start">
                <i class="bi bi-briefcase text-primary me-2 mt-1"></i>
                <div>
                    <small class="text-muted d-block">Works at</small>
                    <strong class="small">{{ $user->workspace }}</strong>
                </div>
            </div>
            @endif
            
            @if($user->address)
            <div class="mb-2 d-flex align-items-start">
                <i class="bi bi-geo-alt text-success me-2 mt-1"></i>
                <div>
                    <small class="text-muted d-block">Lives in</small>
                    <strong class="small">{{ $user->address }}</strong>
                </div>
            </div>
            @endif
            
            @if($user->relationship)
            <div class="mb-2 d-flex align-items-start">
                <i class="bi bi-heart text-danger me-2 mt-1"></i>
                <div>
                    <small class="text-muted d-block">Relationship</small>
                    <strong class="small">{{ ucfirst($user->relationship) }}</strong>
                </div>
            </div>
            @endif
            
            @if($user->created_at)
            <div class="mb-0 d-flex align-items-start">
                <i class="bi bi-calendar-check text-info me-2 mt-1"></i>
                <div>
                    <small class="text-muted d-block">Joined</small>
                    <strong class="small">{{ $user->created_at->format('M Y') }}</strong>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endif

<!-- Mutual Friends (if viewing another user's profile) -->
@if(isset($mutualFriendsCount) && $mutualFriendsCount > 0 && isset($isOwnProfile) && !$isOwnProfile)
<div class="card shadow-sm mb-4">
    <div class="card-header bg-white">
        <h6 class="mb-0"><i class="bi bi-people me-2"></i>Mutual Friends</h6>
    </div>
    <div class="card-body">
        <p class="mb-0">You have <strong>{{ $mutualFriendsCount }}</strong> mutual friend{{ $mutualFriendsCount > 1 ? 's' : '' }} with {{ $user->first_name }}</p>
    </div>
</div>
@endif

<!-- Bio Card -->
@if($user->bio)
<div class="card shadow-sm mb-4">
    <div class="card-header bg-white">
        <h6 class="mb-0"><i class="bi bi-chat-quote me-2"></i>Bio</h6>
    </div>
    <div class="card-body">
        <p class="small mb-0">{{ $user->bio }}</p>
    </div>
</div>
@endif

<style>
    .list-group-item.active {
        background-color: #4267B2;
        border-color: #4267B2;
    }
    
    .list-group-item:hover {
        background-color: #f8f9fa;
    }
    
    .list-group-item.active:hover {
        background-color: #365899;
    }
</style>

