@php
// Ensure sidebars are shown unless explicitly disabled in child views
$showLeftSidebar = $showLeftSidebar ?? true;
$showRightSidebar = $showRightSidebar ?? true;

$mainContentClass = match(true) {
$showLeftSidebar && $showRightSidebar => 'col-12 col-md-12 col-lg-6',
$showLeftSidebar || $showRightSidebar => 'col-12 col-md-9 col-lg-9',
default => 'col-md-12'
};
@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <title>@yield('title', 'SocialLink')</title>

    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Webestica.com">
    <meta name="description" content="Bootstrap 5 based Social Media Network and Community Theme">

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- Google Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&amp;display=swap">

    <!-- Plugins CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/vendor/font-awesome/css/all.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/vendor/bootstrap-icons/bootstrap-icons.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/vendor/OverlayScrollbars-master/css/OverlayScrollbars.min.css') }}">

    <!-- Theme CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/style.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/custom.css') }}">
    <!-- Additional Styles from Components -->
    @stack('styles')
    
    <!-- Extra Page-Specific CSS -->
    @yield('extra-css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/plyr/3.8.3/plyr.min.css" integrity="sha512-3DZqJvvs6wAQnnrL13OsEHlNOM8HIgKw+PIm9NSBrT/KDXYyvKRSTRu31SSa5PlfbUzPMBg3b4mD3ojys0qIow==" crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body>
    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay" style="display: none;">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>

    <!-- Header -->
    @include('front_end.components.header')

    <main class="mt-5 pt-3">
        <div class="container">
            <div class="row g-4">
                <!-- Left Sidebar -->
                @if($showLeftSidebar)
                <div class="col-lg-3 sidebar-left">
                    <div class="sidebar-card">
                        @yield('left_sidebar', View::exists('front_end.components.left_sidebar') ? view('front_end.components.left_sidebar') : '')
                    </div>
                </div>
                @endif

                <!-- Main Content -->
                <div class="{{ $mainContentClass }} content-area">
                    <div class="fade-in">
                        @yield('content')
                    </div>
                </div>

                <!-- Right Sidebar -->
                @if($showRightSidebar)
                <div class="col-lg-3 sidebar-right">
                    <div class="sidebar-card">
                        @yield('right_sidebar', View::exists('front_end.components.right_sidebar') ? view('front_end.components.right_sidebar') : '')
                    </div>
                </div>
                @endif
            </div>
        </div>
    </main>

    <!-- Footer -->
    @include('front_end.components.footer')
    
    <script>
        const base_url = "{{ url('/') }}";
    </script>
    
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/plyr/3.8.3/plyr.min.js" integrity="sha512-Eeu7Wo2Jjbcc0N9faybH9EV8Fzoib0EBnibkNSehxBy55KKsR9PMvbGctyLEe3vla6J/UzEft5f2JZ9gYN55AQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        function initPlayers(context = document) {
            console.log("Initializing Plyr players for videos");
            context.querySelectorAll('video').forEach(el => {
                // Destroy existing player if any (to avoid duplicates)
                if (el.plyr) {
                el.plyr.destroy();
                }
                // Create new player
                el.plyr = new Plyr(el, {
                captions: { active: true }
                });
            });

            context.querySelectorAll('audio').forEach(el => {
                if (el.plyr) el.plyr.destroy(); // cleanup if already initialized
                el.plyr = new Plyr(el, {
                controls: ['play', 'progress', 'current-time', 'mute', 'volume','settings']
                });
            });
        }
    </script>
    <script>
        axios.defaults.headers.common['X-CSRF-TOKEN'] = $('meta[name="csrf-token"]').attr('content');
        var user_id = "{{ Auth::id() }}";
        
        // Make user model data available globally for JavaScript
        @if(Auth::check())
        window.user = {
            id: {{ Auth::id() }},
            name: "{{ Auth::user()->name }}",
            username: "{{ Auth::user()->username }}",
            email: "{{ Auth::user()->email }}",
            avatar: "{{ getMedia(Auth::user()->avatar) }}",
            blood_type: "{{ Auth::user()->blood_type ?? '' }}",
            last_donation_date: "{{ Auth::user()->last_donation_date ? Auth::user()->last_donation_date->format('Y-m-d') : '' }}",
            donation_count: {{ Auth::user()->donation_count ?? 0 }},
            latitude: {{ Auth::user()->latitude ?? 'null' }},
            longitude: {{ Auth::user()->longitude ?? 'null' }}
        };
        @else
        window.user = null;
        @endif
        
        // Loading overlay management
        function showLoading() {
            document.getElementById('loadingOverlay').style.display = 'flex';
        }
        
        function hideLoading() {
            document.getElementById('loadingOverlay').style.display = 'none';
        }
        
        // Hide loading overlay when page is fully loaded
        window.addEventListener('load', function() {
            hideLoading();
        });
        
        // Show loading overlay for navigation
        // document.addEventListener('click', function(e) {
        //     if (e.target.tagName === 'A' && e.target.href && !e.target.href.includes('#')) {
        //         showLoading();
        //     }
        // });
        
        // Smooth scroll to top functionality
        function scrollToTop() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }
        
        // Add scroll to top button when scrolling down
        let scrollToTopBtn = null;
        
        window.addEventListener('scroll', function() {
            if (window.pageYOffset > 300) {
                if (!scrollToTopBtn) {
                    scrollToTopBtn = document.createElement('button');
                    scrollToTopBtn.innerHTML = '<i class="bi bi-arrow-up"></i>';
                    scrollToTopBtn.className = 'btn btn-primary position-fixed';
                    scrollToTopBtn.style.cssText = 'bottom: 20px; right: 20px; z-index: 1000; border-radius: 50%; width: 50px; height: 50px; box-shadow: 0 4px 12px rgba(0,0,0,0.15);';
                    scrollToTopBtn.addEventListener('click', scrollToTop);
                    document.body.appendChild(scrollToTopBtn);
                }
                scrollToTopBtn.style.display = 'block';
            } else if (scrollToTopBtn) {
                scrollToTopBtn.style.display = 'none';
            }
        });
    </script>

    <!-- Theme Functions -->
    <script src="{{ asset('assets/js/functions.js') }}"></script>

    <!-- Additional Scripts from Components -->
    @stack('scripts')

    <!-- Extra Page-Specific JS -->
    @yield('extra-js')
    
</body>

</html>