@extends('front_end.layouts.auth')

@section('title', 'Forgot Password - Socialink')

@section('content')
<div class="auth-page d-flex align-items-center py-5">
    <div class="auth-inner container">
        <div class="row justify-content-between align-items-center">
            <div class="col-lg-6 col-xl-7 mb-5 mb-lg-0">
                <div class="brand-panel">
                    <img src="{{ asset('assets/images/logo.png') }}" alt="Socialink" class="brand-mark mb-3">
                    <h1 class="brand-heading">We’ve got your back&mdash;reset your password and jump back in.</h1>
                    <p class="brand-tagline">Recovery keeps your conversations, groups, and memories protected.</p>

                    <div class="brand-highlight">
                        <div class="brand-highlight-icon">
                            <i class="fas fa-shield-heart"></i>
                        </div>
                        <div class="brand-highlight-text">
                            <strong>Secure recovery in a few taps.</strong>
                            <span>We verify every request to keep your data locked to you.</span>
                        </div>
                    </div>

                    <div class="stats-glance">
                        <div class="glance-card">
                            <span class="label">Recovery success</span>
                            <span class="value">99.2%</span>
                            <span class="subtext">links delivered within the first minute</span>
                        </div>
                        <div class="glance-card">
                            <span class="label">Devices protected</span>
                            <span class="value">5.6M</span>
                            <span class="subtext">sessions secured with intelligent checks</span>
                        </div>
                    </div>

                    <div class="trust-badges">
                        <div class="trust-avatars">
                            <span class="trust-avatar variant-blue">KT</span>
                            <span class="trust-avatar variant-green">RB</span>
                            <span class="trust-avatar variant-purple">SH</span>
                            <span class="trust-avatar variant-orange">YL</span>
                        </div>
                        <div class="trust-meta">Support specialists available <strong>24/7</strong> if you ever need a hand.</div>
                    </div>
                </div>
            </div>

            <div class="col-lg-5 col-xl-4">
                <div class="auth-card card border-0 shadow-sm">
                    <div class="card-body">
                        <h2 class="card-title text-center mb-2">Find your account</h2>
                        <p class="auth-subtitle text-center mb-4">
                            Enter the email associated with your account and we’ll send you a secure reset link.
                        </p>

                        @if (session('status'))
                            <div class="alert alert-success">{{ session('status') }}</div>
                        @endif

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form method="POST" action="{{ route('password.email') }}" novalidate>
                            @csrf
                            <div class="mb-3">
                                <label for="reset-email" class="form-label text-secondary mb-1">Email address</label>
                                <input type="email"
                                       class="form-control"
                                       id="reset-email"
                                       name="email"
                                       placeholder="Enter your email address"
                                       value="{{ old('email') }}"
                                       required>
                            </div>

                            <button type="submit" class="btn btn-primary w-100">Send reset link</button>
                        </form>

                        <p class="text-center text-secondary mt-4 mb-0">
                            <a href="{{ url('login') }}" class="link-blue text-decoration-none">Back to login</a>
                        </p>
                    </div>
                </div>
                <div class="auth-card-secondary mt-3">
                    <div class="headline">Keep access effortless</div>
                    <div class="subline">Turn on two-factor authentication once you’re back in to make future logins even smoother.</div>
                    <a href="{{ url('login') }}" class="btn btn-outline-primary w-100">Return to login</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
