@extends('front_end.layouts.auth')

@section('title', 'Login - Socialink')

@section('content')
<div class="auth-page d-flex align-items-center py-5">
    <div class="auth-inner container">
        <div class="row justify-content-between align-items-center">
            <div class="col-lg-6 col-xl-7 mb-5 mb-lg-0">
                <div class="brand-panel">
                    <img src="{{ asset('assets/images/logo.png') }}" alt="Socialink" class="brand-mark mb-3">
                    <h1 class="brand-heading">Connect in a refreshed social space built around the people and topics you love.</h1>
                    <p class="brand-tagline">Socialink blends effortless sharing, intelligent discovery, and privacy-first controls.</p>

                    <div class="brand-highlight">
                        <div class="brand-highlight-icon">
                            <i class="fas fa-handshake-angle"></i>
                        </div>
                        <div class="brand-highlight-text">
                            <strong>Stay close to what matters.</strong>
                            <span>Pick up conversations and memories exactly where you left them on any device.</span>
                        </div>
                    </div>

                    <div class="stats-glance">
                        <div class="glance-card">
                            <span class="label">Daily conversations</span>
                            <span class="value">84K</span>
                            <span class="subtext">shared between friends yesterday</span>
                        </div>
                        <div class="glance-card">
                            <span class="label">Communities active</span>
                            <span class="value">12.5K</span>
                            <span class="subtext">groups and circles buzzing right now</span>
                        </div>
                    </div>

                    <div class="trust-badges">
                        <div class="trust-avatars">
                            <span class="trust-avatar variant-blue">AL</span>
                            <span class="trust-avatar variant-green">JP</span>
                            <span class="trust-avatar variant-purple">MS</span>
                            <span class="trust-avatar variant-orange">ZT</span>
                        </div>
                        <div class="trust-meta">Trusted by <strong>2M+ members</strong> worldwide.</div>
                    </div>
                </div>
            </div>

            <div class="col-lg-5 col-xl-4">
                <div class="auth-card card border-0 shadow-sm">
                    <div class="card-body">
                        <h2 class="card-title text-center mb-4">Log in to Socialink</h2>

                        @if(session('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @endif

                        @if(session('error'))
                            <div class="alert alert-danger">{{ session('error') }}</div>
                        @endif

                        @if(session('status'))
                            <div class="alert alert-info">{{ session('status') }}</div>
                        @endif

                        @php
                            $settings = \App\Models\Setting::getSettings();

                            $settingAliases = [
                                'chck-facebookLogin'   => 'facebookLogin',
                                'chck-VkontakteLogin'  => 'VkontakteLogin',
                                'chck-googleLogin'     => 'googleLogin',
                                'chck-twitterLogin'    => 'twitterLogin',
                                'chck-linkedinLogin'   => 'linkedinLogin',
                                'chck-instagramLogin'  => 'instagramLogin',
                                'chck-qqLogin'         => 'qqLogin',
                                'chck-WeChatLogin'     => 'WeChatLogin',
                                'chck-DiscordLogin'    => 'DiscordLogin',
                                'chck-MailruLogin'     => 'MailruLogin',
                                'chck-OkLogin'         => 'OkLogin',
                                'chck-tiktok_login'    => 'tiktok_login',
                                'chck-wordpress_login' => 'wordpressLogin',
                                'facebookAppId'        => 'facebook_client_id',
                                'facebookAppKey'       => 'facebook_client_secret',
                            ];

                            $resolveSetting = static function (string $key) use (&$settings, $settingAliases) {
                                $value = $settings[$key] ?? null;

                                if (($value === null || $value === '') && isset($settingAliases[$key])) {
                                    $aliasKey = $settingAliases[$key];
                                    $value = $settings[$aliasKey] ?? null;
                                }

                                if ($value === null || $value === '') {
                                    $value = setting($key);

                                    if ($value !== null && $value !== '') {
                                        $settings[$key] = $value;
                                    } elseif (isset($settingAliases[$key])) {
                                        $aliasKey = $settingAliases[$key];
                                        $aliasValue = setting($aliasKey);

                                        if ($aliasValue !== null && $aliasValue !== '') {
                                            $settings[$aliasKey] = $aliasValue;
                                            $value = $aliasValue;
                                        }
                                    }
                                }

                                return $value;
                            };

                            $toggleEnabled = static function ($value): bool {
                                if (is_bool($value)) {
                                    return $value;
                                }

                                if (is_numeric($value)) {
                                    return (bool) ((int) $value);
                                }

                                $normalized = strtolower((string) $value);

                                return in_array($normalized, ['1', 'true', 'yes', 'on'], true);
                            };

                            $socialProviders = [
                                'facebook' => [
                                    'label' => 'Continue with Facebook',
                                    'icon' => 'fab fa-facebook-f',
                                    'class' => 'facebook-btn',
                                    'toggle' => 'chck-facebookLogin',
                                    'credentials' => ['facebookAppId', 'facebookAppKey'],
                                ],
                                'google' => [
                                    'label' => 'Continue with Google',
                                    'icon' => 'fab fa-google',
                                    'class' => 'google-btn',
                                    'toggle' => 'chck-googleLogin',
                                    'credentials' => ['googleAppId', 'googleAppKey'],
                                ],
                                'twitter' => [
                                    'label' => 'Continue with Twitter',
                                    'icon' => 'fab fa-twitter',
                                    'class' => 'twitter-btn',
                                    'toggle' => 'chck-twitterLogin',
                                    'credentials' => ['twitterAppId', 'twitterAppKey'],
                                ],
                                'linkedin' => [
                                    'label' => 'Continue with LinkedIn',
                                    'icon' => 'fab fa-linkedin-in',
                                    'class' => 'linkedin-btn',
                                    'toggle' => 'chck-linkedinLogin',
                                    'credentials' => ['linkedinAppId', 'linkedinAppKey'],
                                ],
                                'vkontakte' => [
                                    'label' => 'Continue with VKontakte',
                                    'icon' => 'fab fa-vk',
                                    'class' => 'vkontakte-btn',
                                    'toggle' => 'chck-VkontakteLogin',
                                    'credentials' => ['VkontakteAppId', 'VkontakteAppKey'],
                                ],
                                'instagram' => [
                                    'label' => 'Continue with Instagram',
                                    'icon' => 'fab fa-instagram',
                                    'class' => 'instagram-btn',
                                    'toggle' => 'chck-instagramLogin',
                                    'credentials' => ['instagramAppId', 'instagramAppkey'],
                                ],
                                'qq' => [
                                    'label' => 'Continue with QQ',
                                    'icon' => 'fab fa-qq',
                                    'class' => 'qq-btn',
                                    'toggle' => 'chck-qqLogin',
                                    'credentials' => ['qqAppId', 'qqAppkey'],
                                ],
                                'wechat' => [
                                    'label' => 'Continue with WeChat',
                                    'icon' => 'fab fa-weixin',
                                    'class' => 'wechat-btn',
                                    'toggle' => 'chck-WeChatLogin',
                                    'credentials' => ['WeChatAppId', 'WeChatAppkey'],
                                ],
                                'discord' => [
                                    'label' => 'Continue with Discord',
                                    'icon' => 'fab fa-discord',
                                    'class' => 'discord-btn',
                                    'toggle' => 'chck-DiscordLogin',
                                    'credentials' => ['DiscordAppId', 'DiscordAppkey'],
                                ],
                                'mailru' => [
                                    'label' => 'Continue with Mail.ru',
                                    'icon' => 'fas fa-envelope',
                                    'class' => 'mailru-btn',
                                    'toggle' => 'chck-MailruLogin',
                                    'credentials' => ['MailruAppId', 'MailruAppkey'],
                                ],
                                'odnoklassniki' => [
                                    'label' => 'Continue with OK.ru',
                                    'icon' => 'fab fa-odnoklassniki',
                                    'class' => 'odnoklassniki-btn',
                                    'toggle' => 'chck-OkLogin',
                                    'credentials' => ['OkAppId', 'OkAppSecretkey', 'OkAppPublickey'],
                                ],
                                'tiktok' => [
                                    'label' => 'Continue with TikTok',
                                    'icon' => 'fab fa-tiktok',
                                    'class' => 'tiktok-btn',
                                    'toggle' => 'chck-tiktok_login',
                                    'credentials' => ['tiktok_client_key', 'tiktok_client_secret'],
                                ],
                                'wordpress' => [
                                    'label' => 'Continue with WordPress',
                                    'icon' => 'fab fa-wordpress',
                                    'class' => 'wordpress-btn',
                                    'toggle' => 'chck-wordpress_login',
                                    'credentials' => ['WordPressAppId', 'WordPressAppkey'],
                                ],
                            ];

                            $availableSocialProviders = collect($socialProviders)->filter(function ($meta) use ($resolveSetting, $toggleEnabled) {
                                $toggleValue = $resolveSetting($meta['toggle']);

                                if (!$toggleEnabled($toggleValue)) {
                                    return false;
                                }

                                foreach ($meta['credentials'] as $settingKey) {
                                    $credentialValue = $resolveSetting($settingKey);

                                    if ($credentialValue === null || $credentialValue === '') {
                                        return false;
                                    }
                                }

                                return true;
                            });
                        @endphp

                        @if($availableSocialProviders->isNotEmpty())
                            <div class="social-login">
                                @foreach($availableSocialProviders as $provider => $meta)
                                    <a href="{{ route('social.login', ['provider' => $provider]) }}" class="social-btn {{ $meta['class'] }}">
                                        <i class="{{ $meta['icon'] }}"></i> {{ $meta['label'] }}
                                    </a>
                                @endforeach
                            </div>
                        @endif

                        <div class="divider">
                            <span>or</span>
                        </div>

                        <form method="POST" action="{{ route('login') }}" novalidate>
                            @csrf

                            <div class="mb-3">
                                <label for="email" class="form-label text-secondary mb-1">Email address</label>
                                <input type="email"
                                       name="email"
                                       id="email"
                                       class="form-control @error('email') is-invalid @enderror"
                                       placeholder="Email address"
                                       value="{{ old('email', 'admin@admin.com') }}"
                                       required>
                                @error('email')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3 position-relative password-field">
                                <label for="password" class="form-label text-secondary mb-1">Password</label>
                                <input type="password"
                                       name="password"
                                       id="password"
                                       class="form-control @error('password') is-invalid @enderror"
                                       placeholder="Password"
                                       value="secret"
                                       required>
                                <i class="fas fa-eye-slash password-toggle" role="button" aria-label="Toggle password visibility"></i>
                                @error('password')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember">
                                    <label class="form-check-label" for="remember">Remember me</label>
                                </div>
                                <a href="{{ url('forgot-password') }}" class="link-blue text-decoration-none">Forgotten password?</a>
                            </div>

                            <button type="submit" class="btn btn-primary w-100">Log In</button>
                        </form>

                   
                    </div>
                </div>

                <div class="auth-card-secondary text-center mt-3">
                    <a href="{{ url('register') }}" class="btn btn-create-account px-4">Create new account</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
