<div class="card rounded-lg shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary text-white py-3">
        <h5 class="mb-0 font-weight-bold text-white">{{ __('Search Blogs') }}</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('blogs.index') }}" method="GET">
            <div class="input-group">
                <input type="text" class="form-control" name="search" placeholder="{{ __('Search blogs...') }}"
                    value="{{ request('search') }}">
                <div class="input-group-append">
                    <button class="btn btn-primary" type="submit">
                        <i class="bi bi-search"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

@if (isset($categories) && count($categories) > 0)
    <div class="card rounded-lg shadow-sm mb-4 border-0">
        <div class="card-header bg-gradient-primary text-white py-3">
            <h5 class="mb-0 font-weight-bold text-white">{{ __('Categories') }}</h5>
        </div>
        <div class="card-body p-0">
            <ul class="list-group list-group-flush">
                @forelse($categories as $category)
                    <li
                        class="list-group-item border-left-0 border-right-0 d-flex justify-content-between align-items-center py-3 {{ isset($slug) && $slug == $category->slug ? 'active' : '' }}">
                        <a href="{{ route('blogs.category', $category->slug) }}"
                            class="text-decoration-none text-dark font-weight-medium">
                            <i
                                class="bi bi-tag-fill mr-2   {{ isset($slug) && $slug == $category->slug ? 'text-light' : 'text-primary' }}"></i>
                            {{ $category->name }}
                        </a>
                        <span class="badge bg-primary badge-pill">
                            {{ App\Models\Blog::where('category', $category->id)->count() }}
                        </span>
                    </li>
                @empty
                    <li class="list-group-item border-left-0 border-right-0 text-center py-3">
                        No categories found
                    </li>
                @endforelse
            </ul>
        </div>
    </div>
@endif

<div class="card rounded-lg shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary text-white py-3">
        <h5 class="mb-0 font-weight-bold">Recent Posts</h5>
    </div>
    <div class="card-body p-0">
        <ul class="list-group list-group-flush">
            @foreach (App\Models\Blog::where('active', true)->latest()->take(5)->get() as $recentBlog)
                <li class="list-group-item border-left-0 border-right-0 py-3">
                    <div class="d-flex">
                        @if ($recentBlog->thumbnail)
                            <div class="flex-shrink-0 mr-3">
                                <img src="{{ asset('storage/' . $recentBlog->thumbnail) }}"
                                    alt="{{ $recentBlog->title }}" class="rounded"
                                    style="width: 60px; height: 60px; object-fit: cover;">
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">
                                <a href="{{ route('blogs.show', $recentBlog->slug) }}"
                                    class="text-decoration-none text-dark">
                                    {{ Str::limit($recentBlog->title, 50) }}
                                </a>
                            </h6>
                            <small class="text-muted">
                                <i class="bi bi-calendar-date mr-1"></i>
                                {{ $recentBlog->created_at->format('M d, Y') }}
                            </small>
                        </div>
                    </div>
                </li>
            @endforeach
        </ul>
    </div>
</div>
