@extends('front_end.layouts.home')

@php
    $showRightSidebar = false;
@endphp

@section('left_sidebar')
    @include('front_end.pages.blogs.blogs_left_sidebar')
@endsection

@section('title', 'Blog')

@section('content')
    <div class="container py-4">
        <div class="mb-4 bg-gradient-primary text-white p-4 rounded-lg shadow-sm">
            <h1 class="h2 mb-2 font-weight-bold text-white">{{ __('Our Blog') }}</h1>
            <p class="lead mb-0">{{ __('Stay updated with the latest news, tips, and insights') }}</p>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="row">
                    @forelse($result as $blog)
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="card h-100 border-0 shadow-sm rounded-lg hover-shadow transition-300">
                                <div class="position-relative">
                                    @if ($blog->thumbnail)
                                        <img src="{{ asset('storage/' . $blog->thumbnail) }}"
                                            class="card-img-top rounded-top" alt="{{ $blog->title }}"
                                            style="height: 200px; object-fit: cover;">
                                    @else
                                        <div class="bg-light text-center py-5 rounded-top">
                                            <i class="bi bi-image text-muted" style="font-size: 3rem;"></i>
                                        </div>
                                    @endif
                                    <div class="position-absolute top-0 end-0 p-2">
                                        @if ($blog->category_id && $blog->category)
                                            <span class="badge bg-primary px-3 py-2 rounded-pill shadow-sm">
                                                {{ $blog->category->name }}
                                            </span>
                                        @else
                                            <span class="badge bg-secondary px-3 py-2 rounded-pill shadow-sm">
                                                {{ __('Uncategorized') }}
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title font-weight-bold">{{ $blog->title }}</h5>
                                    <p class="card-text text-muted flex-grow-1">{{ Str::limit($blog->description, 120) }}
                                    </p>
                                    <div class="d-flex justify-content-between align-items-center mt-3">
                                        <small class="text-muted">
                                            <i class="bi bi-calendar-date mr-1"></i>
                                            {{ $blog->created_at->format('M d, Y') }}
                                        </small>
                                        <a href="{{ route('blogs.show', $blog->slug) }}"
                                            class="btn btn-sm btn-outline-primary rounded-pill px-3">
                                            {{ __('Read More') }} <i class="bi bi-arrow-right ml-1"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12">
                            <div class="alert alert-info shadow-sm">
                                <i class="bi bi-info-circle mr-2"></i> No blog posts found.
                            </div>
                        </div>
                    @endforelse
                </div>

                <div class="d-flex justify-content-center mt-4">
                    {{ $result->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>

    <style>
        .hover-shadow {
            transition: all 0.3s ease;
        }

        .hover-shadow:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1) !important;
        }

        .transition-300 {
            transition: all 0.3s ease;
        }

        .bg-gradient-primary {
            background: linear-gradient(45deg, #4e73df, #2e59d9);
        }
    </style>
@endsection
