<!-- Responsive Sidebar Toggle -->
<div class="d-flex align-items-center d-lg-none">
    <button class="border-0 bg-transparent" type="button" data-bs-toggle="offcanvas"
        data-bs-target="#offcanvasSideNavbar" aria-controls="offcanvasSideNavbar">
        <span class="btn btn-primary"><i class="bi bi-list"></i></span>
        <span class="h6 mb-0 fw-bold d-lg-none ms-2">BloodBank Menu</span>
    </button>
</div>

<!-- Sidebar Navigation -->
<nav class="navbar navbar-expand-lg mx-0">
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSideNavbar">
        <!-- Offcanvas Header -->
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">BloodBank Menu</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>

        <!-- Offcanvas Body -->
        <div class="offcanvas-body d-block px-2 px-lg-0">
            <!-- Menu START -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-body p-3">
                    <ul class="nav flex-column fw-bold gap-2">
                        <!-- BloodBank Main Menu -->
                        <li class="nav-title">BloodBank</li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center {{ request()->routeIs('bloodbank.index') ? 'active' : '' }}" href="{{ route('bloodbank.index') }}">
                                <i class="bi bi-house-heart text-danger me-2"></i><span>Dashboard</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center {{ request()->routeIs('bloodbank.requests') || request()->routeIs('bloodbank.requests.show') ? 'active' : '' }}" href="{{ route('bloodbank.requests') }}">
                                <i class="bi bi-droplet text-danger me-2"></i><span>Blood Requests</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center {{ request()->routeIs('bloodbank.drives') || request()->routeIs('bloodbank.drives.show') ? 'active' : '' }}" href="{{ route('bloodbank.drives') }}">
                                <i class="bi bi-calendar-event text-danger me-2"></i><span>Blood Drives</span>
                            </a>
                        </li>
                        @auth
                        <li class="nav-title mt-2">Your Actions</li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center {{ request()->routeIs('bloodbank.donate') ? 'active' : '' }}" href="{{ route('bloodbank.donate') }}">
                                <i class="bi bi-heart-pulse text-danger me-2"></i><span>Donate Blood</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center {{ request()->routeIs('bloodbank.request') ? 'active' : '' }}" href="{{ route('bloodbank.request') }}">
                                <i class="bi bi-plus-circle text-danger me-2"></i><span>Request Blood</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center {{ request()->routeIs('bloodbank.profile') ? 'active' : '' }}" href="{{ route('bloodbank.profile') }}">
                                <i class="bi bi-person-badge text-danger me-2"></i><span>Donor Profile</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center {{ request()->routeIs('bloodbank.donors') ? 'active' : '' }}" href="{{ route('bloodbank.donors') }}">
                                <i class="bi bi-people text-danger me-2"></i><span>Nearby Donors</span>
                            </a>
                        </li>
                        @endauth
                    </ul>
                </div>
            </div>
            
            <!-- Blood Type Compatibility Chart -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-header border-0 bg-danger bg-opacity-10">
                    <h6 class="mb-0 text-danger fw-bold">Blood Type Compatibility</h6>
                </div>
                <div class="card-body p-3">
                    <div class="small">
                        <div class="fw-bold mb-2">Universal Donors & Recipients</div>
                        <p class="mb-2"><span class="badge bg-danger me-1">O-</span> Can donate to all blood types</p>
                        <p class="mb-3"><span class="badge bg-danger me-1">AB+</span> Can receive from all blood types</p>
                        
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-center">Blood Type</th>
                                        <th class="text-center">Can Donate To</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">O-</span></td>
                                        <td class="text-center small">O-, O+, A-, A+, B-, B+, AB-, AB+</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">O+</span></td>
                                        <td class="text-center small">O+, A+, B+, AB+</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">A-</span></td>
                                        <td class="text-center small">A-, A+, AB-, AB+</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">A+</span></td>
                                        <td class="text-center small">A+, AB+</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">B-</span></td>
                                        <td class="text-center small">B-, B+, AB-, AB+</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">B+</span></td>
                                        <td class="text-center small">B+, AB+</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">AB-</span></td>
                                        <td class="text-center small">AB-, AB+</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><span class="badge bg-danger">AB+</span></td>
                                        <td class="text-center small">AB+ only</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Did You Know? -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-header border-0 bg-danger bg-opacity-10">
                    <h6 class="mb-0 text-danger fw-bold">Did You Know?</h6>
                </div>
                <div class="card-body p-3">
                    <div class="small">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-droplet-fill text-danger me-2"></i>
                            <span>One donation can save up to three lives.</span>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-clock text-danger me-2"></i>
                            <span>You can donate blood every 56 days.</span>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-clipboard-heart text-danger me-2"></i>
                            <span>Blood donation takes only 10-15 minutes.</span>
                        </div>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-heart text-danger me-2"></i>
                            <span>The human body replaces plasma within 24 hours.</span>
                        </div>
                    </div>
                </div>
            </div>
            
            @include('front_end.components.footer_left_sidebar')
        </div>
    </div>
</nav>