@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', $category->name . ' Courses')

@section('left_sidebar')
@include('front_end.pages.courses.courses_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('courses.index') }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">{{ $category->name }} Courses</h4>
                                <p class="mb-0 text-white">{{ $courses->total() }} courses available</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <!-- Category Description -->
        @if($category->description)
        <div class="card border-0 shadow-sm mb-5">
            <div class="card-body p-4">
                <div class="d-flex align-items-center mb-3">
                    <div class="rounded-circle bg-primary bg-opacity-10 p-3 me-3" style="width: 60px; height: 60px;">
                        <i class="{{ $category->icon ?? 'fas fa-bookmark' }} fa-2x text-primary"></i>
                    </div>
                    <div>
                        <h4 class="mb-0">{{ $category->name }}</h4>
                        <p class="text-muted mb-0">{{ $courses->total() }} courses</p>
                    </div>
                </div>
                <p class="mb-0">{{ $category->description }}</p>
            </div>
        </div>
        @endif

        <!-- Courses Grid -->
        <div class="row">
            <!-- Filter/Sort Options -->
            <div class="col-12 mb-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-3">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <p class="mb-md-0">Showing {{ $courses->firstItem() ?? 0 }}-{{ $courses->lastItem() ?? 0 }} of {{ $courses->total() }} courses</p>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex justify-content-md-end">
                                    <form action="{{ route('courses.category', $category->slug) }}" method="GET" class="d-flex align-items-center">
                                        <label for="sort" class="form-label w-50 me-2">Sort by:</label>
                                        <select class="form-select form-select-sm " name="sort" id="sort" onchange="this.form.submit()">
                                            <option value="popularity" {{ request('sort') == 'popularity' ? 'selected' : '' }}>Most Popular</option>
                                            <option value="rating" {{ request('sort') == 'rating' ? 'selected' : '' }}>Highest Rated</option>
                                            <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>Newest</option>
                                            <option value="price_low" {{ request('sort') == 'price_low' ? 'selected' : '' }}>Price: Low to High</option>
                                            <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Price: High to Low</option>
                                        </select>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if($courses->count() > 0)
                @foreach($courses as $course)
                <div class="col-md-6 col-lg-4 mb-4">
                    @include('front_end.pages.courses.partials.course_card', ['course' => $course])
                </div>
                @endforeach
            @else
                <div class="col-12">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body p-5 text-center">
                            <i class="fas fa-book-open fa-3x text-muted mb-3"></i>
                            <h4>No courses found</h4>
                            <p class="text-muted mb-4">There are no courses in this category yet.</p>
                            <a href="{{ route('courses.index') }}" class="btn btn-primary">Browse All Courses</a>
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Pagination -->
        @if($courses->hasPages())
        <div class="d-flex justify-content-center mt-4">
            {{ $courses->links('pagination::bootstrap-5') }}
        </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize star rating
        $('.course-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
    });
</script>
@endpush
@endsection