@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Search Courses')

@section('left_sidebar')
@include('front_end.pages.courses.courses_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('courses.index') }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">Search Courses</h4>
                                <p class="mb-0 text-white">
                                    {{ $courses->total() }} courses found
                                    @if($query) for "{{ $query }}" @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <div class="row">
            <!-- Filters Sidebar -->
            <div class="col-lg-3 mb-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <h5 class="mb-3">Filters</h5>
                        <form action="{{ route('courses.search') }}" method="GET" id="searchFilterForm">
                            <!-- Search Box -->
                            <div class="mb-4">
                                <label for="query" class="form-label">Search Term</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="query" name="query" value="{{ $query }}" placeholder="Course title or keyword">
                                    <button class="btn btn-primary" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>

                            <!-- Categories -->
                            <div class="mb-4">
                                <label class="form-label">Category</label>
                                <select class="form-select" name="category" id="category">
                                    <option value="">All Categories</option>
                                    @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}" {{ $category == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Price Range -->
                            <div class="mb-4">
                                <label class="form-label">Price</label>
                                <div class="d-flex flex-wrap gap-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="price" id="price_all" value="" {{ !$price ? 'checked' : '' }}>
                                        <label class="form-check-label" for="price_all">All</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="price" id="price_free" value="free" {{ $price == 'free' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="price_free">Free</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="price" id="price_paid" value="paid" {{ $price == 'paid' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="price_paid">Paid</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Level -->
                            <div class="mb-4">
                                <label class="form-label">Level</label>
                                <div class="d-flex flex-wrap gap-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="level" id="level_all" value="" {{ !$level ? 'checked' : '' }}>
                                        <label class="form-check-label" for="level_all">All Levels</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="level" id="level_beginner" value="beginner" {{ $level == 'beginner' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="level_beginner">Beginner</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="level" id="level_intermediate" value="intermediate" {{ $level == 'intermediate' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="level_intermediate">Intermediate</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="level" id="level_advanced" value="advanced" {{ $level == 'advanced' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="level_advanced">Advanced</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Rating -->
                            <div class="mb-4">
                                <label class="form-label">Rating</label>
                                <div class="d-flex flex-column gap-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="rating" id="rating_all" value="" {{ !$rating ? 'checked' : '' }}>
                                        <label class="form-check-label" for="rating_all">All Ratings</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="rating" id="rating_4plus" value="4" {{ $rating == '4' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="rating_4plus">
                                            <div class="text-warning">
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="far fa-star"></i> & up
                                            </div>
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="rating" id="rating_3plus" value="3" {{ $rating == '3' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="rating_3plus">
                                            <div class="text-warning">
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="far fa-star"></i>
                                                <i class="far fa-star"></i> & up
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Sort By -->
                            <div class="mb-4">
                                <label for="sort" class="form-label">Sort By</label>
                                <select class="form-select" name="sort" id="sort">
                                    <option value="popularity" {{ $sort == 'popularity' ? 'selected' : '' }}>Most Popular</option>
                                    <option value="rating" {{ $sort == 'rating' ? 'selected' : '' }}>Highest Rated</option>
                                    <option value="newest" {{ $sort == 'newest' ? 'selected' : '' }}>Newest</option>
                                    <option value="price_low" {{ $sort == 'price_low' ? 'selected' : '' }}>Price: Low to High</option>
                                    <option value="price_high" {{ $sort == 'price_high' ? 'selected' : '' }}>Price: High to Low</option>
                                </select>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">Apply Filters</button>
                                <a href="{{ route('courses.search') }}" class="btn btn-outline-secondary">Reset</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Courses Grid -->
            <div class="col-lg-9">
                @if($courses->count() > 0)
                    <div class="row g-4">
                        @foreach($courses as $course)
                        <div class="col-md-6 col-lg-4">
                            @include('front_end.pages.courses.partials.course_card', ['course' => $course])
                        </div>
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-5">
                        {{ $courses->links('pagination::bootstrap-5') }}
                    </div>
                @else
                    <div class="card border-0 shadow-sm">
                        <div class="card-body p-5 text-center">
                            <i class="fas fa-search fa-3x text-muted mb-3"></i>
                            <h4>No courses found</h4>
                            <p class="text-muted mb-4">We couldn't find any courses matching your criteria.</p>
                            <a href="{{ route('courses.index') }}" class="btn btn-primary">Browse All Courses</a>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Auto-submit form when certain filters change
        $('#category, #sort').on('change', function() {
            $('#searchFilterForm').submit();
        });

        // Initialize star rating
        $('.course-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
    });
</script>
@endpush
@endsection