@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', $course->title)

@section('left_sidebar')
@include('front_end.pages.courses.courses_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Course Header Section -->
    <div class="card border-0">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-dark text-white p-5 rounded-top-3 position-relative">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-8">
                                    <nav aria-label="breadcrumb">
                                        <ol class="breadcrumb mb-3">
                                            <li class="breadcrumb-item"><a href="{{ route('courses.index') }}" class="text-white-50">Courses</a></li>
                                            <li class="breadcrumb-item"><a href="{{ route('courses.category', $course->category->slug) }}" class="text-white-50">{{ $course->category->name }}</a></li>
                                            <li class="breadcrumb-item active text-white" aria-current="page">{{ $course->title }}</li>
                                        </ol>
                                    </nav>
                                    <h1 class="mb-3">{{ $course->title }}</h1>
                                    <p class="lead mb-4">{{ Str::limit($course->description, 150) }}</p>
                                    
                                    <div class="d-flex flex-wrap align-items-center mb-4">
                                        <div class="me-4 mb-2">
                                            <div class="d-flex align-items-center">
                                                <div class="text-warning">
                                                    <div class="course-rating" data-rating="{{ $course->average_rating }}"></div>
                                                </div>
                                                <span class="ms-2 text-white">{{ number_format($course->average_rating, 1) }} ({{ $course->reviews_count ?? 0 }} reviews)</span>
                                            </div>
                                        </div>
                                        <div class="me-4 mb-2">
                                            <i class="fas fa-users me-2"></i>
                                            <span>{{ $course->total_students }} students</span>
                                        </div>
                                        <div class="me-4 mb-2">
                                            <i class="fas fa-level-up-alt me-2"></i>
                                            <span>{{ ucfirst($course->level) }} level</span>
                                        </div>
                                        <div class="me-4 mb-2">
                                            <i class="fas fa-clock me-2"></i>
                                            <span>{{ $course->total_duration ?? 0 }} hours</span>
                                        </div>
                                        <div class="me-4 mb-2">
                                            <i class="fas fa-language me-2"></i>
                                            <span>{{ $course->language }}</span>
                                        </div>
                                    </div>
                                    
                                    <div class="d-flex align-items-center">
                                        <img src="{{ $course->instructor->profile_photo ? asset($course->instructor->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                             class="rounded-circle me-2" alt="{{ $course->instructor->name }}" width="40">
                                        <span>Created by <a href="#instructor" class="text-white fw-bold">{{ $course->instructor->name }}</a></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- Course Tabs -->
                <ul class="nav nav-tabs mb-4" id="courseTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="overview-tab" data-bs-toggle="tab" data-bs-target="#overview" type="button" role="tab" aria-controls="overview" aria-selected="true">Overview</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="curriculum-tab" data-bs-toggle="tab" data-bs-target="#curriculum" type="button" role="tab" aria-controls="curriculum" aria-selected="false">Curriculum</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="instructor-tab" data-bs-toggle="tab" data-bs-target="#instructor" type="button" role="tab" aria-controls="instructor" aria-selected="false">Instructor</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="reviews-tab" data-bs-toggle="tab" data-bs-target="#reviews" type="button" role="tab" aria-controls="reviews" aria-selected="false">Reviews</button>
                    </li>
                </ul>

                <div class="tab-content" id="courseTabContent">
                    <!-- Overview Tab -->
                    <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview-tab">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-body p-4">
                                <h4 class="card-title mb-4">About This Course</h4>
                                <div class="course-description mb-4">
                                    {!! nl2br(e($course->description)) !!}
                                </div>

                                @if($course->what_you_will_learn)
                                <div class="mb-4">
                                    <h5 class="mb-3">What You'll Learn</h5>
                                    <div class="row">
                                        @foreach(explode("\n", $course->what_you_will_learn) as $point)
                                            @if(trim($point))
                                            <div class="col-md-6 mb-2">
                                                <div class="d-flex">
                                                    <i class="fas fa-check text-success me-2 mt-1"></i>
                                                    <span>{{ trim($point) }}</span>
                                                </div>
                                            </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                                @endif

                                @if($course->requirements)
                                <div class="mb-4">
                                    <h5 class="mb-3">Requirements</h5>
                                    <ul class="list-unstyled">
                                        @foreach(explode("\n", $course->requirements) as $requirement)
                                            @if(trim($requirement))
                                            <li class="mb-2">
                                                <i class="fas fa-circle text-primary me-2 small"></i>
                                                {{ trim($requirement) }}
                                            </li>
                                            @endif
                                        @endforeach
                                    </ul>
                                </div>
                                @endif

                                @if($course->target_audience)
                                <div class="mb-4">
                                    <h5 class="mb-3">Who This Course is For</h5>
                                    <ul class="list-unstyled">
                                        @foreach(explode("\n", $course->target_audience) as $audience)
                                            @if(trim($audience))
                                            <li class="mb-2">
                                                <i class="fas fa-user text-primary me-2"></i>
                                                {{ trim($audience) }}
                                            </li>
                                            @endif
                                        @endforeach
                                    </ul>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Curriculum Tab -->
                    <div class="tab-pane fade" id="curriculum" role="tabpanel" aria-labelledby="curriculum-tab">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-body p-4">
                                <h4 class="card-title mb-4">Course Content</h4>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <span class="me-3">{{ $course->sections->count() }} sections</span>
                                        <span class="me-3">{{ $course->sections->flatMap->lessons->count() }} lessons</span>
                                        <span>{{ $course->total_duration ?? 0 }} total hours</span>
                                    </div>
                                    <button class="btn btn-sm btn-outline-primary" type="button" id="expandAllSections">
                                        Expand All Sections
                                    </button>
                                </div>

                                <div class="accordion" id="accordionCurriculum">
                                    @foreach($course->sections as $section)
                                    <div class="accordion-item border mb-3 rounded">
                                        <h2 class="accordion-header" id="heading{{ $section->id }}">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $section->id }}" aria-expanded="false" aria-controls="collapse{{ $section->id }}">
                                                <div class="d-flex justify-content-between align-items-center w-100 me-3">
                                                    <span class="fw-bold">{{ $section->title }}</span>
                                                    <div class="text-muted small">
                                                        {{ $section->lessons->count() }} lessons • 
                                                        {{ $section->lessons->sum('duration') }} min
                                                    </div>
                                                </div>
                                            </button>
                                        </h2>
                                        <div id="collapse{{ $section->id }}" class="accordion-collapse collapse" aria-labelledby="heading{{ $section->id }}" data-bs-parent="#accordionCurriculum">
                                            <div class="accordion-body p-0">
                                                <ul class="list-group list-group-flush">
                                                    @foreach($section->lessons as $lesson)
                                                    <li class="list-group-item d-flex justify-content-between align-items-center p-3">
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas {{ $lesson->video_url ? 'fa-play-circle text-danger' : 'fa-file-alt text-primary' }} me-3"></i>
                                                            <div>
                                                                <div>{{ $lesson->title }}</div>
                                                                @if($lesson->description)
                                                                <small class="text-muted">{{ Str::limit($lesson->description, 60) }}</small>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            @if($lesson->is_free)
                                                            <span class="badge bg-success me-3">Free</span>
                                                            @endif
                                                            <span class="text-muted small">{{ $lesson->duration }} min</span>
                                        </div>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Instructor Tab -->
    <div class="tab-pane fade" id="instructor" role="tabpanel" aria-labelledby="instructor-tab">
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body p-4">
                <h4 class="card-title mb-4">About the Instructor</h4>
                <div class="d-flex mb-4">
                    <img src="{{ $course->instructor->profile_photo ? asset( $course->instructor->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                        class="rounded-circle me-4" alt="{{ $course->instructor->name }}" width="100" height="100">
                    <div>
                        <h5 class="mb-1">{{ $course->instructor->name }}</h5>
                        <p class="text-muted mb-2">{{ $course->instructor->headline ?? 'Course Instructor' }}</p>
                        <div class="d-flex align-items-center mb-3">
                            <div class="text-warning me-2">
                                <i class="fas fa-star"></i>
                                <span>{{ number_format($course->instructor->average_rating ?? 0, 1) }}</span>
                            </div>
                            <div class="mx-3 text-muted">|</div>
                            <div class="me-3">
                                <i class="fas fa-play-circle me-1"></i>
                                <span>{{ $course->instructor->courses_count ?? 0 }} courses</span>
                            </div>
                            <div>
                                <i class="fas fa-users me-1"></i>
                                <span>{{ $course->instructor->students_count ?? 0 }} students</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="instructor-bio mb-4">
                    {!! nl2br(e($course->instructor->bio ?? 'No instructor bio available.')) !!}
                </div>

                <a href="#" class="btn btn-outline-primary">View All Courses by This Instructor</a>
            </div>
        </div>
    </div>

    <!-- Reviews Tab -->
    <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title mb-0">Student Reviews</h4>
                    @if($isEnrolled && !$hasReview)
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#reviewModal">
                        <i class="fas fa-edit me-2"></i>Write a Review
                    </button>
                    @endif
                </div>

                <div class="row mb-4">
                    <div class="col-md-4 text-center">
                        <div class="display-4 fw-bold text-warning mb-2">{{ number_format($course->average_rating, 1) }}</div>
                        <div class="text-warning mb-2">
                            @for($i = 1; $i <= 5; $i++)
                                <i class="fas fa-star{{ $i <= round($course->average_rating) ? '' : '-o' }}"></i>
                            @endfor
                        </div>
                        <div class="text-muted">{{ $course->reviews_count ?? 0 }} ratings</div>
                    </div>
                    <div class="col-md-8">
                        <div class="row align-items-center mb-2">
                            <div class="col-2 text-end">5 stars</div>
                            <div class="col-8">
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                        style="width: {{ $course->reviews_count ? ($course->reviews->where('rating', 5)->count() / $course->reviews_count) * 100 : 0 }}%" 
                                        aria-valuenow="{{ $course->reviews_count ? ($course->reviews->where('rating', 5)->count() / $course->reviews_count) * 100 : 0 }}" 
                                        aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            <div class="col-2">{{ $course->reviews->where('rating', 5)->count() }}</div>
                        </div>
                        <div class="row align-items-center mb-2">
                            <div class="col-2 text-end">4 stars</div>
                            <div class="col-8">
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                        style="width: {{ $course->reviews_count ? ($course->reviews->where('rating', 4)->count() / $course->reviews_count) * 100 : 0 }}%" 
                                        aria-valuenow="{{ $course->reviews_count ? ($course->reviews->where('rating', 4)->count() / $course->reviews_count) * 100 : 0 }}" 
                                        aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            <div class="col-2">{{ $course->reviews->where('rating', 4)->count() }}</div>
                        </div>
                        <div class="row align-items-center mb-2">
                            <div class="col-2 text-end">3 stars</div>
                            <div class="col-8">
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                        style="width: {{ $course->reviews_count ? ($course->reviews->where('rating', 3)->count() / $course->reviews_count) * 100 : 0 }}%" 
                                        aria-valuenow="{{ $course->reviews_count ? ($course->reviews->where('rating', 3)->count() / $course->reviews_count) * 100 : 0 }}" 
                                        aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            <div class="col-2">{{ $course->reviews->where('rating', 3)->count() }}</div>
                        </div>
                        <div class="row align-items-center mb-2">
                            <div class="col-2 text-end">2 stars</div>
                            <div class="col-8">
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                        style="width: {{ $course->reviews_count ? ($course->reviews->where('rating', 2)->count() / $course->reviews_count) * 100 : 0 }}%" 
                                        aria-valuenow="{{ $course->reviews_count ? ($course->reviews->where('rating', 2)->count() / $course->reviews_count) * 100 : 0 }}" 
                                        aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            <div class="col-2">{{ $course->reviews->where('rating', 2)->count() }}</div>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-2 text-end">1 star</div>
                            <div class="col-8">
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                        style="width: {{ $course->reviews_count ? ($course->reviews->where('rating', 1)->count() / $course->reviews_count) * 100 : 0 }}%" 
                                        aria-valuenow="{{ $course->reviews_count ? ($course->reviews->where('rating', 1)->count() / $course->reviews_count) * 100 : 0 }}" 
                                        aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            <div class="col-2">{{ $course->reviews->where('rating', 1)->count() }}</div>
                        </div>
                    </div>
                </div>

                <hr class="my-4">

                <!-- Reviews List -->
                @if($course->reviews->count() > 0)
                    <div class="reviews-container">
                        @foreach($course->reviews as $review)
                        <div class="review-item mb-4 pb-4 border-bottom">
                            <div class="d-flex mb-3">
                                <img src="{{ $review->enrollment->user->profile_photo ? asset('storage/' . $review->enrollment->user->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                    class="rounded-circle me-3" alt="{{ $review->enrollment->user->name }}" width="50" height="50">
                                <div>
                                    <h6 class="mb-1">{{ $review->enrollment->user->name }}</h6>
                                    <div class="d-flex align-items-center">
                                        <div class="text-warning me-2">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star{{ $i <= $review->rating ? '' : '-o' }} small"></i>
                                            @endfor
                                        </div>
                                        <small class="text-muted">{{ $review->created_at->diffForHumans() }}</small>
                                    </div>
                                </div>
                            </div>
                            <div class="review-content">
                                {{ $review->review }}
                            </div>
                        </div>
                        @endforeach
                    </div>
                    
                    @if($course->reviews->count() > 5)
                    <div class="text-center">
                        <a href="#" class="btn btn-outline-primary">View All Reviews</a>
                    </div>
                    @endif
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-star-half-alt fa-3x text-muted mb-3"></i>
                        <h5>No Reviews Yet</h5>
                        <p class="text-muted">Be the first to review this course</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Related Courses -->
@if($relatedCourses->count() > 0)
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body p-4">
        <h4 class="card-title mb-4">Similar Courses</h4>
        <div class="row g-4">
            @foreach($relatedCourses as $relatedCourse)
            <div class="col-md-6">
                <div class="card h-100 border shadow-sm hover-shadow transition-all">
                    <a href="{{ route('courses.show', $relatedCourse->slug) }}">
                        <img src="{{ $relatedCourse->thumbnail ? asset('storage/' . $relatedCourse->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                            class="card-img-top" alt="{{ $relatedCourse->title }}">
                    </a>
                    <div class="card-body p-3">
                        <h6 class="card-title mb-2">
                            <a href="{{ route('courses.show', $relatedCourse->slug) }}" class="text-decoration-none text-dark">{{ $relatedCourse->title }}</a>
                        </h6>
                        <p class="text-muted small mb-3">
                            <i class="fas fa-user-tie me-1"></i> {{ $relatedCourse->instructor->name }}
                        </p>
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-warning small">
                                @for($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star{{ $i <= round($relatedCourse->average_rating) ? '' : '-o' }} small"></i>
                                @endfor
                                <span class="ms-1 text-muted">{{ number_format($relatedCourse->average_rating, 1) }}</span>
                            </div>
                            <div>
                                @if($relatedCourse->price == 0)
                                <span class="text-success fw-bold">Free</span>
                                @elseif($relatedCourse->discount_price && $relatedCourse->discount_ends_at > now())
                                <span class="fw-bold">${{ number_format($relatedCourse->discount_price, 2) }}</span>
                                <del class="text-muted ms-1 small">${{ number_format($relatedCourse->price, 2) }}</del>
                                @else
                                <span class="fw-bold">${{ number_format($relatedCourse->price, 2) }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endif
@endsection