@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Edit Event')

@section('left_sidebar')
@include('front_end.pages.events.events_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Edit Event Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('events.show', $event->slug) }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">Edit Event</h4>
                                <p class="mb-0 text-white">Update your event details</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Event Form -->
    <div class="container pb-4">
        <form action="{{ url('/webapi/event/update-event') }}" id="edit-event-form" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="event_id" value="{{ $event->id }}">
            
            <div class="row">
                <div class="col-lg-8">
                    <!-- Basic Event Details -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-body">
                            <h5 class="card-title mb-4">Event Details</h5>
                            
                            <div class="mb-3">
                                <label class="form-label">Event Title</label>
                                <input type="text" class="form-control" name="title" value="{{ old('title', $event->name) }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" rows="4" required>{{ old('description', $event->description) }}</textarea>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Start Date & Time</label>
                                    <input type="datetime-local" class="form-control" name="start_datetime" 
                                           value="{{ old('start_datetime', $event->start_date . 'T' . substr($event->start_time, 0, 5)) }}" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">End Date & Time</label>
                                    <input type="datetime-local" class="form-control" name="end_datetime" 
                                           value="{{ old('end_datetime', $event->end_date . 'T' . substr($event->end_time, 0, 5)) }}" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Location</label>
                                <input type="text" class="form-control" name="location" value="{{ old('location', $event->location) }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Event Type</label>
                                <select class="form-select" name="event_type" required>
                                    <option value="in_person" {{ old('event_type', $event->event_type) == 'in_person' ? 'selected' : '' }}>In Person</option>
                                    <option value="online" {{ old('event_type', $event->event_type) == 'online' ? 'selected' : '' }}>Online</option>
                                    <option value="hybrid" {{ old('event_type', $event->event_type) == 'hybrid' ? 'selected' : '' }}>Hybrid</option>
                                </select>
                            </div>

                            @if($event->event_url)
                            <div class="mb-3">
                                <label class="form-label">Event URL</label>
                                <input type="url" class="form-control" name="event_url" value="{{ old('event_url', $event->event_url) }}">
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Event Media -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-body">
                            <h5 class="card-title mb-4">Event Media</h5>
                            
                            @if($event->cover_image)
                            <div class="mb-3">
                                <label class="form-label">Current Cover Image</label>
                                <div class="d-flex align-items-center">
                                    <img src="{{ asset( $event->cover_image) }}" alt="Current cover" class="img-thumbnail me-3" style="width: 100px; height: 100px; object-fit: cover;">
                                    <div>
                                        <p class="mb-0 small text-muted">Upload a new image to replace the current one</p>
                                    </div>
                                </div>
                            </div>
                            @endif
                            
                            <div class="mb-3">
                                <label class="form-label">{{ $event->cover_image ? 'New Cover Image' : 'Cover Image' }}</label>
                                <input type="file" class="form-control" name="cover_image" accept="image/*">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <!-- Event Settings -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-body">
                            <h5 class="card-title mb-4">Event Settings</h5>

                            <div class="mb-3">
                                <label class="form-label">Privacy</label>
                                <select class="form-select" name="privacy">
                                    <option value="public" {{ old('privacy', $event->type) == 'public' ? 'selected' : '' }}>Public</option>
                                    <option value="private" {{ old('privacy', $event->type) == 'private' ? 'selected' : '' }}>Private</option>
                                    <option value="friends" {{ old('privacy', $event->type) == 'friends' ? 'selected' : '' }}>Friends Only</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Category</label>
                                <select class="form-select" name="category">
                                    <option value="social" {{ old('category', $event->category) == 'social' ? 'selected' : '' }}>Social</option>
                                    <option value="business" {{ old('category', $event->category) == 'business' ? 'selected' : '' }}>Business</option>
                                    <option value="education" {{ old('category', $event->category) == 'education' ? 'selected' : '' }}>Education</option>
                                    <option value="entertainment" {{ old('category', $event->category) == 'entertainment' ? 'selected' : '' }}>Entertainment</option>
                                    <option value="other" {{ old('category', $event->category) == 'other' ? 'selected' : '' }}>Other</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input type="hidden" name="allow_guests" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_guests" id="allowGuests" value="1"
                                           {{ old('allow_guests', $event->allow_guests) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="allowGuests">Allow Guests</label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input type="hidden" name="require_approval" value="0">
                                    <input class="form-check-input" type="checkbox" name="require_approval" id="requireApproval" value="1"
                                           {{ old('require_approval', $event->require_approval) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="requireApproval">Require Approval</label>
                                </div>
                            </div>

                            @if($event->max_participants)
                            <div class="mb-3">
                                <label class="form-label">Maximum Participants</label>
                                <input type="number" class="form-control" name="max_participants" min="1" 
                                       value="{{ old('max_participants', $event->max_participants) }}">
                            </div>
                            @endif

                            <div class="mb-3">
                                <label class="form-label">Event Status</label>
                                <select class="form-select" name="event_status">
                                    <option value="active" {{ old('event_status', $event->event_status) == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="cancelled" {{ old('event_status', $event->event_status) == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                    <option value="postponed" {{ old('event_status', $event->event_status) == 'postponed' ? 'selected' : '' }}>Postponed</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Event
                        </button>
                        <a href="{{ route('events.show', $event->slug) }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                        <button type="button" class="btn btn-outline-danger" onclick="confirmDelete()">
                            <i class="fas fa-trash me-2"></i>Delete Event
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteConfirmModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this event? This action cannot be undone.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" onclick="deleteEvent()">Delete Event</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script src="{{ asset('assets/js/events.js') }}"></script>
<script>
function confirmDelete() {
    const modal = new bootstrap.Modal(document.getElementById('deleteConfirmModal'));
    modal.show();
}

function deleteEvent() {
    const eventId = document.querySelector('input[name="event_id"]').value;
    
    axios.post('/webapi/event/delete-event', {
        event_id: eventId
    })
    .then(response => {
        if (response.data.status === 200) {
            myAlert.fire({
                icon: 'success',
                title: 'Success!',
                text: 'Event deleted successfully!'
            });
            setTimeout(() => {
                window.location.href = '/events';
            }, 2000);
        }
    })
    .catch(error => {
        console.error('Error deleting event:', error);
        myAlert.fire({
            icon: 'error',
            title: 'Error',
            text: 'An error occurred while deleting the event. Please try again.'
        });
    });
}
</script>
@endpush 