@extends('front_end.layouts.home')

@section('title', $category->name . ' Games')

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('index') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('games.index') }}">Games</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $category->name }}</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="rounded-circle bg-primary bg-opacity-10 p-3 me-3" style="width: 65px; height: 65px;">
                            <i class="{{ $category->icon ?? 'fas fa-gamepad' }} fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h1 class="mb-0">{{ $category->name }} Games</h1>
                            <p class="text-muted mb-0">{{ $games->total() }} games available</p>
                        </div>
                    </div>
                    @if($category->description)
                    <div class="mt-3">
                        <p>{{ $category->description }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <div class="row g-4">
        @forelse($games as $game)
        <div class="col-lg-3 col-md-4 col-sm-6">
            @include('front_end.pages.games.partials.game_card', ['game' => $game])
        </div>
        @empty
        <div class="col-12">
            <div class="alert alert-info">
                No games found in this category. Please check back later.
            </div>
        </div>
        @endforelse
    </div>
    
    <div class="row mt-4">
        <div class="col-12 d-flex justify-content-center">
            {{ $games->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection