<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">Quick Search</h5>
        <form action="{{ route('search.games') }}" method="GET">
            <div class="input-group mb-3">
                <input type="text" class="form-control" placeholder="Search games..." name="q">
                <button class="btn btn-primary" type="submit">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">Categories</h5>
        <ul class="list-group list-group-flush">
            @foreach($categories as $category)
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('games.category', $category->slug) }}" class="text-decoration-none d-flex justify-content-between align-items-center">
                    <span>
                        <i class="{{ $category->icon ?? 'fas fa-gamepad' }} me-2 text-primary"></i>
                        {{ $category->name }}
                    </span>
                    <span class="badge bg-light text-dark rounded-pill">{{ $category->games_count }}</span>
                </a>
            </li>
            @endforeach
        </ul>
    </div>
</div>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">Browse</h5>
        <ul class="list-group list-group-flush">
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.games') }}?featured=1" class="text-decoration-none">
                    <i class="fas fa-star me-2 text-warning"></i> Featured Games
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.games') }}?sort=newest" class="text-decoration-none">
                    <i class="fas fa-calendar-alt me-2 text-primary"></i> New Arrivals
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.games') }}?sort=popularity" class="text-decoration-none">
                    <i class="fas fa-fire me-2 text-danger"></i> Most Popular
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.games') }}?sort=rating" class="text-decoration-none">
                    <i class="fas fa-award me-2 text-success"></i> Top Rated
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.games') }}?multiplayer=1" class="text-decoration-none">
                    <i class="fas fa-users me-2 text-info"></i> Multiplayer Games
                </a>
            </li>
        </ul>
    </div>
</div>

@auth
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">My Games</h5>
        <ul class="list-group list-group-flush">
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ url('games.favorites') }}" class="text-decoration-none">
                    <i class="fas fa-heart me-2 text-danger"></i> Favorites
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ url('games.history') }}" class="text-decoration-none">
                    <i class="fas fa-history me-2 text-secondary"></i> Recently Played
                </a>
            </li>
        </ul>
    </div>
</div>
@endauth