<div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
    <a href="{{ route('games.show', $game->slug) }}" class="text-decoration-none">
        <div class="position-relative">
            <img src="{{ $game->thumbnail_url ?? asset('images/game-placeholder.jpg') }}" class="card-img-top" alt="{{ $game->title }}" style="height: 180px; object-fit: cover;">
            @if($game->is_multiplayer)
            <div class="position-absolute bottom-0 end-0 p-2">
                <span class="badge bg-info">Multiplayer</span>
            </div>
            @endif
            @if($game->is_featured)
            <div class="position-absolute top-0 start-0 p-2">
                <span class="badge bg-warning">Featured</span>
            </div>
            @endif
        </div>
    </a>
    <div class="card-body">
        <a href="{{ route('games.show', $game->slug) }}" class="text-decoration-none">
            <h5 class="card-title text-truncate">{{ $game->title }}</h5>
        </a>
        <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="game-rating" data-rating="{{ $game->avg_rating }}"></div>
            <small class="text-muted">{{ number_format($game->plays_count) }} plays</small>
        </div>
        <p class="card-text text-muted small mb-2 text-truncate">
            <i class="fas fa-gamepad me-1"></i> {{ $game->category->name ?? 'Unknown' }}
        </p>
        <p class="card-text text-muted small mb-0">
            <i class="fas fa-user-alt me-1"></i> Ages {{ $game->min_age }}+
        </p>
    </div>
    <div class="card-footer bg-white border-0 d-flex justify-content-between">
        <a href="{{ route('games.show', $game->slug) }}" class="btn btn-sm btn-outline-primary">Details</a>
        <a href="{{ route('games.play', $game->slug) }}" class="btn btn-sm btn-primary">
            <i class="fas fa-play me-1"></i> Play Now
        </a>
    </div>
</div>