@extends('front_end.layouts.home')

@php
    $showRightSidebar = false;
@endphp

@section('title', $article->title . ' - Help Center')

@section('meta')
    @if ($article->meta_title)
        <meta name="title" content="{{ $article->meta_title }}">
    @endif
    @if ($article->meta_description)
        <meta name="description" content="{{ $article->meta_description }}">
    @endif
@endsection

@section('content')
<div class="container px-0 px-lg-3 help-center-article">
    <div class="row g-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    @foreach ($breadcrumbs as $crumb)
                        @if ($crumb['url'])
                            <li class="breadcrumb-item"><a href="{{ $crumb['url'] }}">{{ $crumb['label'] }}</a></li>
                        @else
                            <li class="breadcrumb-item active" aria-current="page">{{ $crumb['label'] }}</li>
                        @endif
                    @endforeach
                </ol>
            </nav>
            <h1 class="display-6 fw-bold">{{ $article->title }}</h1>
            <div class="text-muted small mb-3">
                <i class="fas fa-layer-group me-1"></i><a href="{{ route('help-center.topic', $topic->slug) }}" class="text-decoration-none">{{ $topic->title }}</a>
                <span class="mx-2">•</span>
                <i class="far fa-clock me-1"></i>{{ $article->estimated_reading_time ?? '—' }} min read
                <span class="mx-2">•</span>
                Updated {{ $article->updated_at?->diffForHumans() ?? 'recently' }}
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                @if ($article->hero_image)
                    <img src="{{ $article->hero_image }}" class="img-fluid" alt="{{ $article->title }}">
                @endif
                <div class="card-body">
                    @if ($article->summary)
                        <div class="alert alert-primary bg-primary bg-opacity-10 border-0 text-primary rounded-3">
                            <i class="fas fa-info-circle me-2"></i>{{ $article->summary }}
                        </div>
                    @endif
                    <article class="article-content">
                        {!! $article->content !!}
                    </article>
                </div>
            </div>

            <div class="card border-0 shadow-sm rounded-4 mt-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Was this article helpful?</h6>
                    <div class="d-flex gap-2">
                        <button class="btn btn-outline-success btn-sm">
                            <i class="far fa-thumbs-up me-2"></i>Yes
                        </button>
                        <button class="btn btn-outline-danger btn-sm">
                            <i class="far fa-thumbs-down me-2"></i>No
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card border-0 shadow-sm rounded-4 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Related articles</h6>
                    <div class="list-group list-group-flush">
                        @forelse ($relatedArticles as $related)
                            <a href="{{ route('help-center.article', [$topic->slug, $related->slug]) }}" class="list-group-item list-group-item-action">
                                {{ $related->title }}
                                <div class="small text-muted">
                                    <i class="far fa-clock me-1"></i>{{ $related->estimated_reading_time ?? '—' }} min
                                </div>
                            </a>
                        @empty
                            <span class="list-group-item text-muted">No related articles yet.</span>
                        @endforelse
                    </div>
                </div>
            </div>

            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Need more help?</h6>
                    <p class="text-muted">If you still have questions or feedback, let us know. We're always listening.</p>
                    <a href="mailto:support@socialink.com" class="btn btn-primary w-100 mb-2">
                        <i class="fas fa-envelope me-2"></i>Email Support
                    </a>
                    <a href="{{ route('help-center.index') }}" class="btn btn-outline-primary w-100">
                        <i class="fas fa-life-ring me-2"></i>Back to Help Center
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
