@extends('front_end.layouts.home')

@php
    $showRightSidebar = false;
@endphp

@section('title', $topic->title . ' - Help Center')

@section('content')
<div class="container px-0 px-lg-3">
    <div class="row g-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-1">
                    <li class="breadcrumb-item"><a href="{{ route('help-center.index') }}">Help Center</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $topic->title }}</li>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold">{{ $topic->title }}</h1>
            <p class="text-muted mb-4">{{ $topic->description }}</p>
        </div>

        @if ($featuredArticles->isNotEmpty())
            <div class="col-12">
                <div class="card border-0 shadow-sm rounded-4">
                    <div class="card-body">
                        <h5 class="mb-3">Featured guides in this topic</h5>
                        <div class="row g-3">
                            @foreach ($featuredArticles as $article)
                                <div class="col-md-6 col-xl-4">
                                    <a href="{{ route('help-center.article', [$topic->slug, $article->slug]) }}" class="card h-100 border-0 shadow-sm hover-shadow transition-hover rounded-4 text-decoration-none text-dark">
                                        <div class="card-body">
                                            <h6 class="fw-semibold mb-2">{{ $article->title }}</h6>
                                            <p class="text-muted mb-3">{{ Str::limit(strip_tags($article->summary ?? $article->content), 110) }}</p>
                                            <div class="text-muted small d-flex justify-content-between">
                                                <span><i class="far fa-clock me-1"></i>{{ $article->estimated_reading_time ?? '—' }} min</span>
                                                <span><i class="fas fa-chart-line me-1"></i>{{ number_format($article->view_count) }} views</span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div class="col-lg-8">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body">
                    <h5 class="mb-4">All articles</h5>
                    @forelse ($topic->articles as $article)
                        <div class="d-flex align-items-start justify-content-between mb-4">
                            <div>
                                <a class="h6 text-decoration-none" href="{{ route('help-center.article', [$topic->slug, $article->slug]) }}">
                                    {{ $article->title }}
                                </a>
                                <p class="text-muted mb-1">{{ Str::limit(strip_tags($article->summary ?? $article->content), 160) }}</p>
                                <small class="text-muted">
                                    <i class="far fa-clock me-1"></i>{{ $article->estimated_reading_time ?? '—' }} min read
                                    <span class="mx-2">•</span>
                                    <i class="fas fa-sync me-1"></i>{{ $article->updated_at?->diffForHumans() ?? '—' }}
                                </small>
                            </div>
                            <a href="{{ route('help-center.article', [$topic->slug, $article->slug]) }}" class="btn btn-sm btn-outline-primary">
                                Read
                            </a>
                        </div>
                        @if (!$loop->last)
                            <hr>
                        @endif
                    @empty
                        <p class="text-muted mb-0">Articles assigned to this topic will appear here.</p>
                    @endforelse
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card border-0 shadow-sm rounded-4 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Quick facts</h6>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <strong>{{ $topic->articles->count() }}</strong> articles
                        </li>
                        <li class="mb-2">
                            Updated {{ $topic->updated_at?->diffForHumans() ?? 'recently' }}
                        </li>
                        <li>Icon: <code>{{ $topic->icon ?? 'none' }}</code></li>
                    </ul>
                </div>
            </div>

            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Explore other topics</h6>
                    <div class="list-group list-group-flush">
                        @forelse ($relatedTopics as $related)
                            <a href="{{ route('help-center.topic', $related->slug) }}" class="list-group-item list-group-item-action">
                                <i class="{{ $related->icon ?? 'fas fa-book' }} text-primary me-2"></i>
                                {{ $related->title }}
                                <span class="badge bg-secondary float-end">{{ $related->articles()->published()->count() }}</span>
                            </a>
                        @empty
                            <span class="list-group-item text-muted">No other topics yet.</span>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
