@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Post a Job')

@section('left_sidebar')
@include('front_end.pages.jobs.job_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Create Job Header -->
    <div class="card border-0">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/jobs') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Post a New Job</h4>
                                    <p class="mb-0 text-white">Create a detailed job listing to attract qualified candidates</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Job Creation Form -->
    <div class="card border-0">
        <div class="card-body p-4">
            <form id="create-job-form">
                <div class="row g-4">
                    <div class="col-lg-12">
                    <div class="card bg-light border-0 rounded-4 mb-4">
                            <div class="card-body">
                                <h6 class="mb-3">Tips for a Great Job Posting</h6>
                                <ul class="list-unstyled mb-0">
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Use a clear, specific job title
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Detail key responsibilities
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Specify required skills and experience
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Include salary range for better visibility
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Highlight company benefits
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Add screening questions to filter candidates
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <!-- Company Information Section -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Company Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="company-name" class="form-label">Company Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="company-name" name="company_name" required>
                                </div>
                                <div class="mb-3">
                                    <label for="company-website" class="form-label">Company Website</label>
                                    <input type="url" class="form-control" id="company-website" name="company_website" placeholder="https://example.com">
                                </div>
                                <div class="mb-3">
                                    <label for="company-logo" class="form-label">Company Logo</label>
                                    <input type="file" class="form-control" id="company-logo" name="company_logo" accept="image/*">
                                    <small class="text-muted">Recommended size: 200x200px, Max size: 2MB</small>
                                </div>
                            </div>
                        </div>

                        <!-- Job Details Section -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Job Details</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="job-title" class="form-label">Job Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="job-title" name="job_title" required>
                                    <small class="text-muted">Be specific - e.g., "Senior React Developer" rather than just "Developer"</small>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="category" class="form-label">Job Category <span class="text-danger">*</span></label>
                                        <select class="form-select" id="category" name="category_id" required>
                                            <option value="">Select a category</option>
                                            @foreach($jobCategories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="job-type" class="form-label">Job Type <span class="text-danger">*</span></label>
                                        <select class="form-select" id="job-type" name="job_type" required>
                                            <option value="">Select job type</option>
                                            <option value="full-time">Full Time</option>
                                            <option value="part-time">Part Time</option>
                                            <option value="contract">Contract</option>
                                            <option value="internship">Internship</option>
                                            <option value="temporary">Temporary</option>
                                            <option value="freelance">Freelance</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="description" class="form-label">Job Description <span class="text-danger">*</span></label>
                                    <textarea class="form-control rich-editor" id="description" name="job_description" rows="8" required></textarea>
                                    <small class="text-muted">Minimum 50 characters. Include key responsibilities, requirements, and benefits.</small>
                                </div>

                                <div class="mb-3">
                                    <label for="key-responsibilities" class="form-label">Key Responsibilities</label>
                                    <div id="responsibilities-container">
                                        <div class="input-group mb-2">
                                            <input type="text" class="form-control" name="key_responsibilities[]">
                                            <button type="button" class="btn btn-outline-secondary add-responsibility">
                                                <i class="fas fa-plus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="requirements" class="form-label">Requirements</label>
                                    <div id="requirements-container">
                                        <div class="input-group mb-2">
                                            <input type="text" class="form-control" name="requirements[]">
                                            <button type="button" class="btn btn-outline-secondary add-requirement">
                                                <i class="fas fa-plus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Location and Work Setup -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Location & Work Setup</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">Work Location Type <span class="text-danger">*</span></label>
                                    <div class="btn-group w-100" role="group">
                                        <input type="radio" class="btn-check" name="work_location_type" id="onsite" value="onsite" checked>
                                        <label class="btn btn-outline-primary" for="onsite">On-site</label>

                                        <input type="radio" class="btn-check" name="work_location_type" id="remote" value="remote">
                                        <label class="btn btn-outline-primary" for="remote">Remote</label>

                                        <input type="radio" class="btn-check" name="work_location_type" id="hybrid" value="hybrid">
                                        <label class="btn btn-outline-primary" for="hybrid">Hybrid</label>
                                    </div>
                                </div>

                                <div id="location-details">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="location" class="form-label">City <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="city" name="city" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="state" class="form-label">State/Province <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="state" name="state" required>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label for="country" class="form-label">Country <span class="text-danger">*</span></label>
                                        <select class="form-select" id="country" name="country" required>
                                            <option value="">Select country</option>
                                            <option value="US">United States</option>
                                            <option value="CA">Canada</option>
                                            <option value="GB">United Kingdom</option>
                                            <option value="AU">Australia</option>
                                            <option value="IN">India</option>
                                            <option value="PK">Pakistan</option>
                                            <option value="CN">China</option>
                                            <option value="DE">Germany</option>
                                            <option value="FR">France</option>
                                            <option value="JP">Japan</option>
                                            <option value="BR">Brazil</option>
                                            </select>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Compensation Section -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Compensation & Benefits</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="minimum-salary" class="form-label">Minimum Salary <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text">
                                                <i class="fas fa-dollar-sign"></i>
                                            </span>
                                            <input type="number" class="form-control" id="minimum-salary" name="minimum_salary" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="maximum-salary" class="form-label">Maximum Salary <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text">
                                                <i class="fas fa-dollar-sign"></i>
                                            </span>
                                            <input type="number" class="form-control" id="maximum-salary" name="maximum_salary" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="currency" class="form-label">Currency <span class="text-danger">*</span></label>
                                        <select class="form-select" id="currency" name="currency" required>
                                            <option value="USD">USD - US Dollar</option>
                                            <option value="EUR">EUR - Euro</option>
                                            <option value="GBP">GBP - British Pound</option>
                                            <option value="CAD">CAD - Canadian Dollar</option>
                                            <option value="AUD">AUD - Australian Dollar</option>
                                            <!-- Add more currencies as needed -->
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Salary Display Preference</label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="salary_display" id="show-salary" value="show" checked>
                                        <label class="form-check-label" for="show-salary">
                                            Show salary range
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="salary_display" id="hide-salary" value="hide">
                                        <label class="form-check-label" for="hide-salary">
                                            Hide salary range
                                        </label>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Benefits Offered</label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="benefits[]" value="health_insurance">
                                                <label class="form-check-label">Health Insurance</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="benefits[]" value="dental_insurance">
                                                <label class="form-check-label">Dental Insurance</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="benefits[]" value="vision_insurance">
                                                <label class="form-check-label">Vision Insurance</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="benefits[]" value="401k">
                                                <label class="form-check-label">401(k)</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="benefits[]" value="paid_vacation">
                                                <label class="form-check-label">Paid Vacation</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="benefits[]" value="stock_options">
                                                <label class="form-check-label">Stock Options</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Qualifications Section -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Qualifications</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="experience-years" class="form-label">Required Experience (Years) <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" id="experience-years" name="experience_years" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="education-level" class="form-label">Education Level</label>
                                        <select class="form-select" id="education-level" name="education_level">
                                            <option value="">Select education level</option>
                                            <option value="high_school">High School</option>
                                            <option value="associates">Associate's Degree</option>
                                            <option value="bachelors">Bachelor's Degree</option>
                                            <option value="masters">Master's Degree</option>
                                            <option value="doctorate">Doctorate</option>
                                            <option value="certification">Professional Certification</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Required Skills</label>
                                    <div id="skills-container">
                                        <div class="input-group mb-2">
                                            <input type="text" class="form-control" name="skills[]" placeholder="Add a required skill">
                                            <button type="button" class="btn btn-outline-secondary add-skill">
                                                <i class="fas fa-plus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Languages</label>
                                    <div id="languages-container">
                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <select class="form-select" name="languages[]">
                                                    <option value="">Select language</option>
                                                    <option value="english">English</option>
                                                    <option value="spanish">Spanish</option>
                                                    <option value="french">French</option>
                                                    <option value="german">German</option>
                                                    <option value="chinese">Chinese</option>
                                                    <!-- Add more languages as needed -->
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <select class="form-select" name="language_levels[]">
                                                    <option value="">Select proficiency level</option>
                                                    <option value="basic">Basic</option>
                                                    <option value="intermediate">Intermediate</option>
                                                    <option value="advanced">Advanced</option>
                                                    <option value="native">Native</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-outline-secondary btn-sm add-language">
                                        <i class="fas fa-plus"></i> Add Another Language
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Application Settings -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Application Settings</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="expiry-date" class="form-label">Listing Expiry Date <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="expiry-date" name="expiry_date" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="positions-available" class="form-label">Number of Positions</label>
                                        <input type="number" class="form-control" id="positions-available" name="positions_available" min="1" value="1">
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Application Method</label>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="radio" name="application_method" id="apply-platform" value="platform" checked>
                                        <label class="form-check-label" for="apply-platform">
                                            Apply through platform
                                        </label>
                                    </div>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="radio" name="application_method" id="apply-email" value="email">
                                        <label class="form-check-label" for="apply-email">
                                            Apply via email
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="application_method" id="apply-website" value="website">
                                        <label class="form-check-label" for="apply-website">
                                            Apply on company website
                                        </label>
                                    </div>
                                </div>

                                <div id="email-application-details" class="mb-3 d-none">
                                    <label for="application-email" class="form-label">Application Email</label>
                                    <input type="email" class="form-control" id="application-email" name="application_email">
                                </div>

                                <div id="website-application-details" class="mb-3 d-none">
                                    <label for="application-url" class="form-label">Application URL</label>
                                    <input type="url" class="form-control" id="application-url" name="application_url">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Required Documents</label>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" name="required_documents[]" value="resume" checked>
                                        <label class="form-check-label">Resume/CV</label>
                                    </div>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" name="required_documents[]" value="cover_letter">
                                        <label class="form-check-label">Cover Letter</label>
                                    </div>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" name="required_documents[]" value="portfolio">
                                        <label class="form-check-label">Portfolio</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="required_documents[]" value="references">
                                        <label class="form-check-label">References</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Screening Questions -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">Screening Questions</h5>
                                <button type="button" class="btn btn-outline-primary btn-sm add-question">
                                    <i class="fas fa-plus"></i> Add Question
                                </button>
                            </div>
                            <div class="card-body">
                                <div id="screening-questions-container">
                                    <!-- Questions will be added here dynamically -->
                                </div>
                            </div>
                        </div>

                        <!-- Job Posting Options -->
                        <div class="card border mb-4">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Posting Options</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="checkbox" id="urgent-hiring" name="is_urgent_hiring">
                                    <label class="form-check-label" for="urgent-hiring">
                                        Mark as Urgent Hiring
                                        <small class="text-muted d-block">This will highlight your job posting and mark it as urgent</small>
                                    </label>
                                </div>

                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="checkbox" id="featured-listing" name="is_featured">
                                    <label class="form-check-label" for="featured-listing">
                                        Feature this listing
                                        <small class="text-muted d-block">Featured listings appear at the top of search results</small>
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="hide-company" name="hide_company">
                                    <label class="form-check-label" for="hide-company">
                                        Hide company name
                                        <small class="text-muted d-block">Post this job anonymously</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Hidden fields for form submission -->
                        <input type="hidden" name="status" value="draft" id="job-status">
                        <input type="hidden" name="expiry_date" value="" id="expiry-date-hidden">
                    </div>

                   
                </div>

                <!-- Form Actions -->
                <div class="card-footer bg-transparent border-top p-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <a href="{{ url('jobs') }}" class="btn btn-light">Cancel</a>
                        <div>
                            <button type="button" class="btn btn-outline-primary me-2" id="save-draft">Save as Draft</button>
                            <button type="submit" class="btn btn-primary">Post Job</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    // Initialize rich editor if available
    if (typeof tinymce !== 'undefined') {
        tinymce.init({
            selector: '.rich-editor',
            height: 300,
            menubar: false,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table paste code help wordcount'
            ],
            toolbar: 'undo redo | formatselect | bold italic backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help'
        });
    }

    // Add dynamic form fields
    $('.add-responsibility').click(function() {
        const container = $('#responsibilities-container');
        const newField = `
            <div class="input-group mb-2">
                <input type="text" class="form-control" name="key_responsibilities[]">
                <button type="button" class="btn btn-outline-danger remove-field">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        `;
        container.append(newField);
    });

    $('.add-requirement').click(function() {
        const container = $('#requirements-container');
        const newField = `
            <div class="input-group mb-2">
                <input type="text" class="form-control" name="requirements[]">
                <button type="button" class="btn btn-outline-danger remove-field">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        `;
        container.append(newField);
    });

    $('.add-skill').click(function() {
        const container = $('#skills-container');
        const newField = `
            <div class="input-group mb-2">
                <input type="text" class="form-control" name="skills[]" placeholder="Add a required skill">
                <button type="button" class="btn btn-outline-danger remove-field">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        `;
        container.append(newField);
    });

    $('.add-language').click(function() {
        const container = $('#languages-container');
        const newField = `
            <div class="row mb-2">
                <div class="col-md-6">
                    <select class="form-select" name="languages[]">
                        <option value="">Select language</option>
                        <option value="english">English</option>
                        <option value="spanish">Spanish</option>
                        <option value="french">French</option>
                        <option value="german">German</option>
                        <option value="chinese">Chinese</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <select class="form-select" name="language_levels[]">
                        <option value="">Select proficiency level</option>
                        <option value="basic">Basic</option>
                        <option value="intermediate">Intermediate</option>
                        <option value="advanced">Advanced</option>
                        <option value="native">Native</option>
                    </select>
                </div>
                <div class="col-12 mt-2">
                    <button type="button" class="btn btn-outline-danger btn-sm remove-field">
                        <i class="fas fa-trash"></i> Remove Language
                    </button>
                </div>
            </div>
        `;
        container.append(newField);
    });

    $('.add-question').click(function() {
        const container = $('#screening-questions-container');
        const questionIndex = container.children().length + 1;
        const newField = `
            <div class="card mb-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <h6 class="mb-2">Question ${questionIndex}</h6>
                        <button type="button" class="btn btn-outline-danger btn-sm remove-field">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                    <textarea class="form-control" name="screening_questions[]" rows="2" placeholder="Enter your screening question here..."></textarea>
                </div>
            </div>
        `;
        container.append(newField);
    });

    // Remove field functionality
    $(document).on('click', '.remove-field', function() {
        $(this).closest('.input-group, .row, .card').remove();
    });

    // Handle application method changes
    $('input[name="application_method"]').change(function() {
        const method = $(this).val();
        
        // Hide all conditional fields
        $('#email-application-details, #website-application-details').addClass('d-none');
        
        // Show relevant field
        if (method === 'email') {
            $('#email-application-details').removeClass('d-none');
        } else if (method === 'website') {
            $('#website-application-details').removeClass('d-none');
        }
    });

    // Set default expiry date (30 days from now)
    const defaultExpiryDate = new Date();
    defaultExpiryDate.setDate(defaultExpiryDate.getDate() + 30);
    const formattedDate = defaultExpiryDate.toISOString().split('T')[0];
    $('#expiry-date').val(formattedDate);
    $('#expiry-date-hidden').val(formattedDate);

    // Update hidden expiry date when user changes the visible one
    $('#expiry-date').change(function() {
        $('#expiry-date-hidden').val($(this).val());
    });

    // Handle form submission
    $('#create-job-form').on('submit', function(e) {
        e.preventDefault();
        
        const submitButton = $(this).find('button[type="submit"]');
        const originalText = submitButton.text();
        
        // Disable submit button and show loading
        submitButton.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Posting Job...');
        
        // Get form data
        const formData = new FormData(this);
        
        // Add CSRF token
        formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

        // Submit via AJAX
        $.ajax({
            url: '{{ url("webapi/jobs/create") }}',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                console.log('Success response:', response);
                if (response.status === 201) {
                    // Show success message
                    Swal.fire({
                        title: 'Success!',
                        text: response.message,
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        // Redirect to jobs page or job detail
                        window.location.href = '{{ url("/jobs") }}';
                    });
                } else {
                    throw new Error(response.message || 'Unknown error occurred');
                }
            },
            error: function(xhr) {
                console.log('Error response:', xhr);
                console.log('Status:', xhr.status);
                console.log('Response text:', xhr.responseText);
                
                let errorMessage = 'An error occurred while creating the job.';
                let errors = {};
                
                if (xhr.responseJSON) {
                    if (xhr.responseJSON.errors) {
                        errors = xhr.responseJSON.errors;
                        errorMessage = 'Please fix the following errors:';
                    } else if (xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                }
                
                // Display validation errors
                if (Object.keys(errors).length > 0) {
                    let errorList = '<ul>';
                    Object.keys(errors).forEach(field => {
                        errors[field].forEach(error => {
                            errorList += `<li>${error}</li>`;
                        });
                    });
                    errorList += '</ul>';
                    errorMessage += errorList;
                }
                
                Swal.fire({
                    title: 'Error!',
                    html: errorMessage,
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            },
            complete: function() {
                // Re-enable submit button
                submitButton.prop('disabled', false).text(originalText);
            }
        });
    });

    // Handle save as draft
    $('#save-draft').on('click', function(e) {
        e.preventDefault();
        $('#job-status').val('draft');
        $('#create-job-form').submit();
    });

    // Handle post job button
    $('button[type="submit"]').on('click', function(e) {
        e.preventDefault();
        $('#job-status').val('pending');
        $('#create-job-form').submit();
    });
});
</script>
@endpush




@endsection
