<!-- Responsive Sidebar Toggle -->
<div class="d-flex align-items-center d-lg-none">
    <button class="border-0 bg-transparent" type="button" data-bs-toggle="offcanvas"
        data-bs-target="#offcanvasSideNavbar" aria-controls="offcanvasSideNavbar">
        <span class="btn btn-primary"><i class="bi bi-list"></i></span>
        <span class="h6 mb-0 fw-bold d-lg-none ms-2">Jobs Menu</span>
    </button>
</div>

<!-- Sidebar Navigation -->
<nav class="navbar navbar-expand-lg mx-0">
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSideNavbar">
        <!-- Offcanvas Header -->
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">Jobs Menu</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>

        <!-- Offcanvas Body -->
        <div class="offcanvas-body d-block px-2 px-lg-0">
           
            <!-- Navigation Menu -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-body p-3">
                    <ul class="nav flex-column fw-bold gap-2">
                        <!-- Jobs Section -->
                        <li class="nav-title">Jobs</li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ url('jobs/discover') }}">
                                <i class="bi bi-compass text-primary me-2"></i><span>Discover Jobs</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ url('jobs/applied') }}">
                                <i class="bi bi-person-badge text-primary me-2"></i><span>My Applications</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ url('jobs/saved') }}">
                                <i class="bi bi-bookmark text-primary me-2"></i><span>Saved Jobs</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ url('jobs/create') }}">
                                <i class="bi bi-plus-circle text-primary me-2"></i><span>Post a Job</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ url('jobs/my-jobs') }}">
                                <i class="bi bi-briefcase text-primary me-2"></i><span>My Posted Jobs</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ url('jobs/alerts') }}">
                                <i class="bi bi-bell text-primary me-2"></i><span>Job Alerts</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

        

            @include('front_end.components.footer_left_sidebar')
        </div>
    </div>
</nav>

@push('scripts')
<script>
$(document).ready(function() {
    // Load job categories
    loadJobCategories();
    
    // Load recent searches from localStorage
    loadRecentSearches();
    
    // Handle filter buttons
    $('.filter-btn').click(function() {
        $('.filter-btn').removeClass('active');
        $(this).addClass('active');
        
        const filter = $(this).data('filter');
        // Trigger filter change event
        $(document).trigger('jobFilterChanged', [filter]);
    });
    
    // Handle salary filter
    $('#applySalaryFilter').click(function() {
        const minSalary = $('#minSalary').val();
        const maxSalary = $('#maxSalary').val();
        $(document).trigger('salaryFilterChanged', [minSalary, maxSalary]);
    });
    
    // Handle location filter
    $('#applyLocationFilter').click(function() {
        const location = $('#locationFilter').val();
        const remoteOnly = $('#remoteOnly').is(':checked');
        $(document).trigger('locationFilterChanged', [location, remoteOnly]);
    });
    
    // Save search to recent searches
    $(document).on('jobSearch', function(e, searchTerm) {
        saveRecentSearch(searchTerm);
    });
});

function loadJobCategories() {
    $.ajax({
        url: '{{ url("webapi/jobs/categories") }}',
        type: 'GET',
        success: function(response) {
            if (response.status === 200 && response.data) {
                const categoriesHtml = response.data.map(category => 
                    `<button class="btn btn-sm btn-outline-secondary w-100 text-start category-btn" data-category="${category.id}">
                        ${category.name}
                    </button>`
                ).join('');
                
                $('#jobCategories').html(categoriesHtml);
                
                // Handle category clicks
                $('.category-btn').click(function() {
                    const categoryId = $(this).data('category');
                    $(document).trigger('categoryFilterChanged', [categoryId]);
                });
            } else {
                $('#jobCategories').html('<div class="text-muted small">No categories available</div>');
            }
        },
        error: function() {
            $('#jobCategories').html('<div class="text-muted small">Error loading categories</div>');
        }
    });
}

function loadRecentSearches() {
    const recentSearches = JSON.parse(localStorage.getItem('jobRecentSearches') || '[]');
    
    if (recentSearches.length === 0) {
        $('#recentSearches').html('<div class="text-muted small">No recent searches</div>');
        return;
    }
    
    const searchesHtml = recentSearches.map(search => 
        `<button class="btn btn-sm btn-outline-light w-100 text-start recent-search-btn" data-search="${search}">
            <i class="bi bi-clock-history me-1"></i>${search}
        </button>`
    ).join('');
    
    $('#recentSearches').html(searchesHtml);
    
    // Handle recent search clicks
    $('.recent-search-btn').click(function() {
        const searchTerm = $(this).data('search');
        $(document).trigger('jobSearch', [searchTerm]);
    });
}

function saveRecentSearch(searchTerm) {
    let recentSearches = JSON.parse(localStorage.getItem('jobRecentSearches') || '[]');
    
    // Remove if already exists
    recentSearches = recentSearches.filter(s => s !== searchTerm);
    
    // Add to beginning
    recentSearches.unshift(searchTerm);
    
    // Keep only last 5 searches
    recentSearches = recentSearches.slice(0, 5);
    
    localStorage.setItem('jobRecentSearches', JSON.stringify(recentSearches));
    loadRecentSearches();
}
</script>
@endpush