@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Jobs')

@section('left_sidebar')
@include('front_end.pages.jobs.job_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Jobs</h4>
                                    <p class="mb-0 text-white" id="jobsCount">Find your dream job from available opportunities</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/jobs/create') }}" class="btn btn-info">
                                    <i class="fas fa-plus-circle me-2"></i>Post a new job
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="container mt-4">
        <div class="row mb-4">
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-primary bg-opacity-10">
                    <div class="card-body text-center">
                        <i class="fas fa-briefcase fa-2x text-primary mb-2"></i>
                        <h3 class="mb-0" id="totalJobs">0</h3>
                        <p class="mb-0">Available Jobs</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-success bg-opacity-10">
                    <a href="{{ url('jobs/applied') }}">
                    <div class="card-body text-center">
                        <i class="fas fa-paper-plane fa-2x text-success mb-2"></i>
                        <h3 class="mb-0" id="appliedJobs">0</h3>
                        <p class="mb-0">Applied Jobs</p>
                    </div>
                    </a>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-warning bg-opacity-10">
                    <div class="card-body text-center">
                        <i class="fas fa-bookmark fa-2x text-warning mb-2"></i>
                        <h3 class="mb-0" id="savedJobs">0</h3>
                        <p class="mb-0">Saved Jobs</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-danger bg-opacity-10">
                    <div class="card-body text-center">
                        <i class="fas fa-bell fa-2x text-danger mb-2"></i>
                        <h3 class="mb-0" id="jobAlerts">0</h3>
                        <p class="mb-0">Job Alerts</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Filter Pills -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex flex-wrap gap-2">
                    <button class="btn btn-sm btn-outline-primary rounded-pill filter-pill active" data-filter="all">
                        All Jobs <span class="badge bg-primary ms-2" id="allJobsCount">0</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill filter-pill" data-filter="remote">
                        Remote <span class="badge bg-secondary ms-2" id="remoteJobsCount">0</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill filter-pill" data-filter="full-time">
                        Full-time <span class="badge bg-secondary ms-2" id="fulltimeJobsCount">0</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill filter-pill" data-filter="part-time">
                        Part-time <span class="badge bg-secondary ms-2" id="parttimeJobsCount">0</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill filter-pill" data-filter="internship">
                        Internship <span class="badge bg-secondary ms-2" id="internshipJobsCount">0</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Search and Filter Section -->
        <div class="row mb-4">
            <div class="col-md-8">
                <div class="input-group">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-search"></i>
                    </span>
                    <input type="text" class="form-control" id="searchKeyword" placeholder="Job title, keywords, or company">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-map-marker-alt"></i>
                    </span>
                    <input type="text" class="form-control" id="searchLocation" placeholder="Location or 'Remote'">
                    <button class="btn btn-primary" type="button" id="searchButton">Search</button>
                </div>
            </div>
            <div class="col-md-4">
                <button class="btn btn-outline-secondary w-100" type="button" data-bs-toggle="collapse" data-bs-target="#filterOptions">
                    <i class="fas fa-sliders-h me-2"></i>Advanced Filters
                </button>
            </div>
        </div>

        <!-- Advanced Filters -->
        <div class="collapse mb-4" id="filterOptions">
            <div class="card card-body border-0 bg-light-subtle">
                <div class="row g-4">
                    <!-- Location Type -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Location Type</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="location_type" value="remote" id="remote">
                                <label class="form-check-label" for="remote">Remote</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="location_type" value="onsite" id="onsite">
                                <label class="form-check-label" for="onsite">On-site</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="location_type" value="hybrid" id="hybrid">
                                <label class="form-check-label" for="hybrid">Hybrid</label>
                            </div>
                        </div>
                    </div>

                    <!-- Experience Level -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Experience Level</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="experience_level" value="entry" id="entry">
                                <label class="form-check-label" for="entry">Entry Level</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="experience_level" value="mid" id="mid">
                                <label class="form-check-label" for="mid">Mid-Senior</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="experience_level" value="senior" id="senior">
                                <label class="form-check-label" for="senior">Senior</label>
                            </div>
                        </div>
                    </div>

                    <!-- Salary Range -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Salary Range</label>
                        <div class="vstack gap-2">
                            <input type="range" class="form-range" min="0" max="200000000" step="1000" id="salaryRange">
                            <div class="d-flex justify-content-between">
                                <span class="small">$30k</span>
                                <span class="small" id="currentSalary">$115k</span>
                                <span class="small">$200k</span>
                            </div>
                        </div>
                    </div>

                    <!-- Job Type -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Job Type</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="job_type" value="full-time" id="fulltime">
                                <label class="form-check-label" for="fulltime">Full-time</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="job_type" value="part-time" id="parttime">
                                <label class="form-check-label" for="parttime">Part-time</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="job_type" value="contract" id="contract">
                                <label class="form-check-label" for="contract">Contract</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="job_type" value="internship" id="internship">
                                <label class="form-check-label" for="internship">Internship</label>
                            </div>
                        </div>
                    </div>


                </div>

                <!-- Filter Actions -->
                <div class="row mt-4">
                    <div class="col-12">
                        <button class="btn btn-primary me-2" id="applyFilters">Apply Filters</button>
                        <button class="btn btn-outline-secondary" id="resetFilters">Reset</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Jobs Grid -->
        <div class="row" id="jobsGrid">
            <!-- Jobs will be dynamically added here -->
        </div>

        <!-- Recommended Jobs Section -->
        <div class="row mt-4">
            <div class="col-12">
                <h3 class="mb-4">Recommended for You</h3>
            </div>
            <div class="col-12" id="recommendedJobs">
                <!-- Recommended jobs will be dynamically added here -->
            </div>
        </div>
    </div>
</div>

<!-- Quick Apply Modal -->
<div class="modal fade" id="quickApplyModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quick Apply</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="quickApplyForm">
                    <input type="hidden" id="quickApplyJobId">
                    <div class="mb-3">
                        <label class="form-label">Phone Number <span class="text-danger">*</span></label>
                        <input type="tel" class="form-control" name="phone" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Resume/CV <span class="text-danger">*</span></label>
                        <input type="file" class="form-control" name="cv_file" accept=".pdf,.doc,.docx" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Cover Letter</label>
                        <textarea class="form-control" name="cover_letter" rows="4"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="submitQuickApply">Submit Application</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.1/moment.min.js"></script>
<script src="{{ asset('assets/js/jobs.js') }}"></script>
@endpush

@endsection