@extends('front_end.layouts.home')

@section('title', 'Site Maintenance')

@php
    $showLeftSidebar = false;
    $showRightSidebar = false;
@endphp

@push('styles')
<style>
    .maintenance-container {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, var(--bs-primary) 0%, #6610f2 100%);
        border-radius: 1rem;
        margin: 2rem 0;
        overflow: hidden;
        position: relative;
    }

    .maintenance-content {
        text-align: center;
        color: white;
        padding: 2rem;
        z-index: 2;
    }

    .maintenance-title {
        font-size: 3.5rem;
        font-weight: bold;
        margin-bottom: 1.5rem;
        opacity: 0;
        transform: translateY(-20px);
        animation: fadeInDown 0.6s ease forwards;
    }

    .maintenance-message {
        font-size: 1.25rem;
        margin-bottom: 2rem;
        opacity: 0;
        transform: translateY(20px);
        animation: fadeInUp 0.6s ease 0.3s forwards;
    }

    .maintenance-icon {
        font-size: 5rem;
        margin-bottom: 2rem;
        opacity: 0;
        animation: rotate 0.8s ease 0.6s forwards;
    }

    .maintenance-timer {
        font-size: 1.5rem;
        margin-top: 2rem;
        opacity: 0;
        animation: fadeIn 0.6s ease 0.9s forwards;
    }

    .floating-gears {
        position: absolute;
        opacity: 0.1;
    }

    .gear-1 {
        top: 10%;
        left: 10%;
        animation: floatAnimation 6s infinite ease-in-out;
    }

    .gear-2 {
        bottom: 10%;
        right: 10%;
        animation: floatAnimation 8s infinite ease-in-out reverse;
    }

    @keyframes fadeInDown {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes fadeIn {
        to {
            opacity: 1;
        }
    }

    @keyframes rotate {
        from {
            transform: rotate(-180deg);
            opacity: 0;
        }
        to {
            transform: rotate(0);
            opacity: 1;
        }
    }

    @keyframes floatAnimation {
        0%, 100% {
            transform: translateY(0) rotate(0);
        }
        50% {
            transform: translateY(-20px) rotate(180deg);
        }
    }
</style>
@endpush

@section('content')
<div class="container">
    <div class="maintenance-container">
        <div class="floating-gears gear-1">
            <i class="fas fa-cog fa-7x"></i>
        </div>
        <div class="floating-gears gear-2">
            <i class="fas fa-cog fa-5x"></i>
        </div>
        <div class="maintenance-content">
            <div class="maintenance-icon">
                <i class="fas fa-tools"></i>
            </div>
            <h1 class="maintenance-title">Site Under Maintenance</h1>
            <p class="maintenance-message">We're currently working on making Socialink even better for you! Our team is performing some essential updates and maintenance.</p>
            <div class="maintenance-timer">
                <p>Expected completion time: <span id="completionTime">2 hours</span></p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // You can add dynamic countdown timer here if needed
    document.addEventListener('DOMContentLoaded', function() {
        // Example: Update completion time dynamically
        const completionTime = document.getElementById('completionTime');
        // Add your countdown logic here if needed
    });
</script>
@endpush