<!-- Responsive Sidebar Toggle -->
<div class="d-flex align-items-center d-lg-none">
    <button class="border-0 bg-transparent" type="button" data-bs-toggle="offcanvas"
        data-bs-target="#offcanvasSideNavbar" aria-controls="offcanvasSideNavbar">
        <span class="btn btn-primary"><i class="bi bi-list"></i></span>
        <span class="h6 mb-0 fw-bold d-lg-none ms-2">Menu</span>
    </button>
</div>

<!-- Sidebar Navigation -->
<nav class="navbar navbar-expand-lg mx-0">
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSideNavbar">
        <!-- Offcanvas Header -->
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">Marketplace Menu</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>

        <!-- Offcanvas Body -->
        <div class="offcanvas-body d-block px-2 px-lg-0">
            <!-- Menu START -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-body p-3">
                    <ul class="nav flex-column fw-bold gap-2">
                        <!-- Marketplace Main Navigation -->
                        <li class="nav-title">Marketplace</li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ route('marketplace.index') }}">
                                <i class="bi bi-shop text-primary me-2"></i><span>Browse All</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ route('marketplace.saved') }}">
                                <i class="bi bi-heart text-primary me-2"></i><span>Saved Items</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ route('marketplace.create') }}">
                                <i class="bi bi-plus-circle text-primary me-2"></i><span>Sell an Item</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ route('marketplace.my-listings') }}">
                                <i class="bi bi-box text-primary me-2"></i><span>My Listings</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="{{ route('marketplace.messages') }}">
                                <i class="bi bi-chat-dots text-primary me-2"></i><span>Messages</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Categories -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">Categories</h6>
                </div>
                <div class="card-body p-3">
                    <ul class="nav flex-column fw-normal gap-1">
                        @foreach($categories ?? [] as $category)
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center justify-content-between" 
                                   href="{{ route('marketplace.index', ['category_id' => $category->id]) }}">
                                    <span>{{ $category->name }}</span>
                                    <span class="badge bg-light text-dark rounded-pill">{{ $category->products_count ?? 0 }}</span>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            
            <!-- Price Ranges -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">Price Range</h6>
                </div>
                <div class="card-body p-3">
                    <ul class="nav flex-column fw-normal gap-1">
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" 
                               href="{{ route('marketplace.index', ['min_price' => 0, 'max_price' => 100]) }}">
                                <span>Under $100</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" 
                               href="{{ route('marketplace.index', ['min_price' => 100, 'max_price' => 500]) }}">
                                <span>$100 - $500</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" 
                               href="{{ route('marketplace.index', ['min_price' => 500, 'max_price' => 1000]) }}">
                                <span>$500 - $1000</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" 
                               href="{{ route('marketplace.index', ['min_price' => 1000]) }}">
                                <span>Over $1000</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Conditions -->
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">Item Condition</h6>
                </div>
                <div class="card-body p-3">
                    <ul class="nav flex-column fw-normal gap-1">
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" 
                               href="{{ route('marketplace.index', ['type' => 'new']) }}">
                                <span>New</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" 
                               href="{{ route('marketplace.index', ['type' => 'like_new']) }}">
                                <span>Like New</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" 
                               href="{{ route('marketplace.index', ['type' => 'used']) }}">
                                <span>Used</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Recently Viewed -->
            @if(isset($recentlyViewed) && count($recentlyViewed) > 0)
            <div class="card sidebar-menu shadow-sm border-0 rounded-3 mb-3">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">Recently Viewed</h6>
                </div>
                <div class="card-body p-3">
                    <div class="vstack gap-3">
                        @foreach($recentlyViewed as $product)
                            <div class="d-flex align-items-center">
                                <img src="{{ asset('storage/' . ($product->media->first()->image ?? 'placeholder.jpg')) }}" 
                                     alt="{{ $product->name }}" class="rounded me-2" style="width: 40px; height: 40px; object-fit: cover;">
                                <div>
                                    <a href="{{ route('marketplace.show', $product->id) }}" class="text-reset fw-bold d-block text-truncate" 
                                       style="max-width: 150px;">{{ $product->name }}</a>
                                    <span class="small text-primary">{{ $product->price }} {{ $product->currency }}</span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif
            
            @include('front_end.components.footer_left_sidebar')
        </div>
    </div>
</nav>