@extends('front_end.layouts.app')

@section('title', 'My Listings | Marketplace')

@section('content')
<div class="container py-4">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            @include('front_end.pages.marketplace.partials.sidebar')
        </div>
        
        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="card shadow-sm">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">My Listings</h5>
                    <a href="{{ route('marketplace.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> Add New Listing
                    </a>
                </div>
                <div class="card-body">
                    @if($products->count() > 0)
                        <div class="row">
                            @foreach($products as $product)
                                <div class="col-md-4 mb-4">
                                    <div class="card h-100 product-card">
                                        <div class="position-relative">
                                            @if($product->getMedia()->isNotEmpty())
                                                <img src="{{ $product->getMedia()->first()->getUrl() }}" class="card-img-top product-img" alt="{{ $product->name }}">
                                            @else
                                                <img src="{{ asset('assets/images/placeholder.jpg') }}" class="card-img-top product-img" alt="No Image">
                                            @endif
                                            
                                            <div class="product-status-badge">
                                                @if($product->status == 'active')
                                                    <span class="badge bg-success">Active</span>
                                                @elseif($product->status == 'pending')
                                                    <span class="badge bg-warning">Pending</span>
                                                @elseif($product->status == 'sold')
                                                    <span class="badge bg-secondary">Sold</span>
                                                @elseif($product->status == 'inactive')
                                                    <span class="badge bg-danger">Inactive</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <h5 class="card-title">{{ $product->name }}</h5>
                                            <p class="card-text text-muted">{{ Str::limit($product->description, 50) }}</p>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="text-primary fw-bold">{{ $product->currency }} {{ number_format($product->price, 2) }}</span>
                                                <span class="text-muted small">
                                                    <i class="fas fa-eye"></i> {{ $product->views ?? 0 }} views
                                                </span>
                                            </div>
                                        </div>
                                        <div class="card-footer bg-white">
                                            <div class="btn-group btn-group-sm w-100">
                                                <a href="{{ route('marketplace.edit', $product->id) }}" class="btn btn-outline-primary">
                                                    <i class="fas fa-edit"></i> Edit
                                                </a>
                                                <a href="{{ route('marketplace.product.detail', $product->id) }}" class="btn btn-outline-info">
                                                    <i class="fas fa-eye"></i> View
                                                </a>
                                                <button type="button" class="btn btn-outline-danger delete-product" data-id="{{ $product->id }}" data-name="{{ $product->name }}">
                                                    <i class="fas fa-trash"></i> Delete
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        <!-- Pagination -->
                        <div class="d-flex justify-content-center mt-4">
                            {{ $products->links('pagination::bootstrap-5') }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <img src="{{ asset('assets/images/empty-state.svg') }}" alt="No listings" class="mb-3" style="max-width: 150px;">
                            <h4>No Listings Found</h4>
                            <p class="text-muted">You haven't created any product listings yet.</p>
                            <a href="{{ route('marketplace.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Create Your First Listing
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete <span id="product-name" class="fw-bold"></span>?</p>
                <p class="text-danger">This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="delete-form" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.delete-product').on('click', function() {
            const productId = $(this).data('id');
            const productName = $(this).data('name');
            
            $('#product-name').text(productName);
            $('#delete-form').attr('action', '{{ route('marketplace.delete', '') }}/' + productId);
            
            $('#deleteModal').modal('show');
        });
    });
</script>
@endpush

@push('styles')
<style>
    .product-img {
        height: 180px;
        object-fit: cover;
    }
    
    .product-card {
        transition: transform 0.3s;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }
    
    .product-status-badge {
        position: absolute;
        top: 10px;
        right: 10px;
    }
</style>
@endpush 