@extends('front_end.layouts.home')

@section('title', $genre->name . ' Movies')
@section('left_sidebar')
@include('front_end.pages.movies.movies_left_sidebar')
@endsection

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('movies.index') }}">Movies</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $genre->name }}</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="rounded-circle bg-primary bg-opacity-10 p-3 me-3" style="width: 65px; height: 65px;">
                            <i class="{{ $genre->icon ?? 'fas fa-film' }} fa-2x text-primary"></i>
                        </div>
                        <div>
                            <h1 class="mb-0">{{ $genre->name }} Movies</h1>
                            <p class="text-muted mb-0">{{ $movies->total() }} movies available</p>
                        </div>
                    </div>
                    @if($genre->description)
                    <div class="mt-3">
                        <p>{{ $genre->description }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <div class="row g-4">
        @forelse($movies as $movie)
        <div class="col-lg-3 col-md-4 col-sm-6">
            @include('front_end.pages.movies.partials.movie_card', ['movie' => $movie])
        </div>
        @empty
        <div class="col-12">
            <div class="alert alert-info">
                No movies found in this genre. Please check back later.
            </div>
        </div>
        @endforelse
    </div>
    
    <div class="row mt-4">
        <div class="col-12 d-flex justify-content-center">
            {{ $movies->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection