<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">Quick Search</h5>
        <form action="{{ route('search.movies') }}" method="GET">
            <div class="input-group mb-3">
                <input type="text" class="form-control" placeholder="Search movies..." name="q">
                <button class="btn btn-primary" type="submit">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>

@if(isset($genres) && $genres->isNotEmpty())
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">Genres</h5>
        <ul class="list-group list-group-flush">
            @foreach($genres as $genre)
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('movies.genre', $genre->slug) }}" class="text-decoration-none d-flex justify-content-between align-items-center">
                    <span>
                        <i class="{{ $genre->icon ?? 'fas fa-film' }} me-2 text-primary"></i>
                        {{ $genre->name }}
                    </span>
                    <span class="badge bg-light text-dark rounded-pill">{{ $genre->movies_count }}</span>
                </a>
            </li>
            @endforeach
        </ul>
    </div>
</div>
@endif

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">Browse</h5>
        <ul class="list-group list-group-flush">
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.movies') }}?featured=1" class="text-decoration-none">
                    <i class="fas fa-star me-2 text-warning"></i> Featured Movies
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.movies') }}?sort=newest" class="text-decoration-none">
                    <i class="fas fa-calendar-alt me-2 text-primary"></i> Newest Releases
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.movies') }}?sort=popularity" class="text-decoration-none">
                    <i class="fas fa-fire me-2 text-danger"></i> Most Popular
                </a>
            </li>
            <li class="list-group-item border-0 px-0 py-2">
                <a href="{{ route('search.movies') }}?sort=rating" class="text-decoration-none">
                    <i class="fas fa-award me-2 text-success"></i> Top Rated
                </a>
            </li>
        </ul>
    </div>
</div>
