<div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
    <a href="{{ route('movies.show', $movie->slug) }}" class="text-decoration-none">
        <div class="position-relative">
            <img src="{{ $movie->poster_url ?? asset('images/movie-placeholder.jpg') }}" class="card-img-top" alt="{{ $movie->title }}" style="height: 200px; object-fit: cover;">
            <div class="position-absolute bottom-0 end-0 p-2">
                <span class="badge bg-primary">{{ $movie->content_rating }}</span>
            </div>
            @if($movie->featured)
            <div class="position-absolute top-0 start-0 p-2">
                <span class="badge bg-warning">Featured</span>
            </div>
            @endif
        </div>
    </a>
    <div class="card-body">
        <a href="{{ route('movies.show', $movie->slug) }}" class="text-decoration-none">
            <h5 class="card-title text-truncate">{{ $movie->title }}</h5>
        </a>
        <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="movie-rating" data-rating="{{ $movie->avg_rating }}"></div>
            <small class="text-muted">{{ $movie->release_year }}</small>
        </div>
        <p class="card-text text-muted small mb-2 text-truncate">
            <i class="fas fa-film me-1"></i> {{ $movie->genre->name ?? 'Unknown' }}
        </p>
        <p class="card-text text-muted small mb-0">
            <i class="fas fa-clock me-1"></i> {{ $movie->duration }} min
        </p>
    </div>
    <div class="card-footer bg-white border-0 d-flex justify-content-between">
        <a href="{{ route('movies.show', $movie->slug) }}" class="btn btn-sm btn-outline-primary">Details</a>
        <a href="{{ route('movies.watch', $movie->slug) }}" class="btn btn-sm btn-primary">
            <i class="fas fa-play me-1"></i> Watch
        </a>
    </div>
</div>