@extends('admin.layouts.home')

@section('title', 'Notification List')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">Notification List</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ url('home') }}">Dashboard</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.notifications.index') }}">Notifications</a></li>
        <li class="breadcrumb-item active">List</li>
    </ol>
    
    <!-- Filter Card -->
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-filter me-1"></i>
            Filter Notifications
        </div>
        <div class="card-body">
            <form action="{{ route('admin.notifications.list') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label for="sender" class="form-label">Sender</label>
                    <input type="text" class="form-control" id="sender" name="sender" value="{{ request('sender') }}" placeholder="User ID">
                </div>
                <div class="col-md-3">
                    <label for="receiver" class="form-label">Receiver</label>
                    <input type="text" class="form-control" id="receiver" name="receiver" value="{{ request('receiver') }}" placeholder="User ID">
                </div>
                <div class="col-md-3">
                    <label for="type" class="form-label">Type</label>
                    <select class="form-select" id="type" name="type">
                        <option value="">All Types</option>
                        @foreach($types as $type)
                        <option value="{{ $type }}" {{ request('type') == $type ? 'selected' : '' }}>
                            {{ ucwords(str_replace('_', ' ', $type)) }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="seen_status" class="form-label">Read Status</label>
                    <select class="form-select" id="seen_status" name="seen_status">
                        <option value="">All</option>
                        <option value="read" {{ request('seen_status') == 'read' ? 'selected' : '' }}>Read</option>
                        <option value="unread" {{ request('seen_status') == 'unread' ? 'selected' : '' }}>Unread</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="date_from" class="form-label">From Date</label>
                    <input type="date" class="form-control" id="date_from" name="date_from" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">To Date</label>
                    <input type="date" class="form-control" id="date_to" name="date_to" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-3">
                    <label for="sort" class="form-label">Sort By</label>
                    <select class="form-select" id="sort" name="sort">
                        <option value="newest" {{ request('sort', 'newest') == 'newest' ? 'selected' : '' }}>Newest First</option>
                        <option value="oldest" {{ request('sort') == 'oldest' ? 'selected' : '' }}>Oldest First</option>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Apply Filters</button>
                    <a href="{{ route('admin.notifications.list') }}" class="btn btn-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Notifications Table -->
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-table me-1"></i>
            Notifications
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Type</th>
                            <th>Text</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($notifications as $notification)
                        <tr>
                            <td>{{ $notification->id }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <img src="{{ $notification->sender->profile_photo ? asset('storage/' . $notification->sender->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                         class="rounded-circle me-2" alt="{{ $notification->sender->name }}" width="30" height="30">
                                    <span>{{ $notification->sender->name }} (ID: {{ $notification->sender->id }})</span>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                <img src="{{ $notification->receiver->profile_photo ? asset('storage/' . $notification->receiver->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                         class="rounded-circle me-2" alt="{{ $notification->receiver->name }}" width="30" height="30">
                                    <span>{{ $notification->receiver->name }} (ID: {{ $notification->receiver->id }})</span>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-info">
                                    {{ ucwords(str_replace('_', ' ', $notification->type)) }}
                                </span>
                            </td>
                            <td>{{ Str::limit($notification->text, 50) }}</td>
                            <td>
                                <span class="badge bg-{{ $notification->seen ? 'success' : 'warning' }}">
                                    {{ $notification->seen ? 'Read' : 'Unread' }}
                                </span>
                            </td>
                            <td>
                                {{ $notification->created_at->format('M d, Y H:i') }}
                                <div class="small text-muted">{{ $notification->created_at->diffForHumans() }}</div>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#viewModal{{ $notification->id }}">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <form action="{{ route('admin.notifications.delete', $notification->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this notification?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                                
                                <!-- View Modal -->
                                <div class="modal fade" id="viewModal{{ $notification->id }}" tabindex="-1" aria-labelledby="viewModalLabel{{ $notification->id }}" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="viewModalLabel{{ $notification->id }}">
                                                    Notification Details
                                                </h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <table class="table table-bordered">
                                                    <tr>
                                                        <th>ID</th>
                                                        <td>{{ $notification->id }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>From</th>
                                                        <td>{{ $notification->sender->name }} (ID: {{ $notification->sender->id }})</td>
                                                    </tr>
                                                    <tr>
                                                        <th>To</th>
                                                        <td>{{ $notification->receiver->name }} (ID: {{ $notification->receiver->id }})</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Type</th>
                                                        <td>{{ ucwords(str_replace('_', ' ', $notification->type)) }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Text</th>
                                                        <td>{{ $notification->text }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Status</th>
                                                        <td>
                                                            <span class="badge bg-{{ $notification->seen ? 'success' : 'warning' }}">
                                                                {{ $notification->seen ? 'Read' : 'Unread' }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Created</th>
                                                        <td>{{ $notification->created_at->format('M d, Y H:i:s') }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Updated</th>
                                                        <td>{{ $notification->updated_at->format('M d, Y H:i:s') }}</td>
                                                    </tr>
                                                    @if($notification->post_id)
                                                    <tr>
                                                        <th>Post ID</th>
                                                        <td>{{ $notification->post_id }}</td>
                                                    </tr>
                                                    @endif
                                                    @if($notification->group_id)
                                                    <tr>
                                                        <th>Group ID</th>
                                                        <td>{{ $notification->group_id }}</td>
                                                    </tr>
                                                    @endif
                                                    @if($notification->page_id)
                                                    <tr>
                                                        <th>Page ID</th>
                                                        <td>{{ $notification->page_id }}</td>
                                                    </tr>
                                                    @endif
                                                    <tr>
                                                        <th>Reacted</th>
                                                        <td>
                                                            <span class="badge bg-{{ $notification->is_reacted ? 'info' : 'secondary' }}">
                                                                {{ $notification->is_reacted ? 'Yes' : 'No' }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $notifications->appends(request()->query())->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection