@extends('front_end.pages.settings.layout')

@section('title', 'Delete Account - Socialink')

@section('settings_content')
<div class="card mb-4">
    <div class="card-header with-icon p-4">
        <div class="main-icon text-danger">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>
        </div>
        <h5 class="mb-0 ms-2 text-danger">Delete Account</h5>
    </div>
    <div class="card-body p-4">
        @if(session('error'))
        <div class="alert alert-danger mb-4">
            {{ session('error') }}
        </div>
        @endif
        
        <div class="alert alert-warning mb-4">
            <h6 class="alert-heading"><i class="fas fa-exclamation-triangle me-2"></i>Warning: This action is permanent</h6>
            <p class="mb-0">Deleting your account will remove all your data from our platform. This action cannot be undone.</p>
        </div>
        
        <p class="text-muted mb-4">Before you proceed, please understand the following:</p>
        
        <ul class="mb-4">
            <li class="mb-2">All your personal information will be permanently deleted</li>
            <li class="mb-2">Your posts, comments, and all content you've created will be removed</li>
            <li class="mb-2">You will lose access to all groups, pages, and connections</li>
            <li class="mb-2">Any subscriptions or paid services will be canceled</li>
            <li class="mb-2">This action cannot be reversed</li>
        </ul>
        
        <form action="{{ route('settings.account.delete') }}" method="POST">
            @csrf
            
            <div class="form-group mb-3">
                <label class="form-label" for="reason">Please tell us why you're leaving (optional)</label>
                <select class="form-select mb-2" id="reason" name="reason">
                    <option value="">Select a reason</option>
                    <option value="privacy_concerns">Privacy concerns</option>
                    <option value="too_many_ads">Too many ads</option>
                    <option value="not_useful">Not finding the platform useful</option>
                    <option value="harassment">Experiencing harassment</option>
                    <option value="created_new_account">Created a new account</option>
                    <option value="temporary_break">Taking a temporary break</option>
                    <option value="other">Other reason</option>
                </select>
                <textarea class="form-control" id="reason_details" name="reason_details" rows="3" placeholder="Additional details (optional)"></textarea>
            </div>
            
            <div class="form-group mb-4">
                <label class="form-label" for="password">Please enter your password to confirm</label>
                <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password" required>
                @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-check mb-4">
                <input class="form-check-input @error('confirm_delete') is-invalid @enderror" type="checkbox" id="confirm_delete" name="confirm_delete" required>
                <label class="form-check-label" for="confirm_delete">
                    I understand that this action is permanent and cannot be undone
                </label>
                @error('confirm_delete')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="{{ route('settings.account') }}" class="btn btn-outline-secondary">Cancel</a>
                <button type="submit" class="btn btn-danger">Permanently Delete My Account</button>
            </div>
        </form>
    </div>
</div>
@endsection 