@extends('front_end.layouts.home')

@section('title', $title ?? 'Settings - Socialink')

@php
$showRightSidebar = false;
$showLeftSidebar = false;
@endphp

@push('styles')
<style>
    .settings-sidebar .card {
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }
    
    .settings-sidebar .side-nav {
        padding: 0;
        list-style: none;
    }
    
    .settings-sidebar .side-nav li {
        margin-bottom: 5px;
    }
    
    .settings-sidebar .side-nav a {
        display: block;
        padding: 12px 15px;
        border-radius: 8px;
        color: var(--bs-body-color);
        text-decoration: none;
        transition: all 0.2s ease;
    }
    
    .settings-sidebar .side-nav a:hover,
    .settings-sidebar .side-nav a.active {
        background-color: rgba(var(--bs-primary-rgb), 0.1);
        color: var(--bs-primary);
    }
    
    .settings-sidebar .side-nav a.active {
        font-weight: 600;
    }
    
    .settings-sidebar .side-nav i,
    .settings-sidebar .side-nav svg {
        margin-right: 10px;
        width: 18px;
        height: 18px;
    }
    
    .card-header.with-icon {
        display: flex;
        align-items: center;
    }
    
    .card-header .main-icon {
        width: 24px;
        height: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .card-header .main-icon svg {
        width: 24px;
        height: 24px;
    }
</style>
@endpush

@section('content')
<div class="container">
    <div class="row g-4">
        <!-- Settings Sidebar -->
        <div class="col-lg-3 settings-sidebar">
            <div class="card mb-4">
                <div class="card-body p-4">
                    <h5 class="mb-4">Settings</h5>
                    <ul class="side-nav">
                        <li>
                            <a href="{{ route('settings.account') }}" class="{{ request()->routeIs('settings.account') ? 'active' : '' }}">
                                <i class="fas fa-cog"></i> Account Settings
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('settings.profile') }}" class="{{ request()->routeIs('settings.profile') ? 'active' : '' }}">
                                <i class="fas fa-user"></i> Profile Information
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('settings.security') }}" class="{{ request()->routeIs('settings.security') ? 'active' : '' }}">
                                <i class="fas fa-shield-alt"></i> Security
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('settings.notifications') }}" class="{{ request()->routeIs('settings.notifications') ? 'active' : '' }}">
                                <i class="fas fa-bell"></i> Notifications
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('settings.privacy') }}" class="{{ request()->routeIs('settings.privacy') ? 'active' : '' }}">
                                <i class="fas fa-lock"></i> Privacy
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('settings.verification') }}" class="{{ request()->routeIs('settings.verification') ? 'active' : '' }}">
                                <i class="fas fa-check-circle"></i> Verification
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('settings.blocking') }}" class="{{ request()->routeIs('settings.blocking') ? 'active' : '' }}">
                                <i class="fas fa-user-slash"></i> Blocking
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('settings.delete_account') }}" class="{{ request()->routeIs('settings.delete_account') ? 'active' : '' }}">
                                <i class="fas fa-trash text-danger"></i> <span class="text-danger">Delete Account</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <div class="card bg-light">
                <div class="card-body p-4">
                    <h6 class="mb-2">Need help?</h6>
                    <p class="small mb-1">Browse the <a href="{{ route('help-center.index') }}">Help Center</a> for walkthroughs on privacy, notifications, and account tools.</p>
                </div>
            </div>
        </div>
        
        <!-- Settings Content -->
        <div class="col-lg-9">
            @yield('settings_content')
        </div>
    </div>
</div>
@endsection
