@extends('front_end.pages.settings.layout')

@section('title', 'Privacy Settings - Socialink')

@section('settings_content')
<div class="card mb-4">
    <div class="card-header with-icon p-4">
        <div class="main-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
        </div>
        <h5 class="mb-0 ms-2">Privacy Settings</h5>
    </div>
    <div class="card-body p-4">
        @if(session('success'))
        <div class="alert alert-success mb-4">
            {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger mb-4">
            {{ session('error') }}
        </div>
        @endif
        
        <p class="text-muted mb-4">Control who can see your information and how your data is used on Socialink.</p>

        <form action="{{ route('settings.privacy.update') }}" method="POST" class="privacy-settings-form">
            @csrf
            @php
                $current = function ($key, $default = null) use ($privacySettings) {
                    return old($key, $privacySettings->{$key} ?? $default);
                };
            @endphp
            
            <!-- General Privacy Controls -->
            <div class="form-table-row mb-4 p-3 border-bottom">
                <div class="row align-items-center">
                    <div class="col-auto">
                        <div class="avatar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-label h6 mb-1">Chat Enabled</div>
                        <div class="form-text d-none d-sm-block">If chat disabled you will appear offline and will not see who is online</div>
                    </div>
                    <div class="col-auto text-end">
                        <label class="switch" for="chat_enabled">
                            <input type="checkbox" name="chat_enabled" id="chat_enabled" value="1" @checked($current('chat_enabled', true))>
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
            </div>
            
            <div class="form-table-row mb-4 p-3 border-bottom">
                <div class="row align-items-center">
                    <div class="col-auto">
                        <div class="avatar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-label h6 mb-1">Newsletter Subscription</div>
                        <div class="form-text d-none d-sm-block">From time to time we send newsletter email to all of our members</div>
                    </div>
                    <div class="col-auto text-end">
                        <label class="switch" for="newsletter_enabled">
                            <input type="checkbox" name="newsletter_enabled" id="newsletter_enabled" value="1" @checked($current('newsletter_enabled', true))>
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
            </div>
            
            <!-- Profile Privacy Section -->
            <h6 class="heading-small mb-3 mt-4">Profile Privacy</h6>
            <div class="ps-0 ps-md-3 mb-4">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="profile_visibility">Who can see your profile</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                            <select class="form-select" id="profile_visibility" name="profile_visibility">
                                @foreach(['public' => 'Everyone', 'friends' => 'Friends only', 'private' => 'Only me'] as $value => $label)
                                    <option value="{{ $value }}" @selected($current('profile_visibility', 'public') === $value)>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="friend_list_visibility">Who can see your friend list</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-users"></i></span>
                            <select class="form-select" id="friend_list_visibility" name="friend_list_visibility">
                                @foreach(['public' => 'Everyone', 'friends' => 'Friends only', 'private' => 'Only me'] as $value => $label)
                                    <option value="{{ $value }}" @selected($current('friend_list_visibility', 'public') === $value)>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="post_visibility">Default visibility for new posts</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-newspaper"></i></span>
                            <select class="form-select" id="post_visibility" name="post_visibility">
                                @foreach(['public' => 'Everyone', 'friends' => 'Friends only', 'followers' => 'Followers only', 'private' => 'Only me'] as $value => $label)
                                    <option value="{{ $value }}" @selected($current('post_visibility', 'public') === $value)>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Contact Privacy Section -->
            <h6 class="heading-small mb-3 mt-4">Contact Privacy</h6>
            <div class="ps-0 ps-md-3 mb-4">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="message_privacy">Who can send you messages</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-message"></i></span>
                            <select class="form-select" id="message_privacy" name="message_privacy">
                                @foreach(['everyone' => 'Everyone', 'friends' => 'Friends only', 'friends_of_friends' => 'Friends of friends', 'nobody' => 'Nobody'] as $value => $label)
                                    <option value="{{ $value }}" @selected($current('message_privacy', 'everyone') === $value)>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="friend_request_privacy">Who can send you friend requests</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-user-plus"></i></span>
                            <select class="form-select" id="friend_request_privacy" name="friend_request_privacy">
                                @foreach(['everyone' => 'Everyone', 'friends_of_friends' => 'Friends of friends', 'nobody' => 'Nobody'] as $value => $label)
                                    <option value="{{ $value }}" @selected($current('friend_request_privacy', 'everyone') === $value)>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="wall_posts_privacy">Who can post on your wall</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-newspaper"></i></span>
                            <select class="form-select" id="wall_posts_privacy" name="wall_posts_privacy">
                                @foreach(['everyone' => 'Everyone', 'friends' => 'Friends only', 'nobody' => 'Nobody'] as $value => $label)
                                    <option value="{{ $value }}" @selected($current('wall_posts_privacy', 'everyone') === $value)>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Search Privacy Section -->
            <h6 class="heading-small mb-3 mt-4">Search Privacy</h6>
            <div class="ps-0 ps-md-3 mb-4">
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Allow search engines to index your profile</div>
                            <div class="form-text d-none d-sm-block">If enabled, search engines like Google can show your profile in search results</div>
                        </div>
                        <div class="col-auto text-end">
                            <label class="switch" for="search_engine_visibility">
                                <input class="form-check-input" type="checkbox" id="search_engine_visibility" name="search_engine_visibility" value="1" @checked($current('search_engine_visibility', false))>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Allow people to find you by email or phone number</div>
                            <div class="form-text d-none d-sm-block">If enabled, people can find your profile by searching for your email or phone number</div>
                        </div>
                        <div class="col-auto text-end">
                            <label class="switch" for="discoverable_by_contact">
                                <input class="form-check-input" type="checkbox" id="discoverable_by_contact" name="discoverable_by_contact" value="1" @checked($current('discoverable_by_contact', true))>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Data Usage Section -->
            <h6 class="heading-small mb-3 mt-4">Data Usage</h6>
            <div class="ps-0 ps-md-3 mb-4">
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M17 18a2 2 0 0 1-2 2H9a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v12z"></path><path d="M17 14H7"></path><path d="M7 10h10"></path></svg>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Allow personalized ads based on your activity</div>
                            <div class="form-text d-none d-sm-block">If enabled, you'll see ads that are more relevant to your interests</div>
                        </div>
                        <div class="col-auto text-end">
                            <label class="switch" for="personalized_ads">
                                <input class="form-check-input" type="checkbox" id="personalized_ads" name="personalized_ads" value="1" @checked($current('personalized_ads', true))>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Allow data collection for platform improvement</div>
                            <div class="form-text d-none d-sm-block">If enabled, we'll use your activity data to improve our services</div>
                        </div>
                        <div class="col-auto text-end">
                            <label class="switch" for="data_collection">
                                <input class="form-check-input" type="checkbox" id="data_collection" name="data_collection" value="1" @checked($current('data_collection', true))>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary">Save Privacy Settings</button>
            </div>
        </form>
    </div>
</div>
@endsection
