@extends('front_end.pages.settings.layout')

@section('title', 'Profile Settings - Socialink')

@push('styles')
<link rel="stylesheet" href="{{ asset('css/notification-settings.css') }}">
@endpush

@section('settings_content')
<div class="card mb-4">
    <div class="card-header with-icon p-4">
        <div class="main-icon">
            <i class="bi bi-person-circle fs-3 text-primary"></i>
        </div>
        <h5 class="mb-0 ms-2">Profile Information</h5>
    </div>
    <div class="card-body p-4">
        @if(session('success'))
        <div class="alert alert-success mb-4">
            {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger mb-4">
            {{ session('error') }}
        </div>
        @endif

        <p class="text-muted mb-4">Manage your personal information, work experience, location, and education details.</p>

        <!-- Profile Photo Section -->
        <div class="row mb-5">
            <div class="col-12 text-center">
                <div class="position-relative d-inline-block">
                    <img src="{{ Auth::check() ? getMedia(Auth::user()->avatar) : asset('assets/images/avatar/07.jpg') }}" class="rounded-circle avatar-xl mb-3" alt="Profile Picture">
                    <label for="avatar" class="position-absolute bottom-10 end-0 bg-primary text-white rounded-circle px-2 py-1 cursor-pointer">
                        <i class="bi bi-camera"></i>
                        <input type="file" id="avatar" name="avatar" class="d-none">
                    </label>
                </div>
                <h4 class="mb-1">{{ auth()->user()->name }}</h4>
                <p class="text-muted">{{Auth::user()->username}}</p>
            </div>
        </div>

        <!-- Basic Information Section -->
        <h6 class="heading-small mb-3 mt-4">
            <i class="bi bi-person me-2"></i>Basic Information
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <form action="{{ route('settings.profile.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="section" value="basic">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-person-badge fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Name</div>
                            <div class="row">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <input type="text" class="form-control @error('first_name') is-invalid @enderror" id="first_name" name="first_name" value="{{ old('first_name', auth()->user()->first_name) }}" placeholder="First Name" required>
                                    @error('first_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control @error('last_name') is-invalid @enderror" id="last_name" name="last_name" value="{{ old('last_name', auth()->user()->last_name) }}" placeholder="Last Name" required>
                                    @error('last_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-chat-quote fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Bio</div>
                            <textarea class="form-control @error('bio') is-invalid @enderror" id="bio" name="bio" rows="4" placeholder="Tell others a little about yourself">{{ old('bio', auth()->user()->bio) }}</textarea>
                            @error('bio')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-calendar-date fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Personal Information</div>
                            <div class="row">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="date_of_birth">Birthday</label>
                                    <input type="date" class="form-control @error('date_of_birth') is-invalid @enderror" id="date_of_birth" name="date_of_birth" value="{{ old('date_of_birth', auth()->user()->date_of_birth ? date('Y-m-d', strtotime(auth()->user()->date_of_birth)) : '') }}">
                                    @error('date_of_birth')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="gender">Gender</label>
                                    <select class="form-select @error('gender') is-invalid @enderror" id="gender" name="gender">
                                        <option value="">Select Gender</option>
                                        <option value="male" {{ old('gender', auth()->user()->gender) == 'male' ? 'selected' : '' }}>Male</option>
                                        <option value="female" {{ old('gender', auth()->user()->gender) == 'female' ? 'selected' : '' }}>Female</option>
                                        <option value="other" {{ old('gender', auth()->user()->gender) == 'other' ? 'selected' : '' }}>Other</option>
                                        <option value="prefer_not_to_say" {{ old('gender', auth()->user()->gender) == 'prefer_not_to_say' ? 'selected' : '' }}>Prefer not to say</option>
                                    </select>
                                    @error('gender')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Basic Information
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Work Experience Section -->
        <h6 class="heading-small mb-3 mt-4 border-top pt-4">
            <i class="bi bi-briefcase me-2"></i>Work Experience
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <form action="{{ route('settings.profile.update') }}" method="POST">
                @csrf
                <input type="hidden" name="section" value="work">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-building fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Current Position</div>
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="job_title">Job Title</label>
                                    <input type="text" class="form-control @error('job_title') is-invalid @enderror" id="job_title" name="job_title" value="{{ old('job_title', auth()->user()->getMeta('job_title')) }}" placeholder="e.g. Software Engineer">
                                    @error('job_title')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="company">Company</label>
                                    <input type="text" class="form-control @error('company') is-invalid @enderror" id="company" name="company" value="{{ old('company', auth()->user()->getMeta('company')) }}" placeholder="e.g. Google">
                                    @error('company')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="work_started">Started</label>
                                    <input type="month" class="form-control @error('work_started') is-invalid @enderror" id="work_started" name="work_started" value="{{ old('work_started', auth()->user()->getMeta('work_started')) }}">
                                    @error('work_started')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="work_ended">Ended (leave blank if current)</label>
                                    <input type="month" class="form-control @error('work_ended') is-invalid @enderror" id="work_ended" name="work_ended" value="{{ old('work_ended', auth()->user()->getMeta('work_ended')) }}">
                                    @error('work_ended')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div>
                                <label class="form-label" for="work_description">Description</label>
                                <textarea class="form-control @error('work_description') is-invalid @enderror" id="work_description" name="work_description" rows="3" placeholder="Describe your role and responsibilities">{{ old('work_description', auth()->user()->getMeta('work_description')) }}</textarea>
                                @error('work_description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Work Experience
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Location Section -->
        <h6 class="heading-small mb-3 mt-4 border-top pt-4">
            <i class="bi bi-geo-alt me-2"></i>Location
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <form action="{{ route('settings.profile.update') }}" method="POST">
                @csrf
                <input type="hidden" name="section" value="location">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-globe fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Where You Live</div>
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="country">Country</label>
                                    <select class="form-select @error('country') is-invalid @enderror" id="country" name="country">
                                        <option value="">Select Country</option>
                                        <option value="US" {{ old('country', auth()->user()->getMeta('country')) == 'US' ? 'selected' : '' }}>United States</option>
                                        <option value="UK" {{ old('country', auth()->user()->getMeta('country')) == 'UK' ? 'selected' : '' }}>United Kingdom</option>
                                        <option value="CA" {{ old('country', auth()->user()->getMeta('country')) == 'CA' ? 'selected' : '' }}>Canada</option>
                                        <option value="AU" {{ old('country', auth()->user()->getMeta('country')) == 'AU' ? 'selected' : '' }}>Australia</option>
                                        <option value="IN" {{ old('country', auth()->user()->getMeta('country')) == 'IN' ? 'selected' : '' }}>India</option>
                                        <!-- Add more countries as needed -->
                                    </select>
                                    @error('country')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="city">City</label>
                                    <input type="text" class="form-control @error('city') is-invalid @enderror" id="city" name="city" value="{{ old('city', auth()->user()->getMeta('city')) }}" placeholder="e.g. San Francisco">
                                    @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div>
                                <label class="form-label" for="address">Address (only visible to you)</label>
                                <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="2" placeholder="Your street address">{{ old('address', auth()->user()->getMeta('address')) }}</textarea>
                                @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">This is only used for location-based features and will not be shown publicly.</small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Location
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Education Section -->
        <h6 class="heading-small mb-3 mt-4 border-top pt-4">
            <i class="bi bi-mortarboard me-2"></i>Education
        </h6>
        <div class="ps-0 ps-md-3">
            <form action="{{ route('settings.profile.update') }}" method="POST">
                @csrf
                <input type="hidden" name="section" value="education">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-book fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Educational Background</div>
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="school">School/University</label>
                                    <input type="text" class="form-control @error('school') is-invalid @enderror" id="school" name="school" value="{{ old('school', auth()->user()->getMeta('school')) }}" placeholder="e.g. Stanford University">
                                    @error('school')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="degree">Degree</label>
                                    <input type="text" class="form-control @error('degree') is-invalid @enderror" id="degree" name="degree" value="{{ old('degree', auth()->user()->getMeta('degree')) }}" placeholder="e.g. Bachelor of Science in Computer Science">
                                    @error('degree')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="edu_started">Started</label>
                                    <input type="month" class="form-control @error('edu_started') is-invalid @enderror" id="edu_started" name="edu_started" value="{{ old('edu_started', auth()->user()->getMeta('edu_started')) }}">
                                    @error('edu_started')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="edu_ended">Ended (leave blank if current)</label>
                                    <input type="month" class="form-control @error('edu_ended') is-invalid @enderror" id="edu_ended" name="edu_ended" value="{{ old('edu_ended', auth()->user()->getMeta('edu_ended')) }}">
                                    @error('edu_ended')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div>
                                <label class="form-label" for="edu_description">Description</label>
                                <textarea class="form-control @error('edu_description') is-invalid @enderror" id="edu_description" name="edu_description" rows="3" placeholder="Describe your field of study and achievements">{{ old('edu_description', auth()->user()->getMeta('edu_description')) }}</textarea>
                                @error('edu_description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Education
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection