@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp

@section('title', 'Wallet')

@section('left_sidebar')
@include('front_end.pages.events.events_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Wallet Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Wallet</h4>
                                    <p class="mb-0 text-white">Manage your funds and transactions</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <!-- Balance Cards -->
        <div class="row">
            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Available Balance</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">${{ number_format($wallet->balance, 2) }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-wallet fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending Balance</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">${{ number_format($wallet->pending_balance, 2) }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-clock fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Earned</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">${{ number_format($stats['total_earned'], 2) }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row mb-4">
            <div class="col-sm-6 col-md-3">
                <button class="btn btn-light w-100 d-flex align-items-center justify-content-center gap-2 p-3" data-bs-toggle="modal" data-bs-target="#addMoneyModal">
                    <i class="fas fa-plus-circle text-primary"></i>
                    Add Money
                </button>
            </div>
            <div class="col-sm-6 col-md-3">
                <a href="{{ route('wallet.transfer') }}" class="btn btn-light w-100 d-flex align-items-center justify-content-center gap-2 p-3">
                    <i class="fas fa-paper-plane text-success"></i>
                    Transfer Money
                </a>
            </div>
            <div class="col-sm-6 col-md-3">
                <a href="{{ route('wallet.withdraw') }}" class="btn btn-light w-100 d-flex align-items-center justify-content-center gap-2 p-3">
                    <i class="fas fa-money-bill-wave text-warning"></i>
                    Withdraw
                </a>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="dropdown">
                    <button class="btn btn-light w-100 d-flex align-items-center justify-content-center gap-2 p-3" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-history text-info"></i>
                        History
                        <i class="fas fa-chevron-down ms-1"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="{{ route('wallet.transactions') }}"><i class="fas fa-exchange-alt me-2"></i>Transactions</a></li>
                        <li><a class="dropdown-item" href="{{ route('wallet.withdrawals') }}"><i class="fas fa-money-bill-wave me-2"></i>Withdrawals</a></li>
                        <li><a class="dropdown-item" href="#" onclick="loadDepositHistory()"><i class="fas fa-plus-circle me-2"></i>Deposits</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Recent Transactions -->
        <div class="row">
            <div class="col-lg-6 mb-4">
                <div class="card shadow">
                    <div class="card-header py-3 d-flex justify-content-between align-items-center">
                        <h6 class="m-0 font-weight-bold text-primary">Recent Transactions</h6>
                        <button class="btn btn-sm btn-primary" onclick="loadTransactionHistory()">View All</button>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Description</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($recentTransactions as $transaction)
                                    <tr>
                                        <td>{{ $transaction->created_at->format('M d, Y') }}</td>
                                        <td>{{ $transaction->description }}</td>
                                        <td>
                                            @if($transaction->type == 'credit' || $transaction->flag == 'C')
                                            <span class="text-success">+${{ number_format($transaction->amount, 2) }}</span>
                                            @else
                                            <span class="text-danger">-${{ number_format($transaction->amount, 2) }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="3" class="text-center">No transactions found.</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Earning Actions -->
            <div class="col-lg-6 mb-4">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Top Earning Actions</h6>
                    </div>
                    <div class="card-body">
                        @if(count($topEarningActions) > 0)
                        <div class="mb-4">
                            @foreach($topEarningActions as $action)
                            <h4 class="small font-weight-bold">
                                {{ ucfirst(str_replace('_', ' ', $action->reference_type)) }}
                                <span class="float-right">${{ number_format($action->total_amount, 2) }}</span>
                            </h4>
                            <div class="progress mb-4">
                                <div class="progress-bar bg-success" role="progressbar" style="width: {{ min(100, ($action->total_amount / max(0.01, $stats['total_earned'])) * 100) }}%"></div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="text-center py-3">
                            <p class="text-muted">Start earning by completing actions!</p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Money Modal -->
<div class="modal fade" id="addMoneyModal" tabindex="-1" aria-labelledby="addMoneyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addMoneyModalLabel">Add Money to Wallet</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="list-group">
                    @if(setting('stripe_payment', 1))
                        <a href="{{ route('wallet.deposit.stripe') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                            <i class="fab fa-cc-stripe text-primary me-3"></i>
                            <div>
                                <div class="fw-semibold">Stripe</div>
                                <small class="text-muted">Pay with credit/debit card</small>
                            </div>
                            <i class="fas fa-chevron-right ms-auto text-muted"></i>
                        </a>
                    @endif

                    @if(setting('paypal_payment', 1))
                        <a href="{{ route('wallet.deposit.paypal') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                            <i class="fab fa-cc-paypal text-primary me-3"></i>
                            <div>
                                <div class="fw-semibold">PayPal</div>
                                <small class="text-muted">Redirect to PayPal checkout</small>
                            </div>
                            <i class="fas fa-chevron-right ms-auto text-muted"></i>
                        </a>
                    @endif

                    @if(setting('flutterwave_payment', 0))
                        <a href="{{ route('wallet.deposit.flutterwave') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                            <i class="fas fa-wave-square text-warning me-3"></i>
                            <div>
                                <div class="fw-semibold">Flutterwave</div>
                                <small class="text-muted">Secure African payments</small>
                            </div>
                            <i class="fas fa-chevron-right ms-auto text-muted"></i>
                        </a>
                    @endif

                    @if(setting('paystack_payment', 0))
                        <a href="{{ route('wallet.deposit.paystack') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                            <i class="fas fa-layer-group text-success me-3"></i>
                            <div>
                                <div class="fw-semibold">Paystack</div>
                                <small class="text-muted">Card, bank, USSD and more</small>
                            </div>
                            <i class="fas fa-chevron-right ms-auto text-muted"></i>
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Deposit History Modal -->
<div class="modal fade" id="depositHistoryModal" tabindex="-1" aria-labelledby="depositHistoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="depositHistoryModalLabel">Deposit History</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="depositHistoryContent">
                    <div class="text-center p-4">
                        <div class="spinner-border" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Load Deposit History
function loadDepositHistory() {
    const modal = new bootstrap.Modal(document.getElementById('depositHistoryModal'));
    modal.show();
    
    fetch('{{ route("wallet.deposit.history") }}')
    .then(response => response.json())
    .then(data => {
        let content = '<div class="table-responsive mt-3"><table class="table table-striped"><thead><tr><th>Date</th><th>Method</th><th>Amount</th><th>Status</th><th>Transaction ID</th></tr></thead><tbody>';
        
        if (data.status === 200 && data.data.length > 0) {
            data.data.forEach(deposit => {
                content += `<tr>
                    <td>${new Date(deposit.created_at).toLocaleDateString()}</td>
                    <td>${deposit.withdraw_method || 'N/A'}</td>
                    <td class="text-success">+$${parseFloat(deposit.amount).toFixed(2)}</td>
                    <td><span class="badge bg-${deposit.deposit_status === 'success' ? 'success' : 'warning'}">${deposit.deposit_status}</span></td>
                    <td>${deposit.transaction_id}</td>
                </tr>`;
            });
        } else {
            content += '<tr><td colspan="5" class="text-center">No deposits found</td></tr>';
        }
        
        content += '</tbody></table></div>';
        document.getElementById('depositHistoryContent').innerHTML = content;
    });
}
</script>
@endsection