@extends('front_end.layouts.home')

@section('title', 'Transaction History')

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-lg-12 mb-4">
            <h1 class="h3 text-gray-800">Transaction History</h1>
            <p class="text-muted">View all your wallet transactions</p>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Transactions</h6>
            
            <form class="form-inline" action="{{ route('wallet.transactions') }}" method="GET">
                <div class="form-group mr-2">
                    <select name="type" class="form-control form-control-sm">
                        <option value="">All Types</option>
                        <option value="credit" {{ request('type') == 'credit' ? 'selected' : '' }}>Credit</option>
                        <option value="debit" {{ request('type') == 'debit' ? 'selected' : '' }}>Debit</option>
                        <option value="pending" {{ request('type') == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="completed" {{ request('type') == 'completed' ? 'selected' : '' }}>Completed</option>
                    </select>
                </div>
                <div class="form-group mr-2">
                    <input type="date" name="from_date" class="form-control form-control-sm" value="{{ request('from_date') }}" placeholder="From Date">
                </div>
                <div class="form-group mr-2">
                    <input type="date" name="to_date" class="form-control form-control-sm" value="{{ request('to_date') }}" placeholder="To Date">
                </div>
                <button type="submit" class="btn btn-sm btn-primary">Filter</button>
                <a href="{{ route('wallet.transactions') }}" class="btn btn-sm btn-secondary ml-2">Reset</a>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Date & Time</th>
                            <th>Description</th>
                            <th>Reference</th>
                            <th>Type</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                            <tr>
                                <td>{{ $transaction->created_at->format('M d, Y H:i') }}</td>
                                <td>{{ $transaction->description }}</td>
                                <td>
                                    @if($transaction->reference_type)
                                        <small class="text-muted">
                                            {{ ucfirst(str_replace('_', ' ', $transaction->reference_type)) }}
                                            @if($transaction->reference_id)
                                                #{{ $transaction->reference_id }}
                                            @endif
                                        </small>
                                    @else
                                        <small>-</small>
                                    @endif
                                </td>
                                <td>
                                    @if($transaction->type == 'credit')
                                        <span class="badge bg-success">Credit</span>
                                    @elseif($transaction->type == 'debit')
                                        <span class="badge bg-danger">Debit</span>
                                    @elseif($transaction->type == 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @else
                                        <span class="badge bg-info">{{ ucfirst($transaction->type) }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($transaction->type == 'credit' || $transaction->type == 'completed')
                                        <span class="text-success">+${{ number_format($transaction->amount, 2) }}</span>
                                    @elseif($transaction->type == 'debit')
                                        <span class="text-danger">-${{ number_format($transaction->amount, 2) }}</span>
                                    @else
                                        <span class="text-warning">${{ number_format($transaction->amount, 2) }}</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">No transactions found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $transactions->appends(request()->except('page'))->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection 