<?php


use App\Http\Middleware\CacheSystem;
use UniSharp\LaravelFilemanager\Lfm;
use Illuminate\Support\Facades\Route;
use App\Http\Middleware\DeveloperMode;
use App\Http\Controllers\GifController;
use App\Http\Controllers\JobController;
use App\Http\Controllers\WebController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\GameController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PokeController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\MovieController;
use App\Http\Controllers\StoryController;
use App\Http\Controllers\Api\AiController;
use App\Http\Controllers\FriendController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\LanguageController;

use App\Http\Controllers\SettingsController;
use App\Http\Controllers\MessengerController;
use App\Http\Controllers\HelpCenterController;
use App\Http\Controllers\UserWalletController;
use App\Http\Controllers\MarketplaceController;
use App\Http\Controllers\NotificationController;

use App\Http\Controllers\Courses\AdminController;
use App\Http\Controllers\Courses\CourseController;
use App\Http\Controllers\Backend\BackendController;
use App\Http\Controllers\Courses\StudentController;
use App\Http\Controllers\PublicMarketplaceController;
use App\Http\Controllers\Courses\InstructorController;
use App\Http\Controllers\BloodBank\BloodBankController;
use App\Http\Controllers\BloodBank\PublicBloodBankController;




/*
*
* Auth Routes
*
* --------------------------------------------------------------------
*/

require __DIR__ . '/auth.php';
require __DIR__ . '/admin.php';

/*
*
* Frontend Routes
*
* --------------------------------------------------------------------
*/
Route::get('login', [AuthController::class, 'showLogin'])->name('login');
Route::post('login', [AuthController::class, 'webLogin'])->name('login');
Route::get('/logout', [WebController::class, 'logout'])->name('logout');
Route::middleware([DeveloperMode::class, CacheSystem::class])->group(function () {
    Route::middleware(['auth'])->group(function () {
        // Profile completion routes
        Route::get('/complete-profile', [WebController::class, 'completeProfile'])->name('complete.profile');
        Route::post('/complete-profile', [WebController::class, 'saveProfileCompletion'])->name('profile.complete');
        Route::get('/skip-profile-completion', [WebController::class, 'skipProfileCompletion'])->name('skip.profile.completion');
    });
    Route::get('/',  [WebController::class, 'newsfeed'])->name('index');

    // User Profile Routes
    Route::get('/profile', [UserController::class, 'myProfile'])->name('profile')->middleware('auth');
    Route::get('/profile/{id}', [UserController::class, 'userDetailById'])
        ->whereNumber('id')
        ->name('profile.detail');
    Route::get('/user/{username}', [UserController::class, 'userDetail'])->name('user.detail');

    Route::get('forgot-password', [AuthController::class, 'showForgot'])->name('forgot-password');
    Route::get('newsfeed', [WebController::class, 'newsfeed'])->name('newsfeed');
    Route::get('create_story', [WebController::class, 'create_story'])->name('create_story');
    Route::get('friends', [WebController::class, 'friends'])->name('friends');

    // Page detail route (outside module check so it's always accessible)
    Route::get('page/{slug}', [WebController::class, 'detail_page'])->name('detail_page');
    
    // Pages routes with module status check
    Route::middleware(['moduleStatus:pages'])->group(function () {
        Route::get('pages', [WebController::class, 'pages'])->name('pages');
        Route::get('pages/create', [WebController::class, 'create_page'])->name('pages.create');
        Route::get('my-pages', [WebController::class, 'my_pages'])->name('my_pages')->middleware('auth');
        // Require auth to ensure API calls under /webapi succeed immediately
        Route::get('liked-pages', [WebController::class, 'liked_pages'])->name('liked_pages')->middleware('auth');
    });


    Route::get('groups', [WebController::class, 'groups'])->name('groups');
    Route::get('group/create', [WebController::class, 'create_group'])->name('create_group');
    Route::get('group/{slug}', [WebController::class, 'details'])->name('group_detail');
    Route::get('my-groups', [WebController::class, 'my_groups'])->name('my_groups');
    Route::get('liked-groups', [WebController::class, 'liked_groups'])->name('liked_groups');

    // Old events routes
    // Route::get('events', [WebController::class, 'events'])->name('events');
    // Route::get('my-events', [WebController::class, 'my_events'])->name('my_events');
    // Route::get('events/create', [WebController::class, 'create_event'])->name('create_event');

    // New enhanced events routes
    Route::prefix('events')->group(function () {
        Route::get('/', [App\Http\Controllers\Web\EventController::class, 'index'])->name('events.index');
        Route::get('/create', [App\Http\Controllers\Web\EventController::class, 'create'])->name('events.create');
        Route::post('/store', [App\Http\Controllers\Web\EventController::class, 'store'])->name('events.store');
        Route::get('/my-events', [App\Http\Controllers\Web\EventController::class, 'myEvents'])->name('events.my');
        Route::get('/attending', [App\Http\Controllers\Web\EventController::class, 'attending'])->name('events.attending');
        Route::get('/interested', [App\Http\Controllers\Web\EventController::class, 'interested'])->name('events.interested');
        Route::get('/category/{category}', [App\Http\Controllers\Web\EventController::class, 'byCategory'])->name('events.category');
        Route::get('/{slug}', [App\Http\Controllers\Web\EventController::class, 'show'])->name('events.show');
        Route::get('/{slug}/edit', [App\Http\Controllers\Web\EventController::class, 'edit'])->name('events.edit');
        Route::put('/{slug}', [App\Http\Controllers\Web\EventController::class, 'update'])->name('events.update');
        Route::delete('/{slug}', [App\Http\Controllers\Web\EventController::class, 'destroy'])->name('events.delete');
    });

    Route::middleware(['moduleStatus:wallet'])->prefix('wallet')->group(function () {
        Route::get('/', [UserController::class, 'wallet'])->name('wallet');
        Route::get('/deposit', [UserController::class, 'deposit'])->name('deposit');
        Route::post('/add_balance', [UserController::class, 'addBalance'])->name('add_balance');
        Route::get('/stripe/success', [UserController::class, 'stripeSuccess'])->name('stripe.success');
        Route::get('/stripe/cancel', [UserController::class, 'stripeCancel'])->name('stripe.cancel');
        Route::get('/deposit-list', [UserController::class, 'depositList'])->name('depositlist');
        Route::get('/withdraw', [UserController::class, 'withdraw'])->name('withdraw');
        Route::post('/withdraw/request', [UserController::class, 'withdrawRequest'])->name('withdraw.request');
        Route::get('/withdraw-list', [UserController::class, 'withdraw_list'])->name('withdraw_list');
        Route::get('/transfer-amount', [UserController::class, 'transferAmount'])->name('transferAmount');
        Route::post('/process-transfer', [UserController::class, 'processTransfer'])->name('processTransfer');
        Route::get('/get_users', [UserController::class, 'get_users'])->name('getusers');

        // New provider-specific deposit routes (front-end modal)
        Route::get('/deposit/stripe', [UserWalletController::class, 'stripeDeposit'])->name('wallet.deposit.stripe');
        Route::post('/deposit/stripe/create', [UserWalletController::class, 'stripeCreateCheckout'])->name('wallet.deposit.stripe.create');
        Route::get('/deposit/stripe/success', [UserWalletController::class, 'stripeSuccess'])->name('wallet.deposit.stripe.success');
        Route::get('/deposit/stripe/cancel', [UserWalletController::class, 'stripeCancel'])->name('wallet.deposit.stripe.cancel');

        Route::get('/deposit/paypal', [UserWalletController::class, 'paypalDeposit'])->name('wallet.deposit.paypal');
        Route::post('/deposit/paypal/create', [UserWalletController::class, 'paypalCreateCheckout'])->name('wallet.deposit.paypal.create');
        Route::get('/deposit/paypal/success', [UserWalletController::class, 'paypalSuccess'])->name('wallet.deposit.paypal.success');
        Route::get('/deposit/paypal/cancel', [UserWalletController::class, 'paypalCancel'])->name('wallet.deposit.paypal.cancel');
        Route::get('/deposit/paypal/test', [UserWalletController::class, 'paypalTestCredentials'])->name('wallet.deposit.paypal.test');

        Route::get('/deposit/flutterwave', [UserWalletController::class, 'flutterwaveDeposit'])->name('wallet.deposit.flutterwave');
        Route::post('/deposit/flutterwave/create', [UserWalletController::class, 'flutterwaveCreateCheckout'])->name('wallet.deposit.flutterwave.create');
        Route::get('/deposit/flutterwave/callback', [UserWalletController::class, 'flutterwaveCallback'])->name('wallet.deposit.flutterwave.callback');

        Route::get('/deposit/paystack', [UserWalletController::class, 'paystackDeposit'])->name('wallet.deposit.paystack');
        Route::post('/deposit/paystack/create', [UserWalletController::class, 'paystackCreateCheckout'])->name('wallet.deposit.paystack.create');
        Route::get('/deposit/paystack/callback', [UserWalletController::class, 'paystackCallback'])->name('wallet.deposit.paystack.callback');

        // Transfer and Withdraw routes using AJAX/API methods
        Route::post('/transfer-amount', [UserWalletController::class, 'transferAmount'])->name('wallet.transfer.amount');
        Route::post('/create-withdraw-request', [UserWalletController::class, 'createWithdrawRequest'])->name('wallet.create.withdraw.request');

        // History routes (API endpoints)
        Route::get('/withdraw-history', [UserWalletController::class, 'withdrawHistory'])->name('wallet.withdraw.history');
        Route::get('/transaction-history', [UserWalletController::class, 'transactionHistory'])->name('wallet.transaction.history');
        Route::get('/deposit-history', [UserWalletController::class, 'depositHistory'])->name('wallet.deposit.history');

        // History view routes
        Route::get('/transactions', function () {
            return view('front_end.pages.wallet.transactions');
        })->name('wallet.transactions');
        Route::get('/withdrawals', function () {
            return view('front_end.pages.wallet.withdrawals');
        })->name('wallet.withdrawals');
    });
    Route::get('marketplace', [WebController::class, 'marketplace'])->name('marketplace')->middleware(['moduleStatus:product']);

    // Jobs routes with module status check
    Route::middleware(['moduleStatus:job_system'])->group(function () {
        Route::get('jobs', [WebController::class, 'jobs'])->name('jobs');
        Route::get('jobs/discover', [WebController::class, 'jobs_discover'])->name('jobs.discover');
        Route::get('jobs/create', [WebController::class, 'jobs_create'])->name('jobs.create');
        Route::get('jobs/detail/{id}', [WebController::class, 'jobs_detail'])->name('jobs.detail');
        Route::get('jobs/applied', [WebController::class, 'jobs_applied'])->name('jobs.applied');
        Route::get('jobs/edit', [WebController::class, 'jobs'])->name('jobs.edit');
        Route::get('jobs/applicants', [WebController::class, 'jobs'])->name('jobs.applicants');
        Route::get('jobs/applicants/detail', [WebController::class, 'jobs'])->name('jobs.applicants.detail');
    });



    // User Settings Routes
    Route::middleware(['auth'])->group(function () {
        // Account Settings
        Route::get('/settings/account', [SettingsController::class, 'accountSettings'])->name('settings.account');
        Route::post('/settings/account/update', [SettingsController::class, 'accountSettingsUpdate'])->name('settings.account.update');
        Route::post('/settings/account/deactivate', [SettingsController::class, 'accountDeactivate'])->name('settings.account.deactivate');
        Route::post('/settings/account/update-picture', [SettingsController::class, 'updateProfilePicture'])->name('settings.account.update_picture');

        // Profile Settings
        Route::get('/settings/profile', [SettingsController::class, 'profileSettings'])->name('settings.profile');
        Route::post('/settings/profile/update', [SettingsController::class, 'profileSettingsUpdate'])->name('settings.profile.update');

        // Security Settings
        Route::get('/settings/security', [SettingsController::class, 'securitySettings'])->name('settings.security');
        Route::post('/settings/security/update', [SettingsController::class, 'securitySettingsUpdate'])->name('settings.security.update');
        Route::post('/settings/security/revoke-session', [SettingsController::class, 'revokeSession'])->name('settings.security.revoke_session');
        Route::post('/settings/security/revoke-all-sessions', [SettingsController::class, 'revokeAllSessions'])->name('settings.security.revoke_all_sessions');
        Route::post('/settings/security/enable-2fa', [SettingsController::class, 'enable2fa'])->name('settings.security.enable_2fa');
        Route::post('/settings/security/disable-2fa', [SettingsController::class, 'disable2fa'])->name('settings.security.disable_2fa');
        Route::get('/settings/security/recovery-codes', [SettingsController::class, 'recoveryCode'])->name('settings.security.recovery_codes');

        // Other Settings
        Route::get('/settings/notifications', [SettingsController::class, 'notificationSettings'])->name('settings.notifications');
        Route::post('/settings/notifications/update', [SettingsController::class, 'notificationSettingsUpdate'])->name('settings.notifications.update');
        Route::get('/settings/privacy', [SettingsController::class, 'privacySettings'])->name('settings.privacy');
        Route::post('/settings/privacy/update', [SettingsController::class, 'privacySettingsUpdate'])->name('settings.privacy.update');

        // Verification Settings
        Route::get('/settings/verification', [SettingsController::class, 'verificationSettings'])->name('settings.verification');
        Route::post('/settings/verification/submit', [SettingsController::class, 'submitVerification'])->name('settings.verification.submit');
        Route::post('/settings/verification/reapply', [SettingsController::class, 'reapplyVerification'])->name('settings.verification.reapply');

        Route::get('/settings/blocking', [SettingsController::class, 'blockingSettings'])->name('settings.blocking');
        Route::post('/settings/blocking/block', [SettingsController::class, 'blockUser'])->name('settings.blocking.block');
        Route::post('/settings/blocking/unblock/{blockedUserId}', [SettingsController::class, 'unblockUser'])->name('settings.blocking.unblock');
        Route::get('/settings/delete-account', [SettingsController::class, 'deleteAccount'])->name('settings.delete_account');
        Route::post('/settings/delete-account', [SettingsController::class, 'deleteAccountSettings'])->name('settings.account.delete');
    });

    // web.php
    Route::middleware(['moduleStatus:blood'])->prefix('bloodbank')->group(function () {
        // Public routes
        Route::get('/', [PublicBloodBankController::class, 'index'])->name('bloodbank.index');
        Route::get('/requests', [PublicBloodBankController::class, 'requests'])->name('bloodbank.requests');
        Route::get('/requests/{id}', [PublicBloodBankController::class, 'requestDetail'])->name('bloodbank.requests.show');
        Route::get('/drives', [PublicBloodBankController::class, 'drives'])->name('bloodbank.drives');
        Route::get('/drives/{id}', [PublicBloodBankController::class, 'driveDetail'])->name('bloodbank.drives.show');

        // Auth required routes
        Route::middleware('auth')->group(function () {
            Route::get('/donate', [PublicBloodBankController::class, 'donate'])->name('bloodbank.donate');
            Route::get('/request', [PublicBloodBankController::class, 'request'])->name('bloodbank.request');
            Route::get('/profile', [PublicBloodBankController::class, 'profile'])->name('bloodbank.profile');
            Route::get('/donors', [PublicBloodBankController::class, 'donors'])->name('bloodbank.donors');
        });
    });

    // api.php
    Route::prefix('webapi/bloodbank')->group(function () {
        // Public API routes
        Route::get('dashboard-stats', [BloodBankController::class, 'getDashboardStats']);
        Route::get('inventory', [BloodBankController::class, 'getBloodInventory']);
        Route::get('requests', [BloodBankController::class, 'getBloodRequests']);
        Route::get('drives', [BloodBankController::class, 'getBloodDrives']);

        // Auth required API routes
        Route::middleware('auth:sanctum')->group(function () {
            // Blood requests
            Route::post('requests', [BloodBankController::class, 'createBloodRequest']);
            Route::get('requests/{id}', [BloodBankController::class, 'getBloodRequestDetail']);
            Route::post('requests/{id}/respond', [BloodBankController::class, 'respondToRequest']);
            Route::post('requests/{id}/cancel', [BloodBankController::class, 'cancelRequest']);

            // Donations
            Route::post('donations/schedule', [BloodBankController::class, 'scheduleDonation']);
            Route::get('donations', [BloodBankController::class, 'getUserDonations']);
            Route::post('donations/{id}/cancel', [BloodBankController::class, 'cancelDonation']);

            // Blood drives
            Route::get('drives/registrations', [BloodBankController::class, 'getUserDriveRegistrations']);
            Route::post('drives/{id}/register', [BloodBankController::class, 'registerForDrive']);
            Route::post('drives/{id}/cancel-registration', [BloodBankController::class, 'cancelDriveRegistration']);

            // Donors
            Route::get('donors/nearby', [BloodBankController::class, 'getNearbyDonors']);
            Route::put('donors/profile', [BloodBankController::class, 'updateDonorProfile']);
        });
    });





    /*
|--------------------------------------------------------------------------
| Course Routes
|--------------------------------------------------------------------------
*/

    // Public routes
    Route::prefix('courses')
        ->middleware('moduleStatus:courses')
        ->group(function () {
            // Browse courses
            Route::get('/', [CourseController::class, 'index'])->name('courses.index');
            Route::get('/category/{slug}', [CourseController::class, 'category'])->name('courses.category');
            Route::get('/search', [CourseController::class, 'search'])->name('courses.search');
            Route::get('/{slug}', [CourseController::class, 'show'])->name('courses.show');

            // Course enrollment and checkout (requires auth)
            Route::middleware('auth')->group(function () {
                Route::get('/{slug}/enroll', [CourseController::class, 'enroll'])->name('courses.enroll');
                Route::get('/{slug}/checkout', [CourseController::class, 'checkout'])->name('courses.checkout');
                Route::post('/{slug}/apply-coupon', [CourseController::class, 'applyCoupon'])->name('courses.apply-coupon');
                Route::post('/{slug}/process-payment', [CourseController::class, 'processPayment'])->name('courses.processPayment');
                Route::post('/{slug}/toggle-wishlist', [CourseController::class, 'toggleWishlist'])->name('courses.toggleWishlist');
                Route::get('/{slug}/toggle-wishlist', [CourseController::class, 'toggleWishlist'])->name('courses.toggleWishlist');

                // Course learning
                Route::get('/{slug}/learn/{lessonId?}', [CourseController::class, 'learn'])->name('courses.learn');
                Route::post('/{slug}/complete-lesson/{lessonId}', [CourseController::class, 'completeLesson'])->name('courses.complete-lesson');
                Route::post('/{slug}/ask-question/{lessonId}', [CourseController::class, 'askQuestion'])->name('courses.ask-question');
                Route::post('/answer-question/{questionId}', [CourseController::class, 'answerQuestion'])->name('courses.answer-question');
                Route::post('/mark-best-answer/{answerId}', [CourseController::class, 'markBestAnswer'])->name('courses.mark-best-answer');
                Route::post('/{slug}/submit-review', [CourseController::class, 'submitReview'])->name('courses.submit-review');
            });
        });

    // Student routes
    Route::group(['prefix' => 'student', 'middleware' => ['auth']], function () {
        Route::get('/dashboard', [StudentController::class, 'dashboard'])->name('student.dashboard');
        Route::get('/my-courses', [StudentController::class, 'myCourses'])->name('student.myCourses');
        Route::get('/wishlist', [StudentController::class, 'wishlist'])->name('student.wishlist');
        Route::get('/purchase-history', [StudentController::class, 'purchaseHistory'])->name('student.purchaseHistory');
        Route::delete('/wishlist/{id}', [StudentController::class, 'removeFromWishlist'])->name('student.removeFromWishlist');
    });

    // Instructor routes
    Route::group(['prefix' => 'instructor', 'middleware' => ['auth']], function () {
        Route::get('/dashboard', [InstructorController::class, 'dashboard'])->name('instructor.dashboard');

        // Course management
        Route::get('/courses', [InstructorController::class, 'courses'])->name('instructor.courses');
        Route::get('/courses/create', [InstructorController::class, 'createCourse'])->name('instructor.courses.create');
        Route::post('/courses', [InstructorController::class, 'storeCourse'])->name('instructor.courses.store');
        Route::get('/courses/{id}/edit', [InstructorController::class, 'editCourse'])->name('instructor.courses.edit');
        Route::put('/courses/{id}', [InstructorController::class, 'updateCourse'])->name('instructor.courses.update');
        Route::post('/courses/{id}/toggle-publish', [InstructorController::class, 'togglePublish'])->name('instructor.courses.togglePublish');

        // Sections
        Route::post('/courses/{courseId}/sections', [InstructorController::class, 'addSection'])->name('instructor.courses.addSection');
        Route::put('/sections/{sectionId}', [InstructorController::class, 'updateSection'])->name('instructor.courses.updateSection');
        Route::delete('/sections/{sectionId}', [InstructorController::class, 'deleteSection'])->name('instructor.courses.deleteSection');
        Route::post('/courses/{courseId}/reorder-sections', [InstructorController::class, 'reorderSections'])->name('instructor.courses.reorderSections');

        // Lessons
        Route::get('/courses/{courseId}/sections/{sectionId}/lessons/create', [InstructorController::class, 'createLesson'])->name('instructor.courses.createLesson');
        Route::post('/courses/{courseId}/sections/{sectionId}/lessons', [InstructorController::class, 'storeLesson'])->name('instructor.courses.storeLesson');
        Route::get('/courses/{courseId}/lessons/{lessonId}/edit', [InstructorController::class, 'editLesson'])->name('instructor.courses.editLesson');
        Route::put('/courses/{courseId}/lessons/{lessonId}', [InstructorController::class, 'updateLesson'])->name('instructor.courses.updateLesson');
        Route::delete('/courses/{courseId}/lessons/{lessonId}', [InstructorController::class, 'deleteLesson'])->name('instructor.courses.deleteLesson');
        Route::post('/sections/{sectionId}/reorder-lessons', [InstructorController::class, 'reorderLessons'])->name('instructor.courses.reorderLessons');

        // Course components
        Route::get('/courses/{courseId}/announcements', [InstructorController::class, 'announcements'])->name('instructor.courses.announcements');
        Route::post('/courses/{courseId}/announcements', [InstructorController::class, 'addAnnouncement'])->name('instructor.courses.announcements.add');
        Route::delete('/announcements/{id}', [InstructorController::class, 'deleteAnnouncement'])->name('instructor.courses.announcements.delete');

        Route::get('/courses/{courseId}/reviews', [InstructorController::class, 'reviews'])->name('instructor.courses.reviews');
        Route::get('/courses/{courseId}/questions', [InstructorController::class, 'questions'])->name('instructor.courses.questions');
        Route::get('/courses/{courseId}/students', [InstructorController::class, 'students'])->name('instructor.courses.students');

        // Coupons
        Route::get('/courses/{courseId}/coupons', [InstructorController::class, 'coupons'])->name('instructor.courses.coupons');
        Route::post('/courses/{courseId}/coupons', [InstructorController::class, 'addCoupon'])->name('instructor.courses.addCoupon');
        Route::post('/coupons/{id}/toggle', [InstructorController::class, 'toggleCoupon'])->name('instructor.courses.coupons.toggle');
        Route::delete('/coupons/{id}', [InstructorController::class, 'deleteCoupon'])->name('instructor.courses.coupons.delete');
    });

    // Admin routes for courses - MOVED TO routes/admin.php
    // These routes are now handled by Backend\CourseController in routes/admin.php
    // Keeping reviews routes here if they're not in admin.php yet
    Route::group(['prefix' => 'admin/courses', 'middleware' => ['auth', 'admin']], function () {
        // Reviews routes - can be moved to admin.php if needed
        Route::get('/reviews', [AdminController::class, 'reviews'])->name('admin.courses.reviews');
        Route::post('/reviews/{id}/toggle', [AdminController::class, 'toggleReview'])->name('admin.courses.reviews.toggle');
        Route::delete('/reviews/{id}', [AdminController::class, 'deleteReview'])->name('admin.courses.reviews.delete');
    });


    // routes/web.php
    Route::middleware(['moduleStatus:product'])->prefix('marketplace')->group(function () {
        // Public routes
        Route::get('/', [PublicMarketplaceController::class, 'index'])->name('marketplace.index');
        Route::get('/products/{id}', [PublicMarketplaceController::class, 'show'])->name('marketplace.show');

        // Auth required routes

        Route::get('/create', [PublicMarketplaceController::class, 'create'])->name('marketplace.create');
        Route::get('/saved', [PublicMarketplaceController::class, 'savedProducts'])->name('marketplace.saved');
        Route::get('/my-listings', [PublicMarketplaceController::class, 'myListings'])->name('marketplace.my-listings');
    });


    Route::middleware(['auth'])->group(function () {
        Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
        Route::post('/notifications/mark-seen/{id}', [NotificationController::class, 'markAsSeen'])->name('notifications.markAsSeen');
        Route::post('/notifications/mark-all-seen', [NotificationController::class, 'markAllAsSeen'])->name('notifications.markAllAsSeen');
        Route::get('/notifications/unread-count', [NotificationController::class, 'getUnreadCount'])->name('notifications.getUnreadCount');
        Route::get('/notifications/new', [NotificationController::class, 'getNewNotifications'])->name('notifications.getNew');
        Route::post('/notifications/mark-all-read', [NotificationController::class, 'markAllAsReadAjax'])->name('notifications.markAllReadAjax');
        Route::post('/notifications/react/{id}', [NotificationController::class, 'react'])->name('notifications.react');
        Route::delete('/notifications/{id}', [NotificationController::class, 'delete'])->name('notifications.delete');
    });

    // // Admin notification routes
    // Route::middleware(['auth', 'admin'])->prefix('admin')->group(function () {
    //     Route::get('/notifications', [AdminNotificationController::class, 'index'])->name('admin.notifications.index');
    //     Route::get('/notifications/list', [AdminNotificationController::class, 'list'])->name('admin.notifications.list');
    //     Route::post('/notifications/system', [AdminNotificationController::class, 'sendSystem'])->name('admin.notifications.sendSystem');
    //     Route::post('/notifications/announcement', [AdminNotificationController::class, 'sendAnnouncement'])->name('admin.notifications.sendAnnouncement');
    //     Route::delete('/notifications/{id}', [AdminNotificationController::class, 'delete'])->name('admin.notifications.delete');
    // });

    // API route for sending notifications
    Route::middleware(['auth:api'])->group(function () {
        Route::post('/api/notifications/send', [NotificationController::class, 'send'])->name('api.notifications.send');
    });



    // Public Routes for Movies
    Route::middleware(['moduleStatus:movies'])->prefix('movies')->name('movies.')->group(function () {
        // Movie Homepage
        Route::get('/', [MovieController::class, 'index'])->name('index');

        // Movie Details Page
        Route::get('/show/{slug}', [MovieController::class, 'show'])->name('show');

        // Movie Watch Page
        Route::get('/watch/{slug}', [MovieController::class, 'watch'])->name('watch');

        // Movies by Genre
        Route::get('/genre/{slug}', [MovieController::class, 'byGenre'])->name('genre');

        // Movie Rating (protected by auth middleware)
        Route::post('/rate/{movie}', [MovieController::class, 'rate'])
            ->middleware('auth')
            ->name('rate');
    });
    // Search Movies
    Route::get('/search/movies', [MovieController::class, 'search'])->name('search.movies');



    // Public Routes for Games
    Route::prefix('games')
        ->middleware('moduleStatus:games')
        ->name('games.')->group(function () {
            // Games Homepage
            Route::get('/', [GameController::class, 'index'])->name('index');

            // Game Details Page
            Route::get('/show/{slug}', [GameController::class, 'show'])->name('show');

            // Game Play Page
            Route::get('/play/{slug}', [GameController::class, 'play'])->name('play');

            // Games by Category
            Route::get('/category/{slug}', [GameController::class, 'byCategory'])->name('category');

            // Game Rating (protected by auth middleware)
            Route::post('/rate/{game}', [GameController::class, 'rate'])
                ->middleware('auth')
                ->name('rate');
        });

    // Search Games
    Route::get('/search/games', [GameController::class, 'search'])->name('search.games');

    // User Game History and Favorites (protected by auth middleware)
    Route::middleware(['auth'])->group(function () {
        // Play History
        //Route::get('/games-history', [UserGameController::class, 'gameHistory'])->name('games.history');

        // Favorites
        Route::get('/games/favorites', [GameController::class, 'favorites'])->name('games.favorites');
    });


    // User poke routes
    Route::middleware(['auth'])->group(function () {
        Route::get('/pokes', [PokeController::class, 'dashboard'])->name('pokes.dashboard');
        Route::get('/pokes/received', [PokeController::class, 'received'])->name('pokes.received');
        Route::get('/pokes/sent', [PokeController::class, 'sent'])->name('pokes.sent');
        Route::post('/pokes/send/{userId}', [PokeController::class, 'send'])->name('pokes.send');
        Route::post('/pokes/mark-read/{id}', [PokeController::class, 'markAsRead'])->name('pokes.markAsRead');
        Route::post('/pokes/mark-all-read', [PokeController::class, 'markAllAsRead'])->name('pokes.markAllAsRead');
        Route::post('/pokes/poke-back/{id}', [PokeController::class, 'pokeBack'])->name('pokes.pokeBack');
    });

    // // Admin poke routes
    // Route::middleware(['auth', 'admin'])->prefix('admin')->group(function () {
    //     Route::get('/pokes', [AdminPokeController::class, 'index'])->name('admin.pokes.index');
    //     Route::get('/pokes/list', [AdminPokeController::class, 'list'])->name('admin.pokes.list');
    //     Route::delete('/pokes/{id}', [AdminPokeController::class, 'delete'])->name('admin.pokes.delete');
    // });

    // routes/api.php
    Route::prefix('webapi/marketplace')->group(function () {
        // Public API routes
        Route::get('dashboard-stats', [MarketplaceController::class, 'getDashboardStats']);
        Route::get('categories', [MarketplaceController::class, 'getCategories']);
        Route::post('products', [MarketplaceController::class, 'getProducts']);
        Route::get('products/{id}', [MarketplaceController::class, 'getProductDetail']);
        Route::get('recommended', [MarketplaceController::class, 'getRecommendedProducts']);
        Route::get('popular-sellers', [MarketplaceController::class, 'getPopularSellers']);

        // Auth required API routes
        Route::middleware('auth:sanctum')->group(function () {
            // Product management
            Route::post('products/create', [MarketplaceController::class, 'addProduct']);
            Route::post('products/{id}/update', [MarketplaceController::class, 'updateProduct']);
            Route::delete('products/{id}', [MarketplaceController::class, 'deleteProduct']);
            Route::post('products/{id}/toggle-status', [MarketplaceController::class, 'toggleProductStatus']);
            Route::post('products/{id}/mark-sold', [MarketplaceController::class, 'markProductSold']);

            // Image management
            Route::post('products/{id}/images', [MarketplaceController::class, 'addProductImages']);
            Route::delete('products/images/{id}', [MarketplaceController::class, 'deleteProductImage']);
            Route::post('products/images/reorder', [MarketplaceController::class, 'reorderProductImages']);

            // Saved products
            Route::post('products/{id}/toggle-save', [MarketplaceController::class, 'toggleSaveProduct']);
            Route::get('saved-products', [MarketplaceController::class, 'getSavedProducts']);

            // My listings
            Route::get('my-listings', [MarketplaceController::class, 'getMyListings']);
            Route::get('my-listings/stats', [MarketplaceController::class, 'getMyListingsStats']);

            // Messages
            Route::post('products/{id}/contact-seller', [MarketplaceController::class, 'contactSeller']);
            Route::get('conversations', [MarketplaceController::class, 'getConversations']);
            Route::get('conversations/{id}/messages', [MarketplaceController::class, 'getMessages']);
            Route::post('conversations/{id}/messages', [MarketplaceController::class, 'sendMessage']);

            // Reports
            Route::post('products/{id}/report', [MarketplaceController::class, 'reportProduct']);
            Route::post('sellers/{id}/report', [MarketplaceController::class, 'reportSeller']);
        });
    });
    Route::prefix('webapi/messenger')->group(function () {
        Route::get('/conversations', [MessengerController::class, 'getConversations']);
        Route::post('/conversations', [MessengerController::class, 'createConversation']);
        Route::get('/conversations/{conversation}/messages', [MessengerController::class, 'getMessages']);
        Route::post('/conversations/{conversation}/messages', [MessengerController::class, 'sendMessage']);
        Route::get('/conversations/{conversation}/messages/{message}', [MessengerController::class, 'getMessage']);
        Route::put('/conversations/{conversation}/messages/{message}', [MessengerController::class, 'updateMessage']);
        Route::delete('/conversations/{conversation}/messages/{message}', [MessengerController::class, 'deleteMessage']);

        // Conversations with specific user
        Route::get('/conversations/with-user/{userId}', [MessengerController::class, 'getConversationsWithUser']);

        // Users
        Route::get('/users/search', [MessengerController::class, 'searchUsers']);

        // Typing indicators
        Route::post('/typing', [MessengerController::class, 'sendTyping']);

        // Message receipts
        Route::get('/receipts', [MessengerController::class, 'getReceipts']);
        Route::post('/receipts', [MessengerController::class, 'markAsRead']);

        // Real-time updates
        Route::get('/updates', [MessengerController::class, 'getUpdates']);
    });


    Route::middleware('auth')->prefix('webapi')->group(function () {

        // Custom routes for special features
        Route::prefix('marketplace')->middleware('auth:sanctum')->group(function () {
            // Featured listings
            Route::post('products/{id}/feature', [MarketplaceController::class, 'featureProduct']);

            // Promotions
            Route::post('products/{id}/promote', [MarketplaceController::class, 'promoteProduct']);
            Route::get('promotion-packages', [MarketplaceController::class, 'getPromotionPackages']);

            // Analytics
            Route::get('products/{id}/stats', [MarketplaceController::class, 'getProductStats']);
            Route::get('seller/{id}/stats', [MarketplaceController::class, 'getSellerStats']);

            // Bulk operations
            Route::post('products/bulk-delete', [MarketplaceController::class, 'bulkDeleteProducts']);
            Route::post('products/bulk-status', [MarketplaceController::class, 'bulkUpdateStatus']);
        });

        //Route::middleware(['moduleStatus:events'])->prefix('event')->group(function () {

        Route::prefix('event')->group(function () {
            // Create and manage events
            Route::post('add-event', [EventController::class, 'addEvent']);
            Route::post('update-event', [EventController::class, 'updateEvent']);
            Route::post('delete-event', [EventController::class, 'deleteEvent']);

            // Get event listings
            Route::post('get-events', [EventController::class, 'getEvents']);
            Route::get('detail/{slug}', [EventController::class, 'getEventDetail']);
            Route::get('detail_by_id/{id}', [EventController::class, 'getEventById']); // New route to get event by ID

            Route::get('by-category/{category}', [EventController::class, 'getEventsByCategory']);
            Route::get('upcoming', [EventController::class, 'getUpcomingEvents']);

            // Participation
            Route::post('show-interest', [EventController::class, 'createInterest']);
            Route::post('go-to-event', [EventController::class, 'gotoEvent']);
            Route::post('join-event', [EventController::class, 'joinEvent']);

            // Participant management
            Route::get('{event_id}/participants', [EventController::class, 'getEventParticipants']);
            Route::post('approve-participant', [EventController::class, 'approveParticipant']);
            Route::post('reject-participant', [EventController::class, 'rejectParticipant']);
        });

        // GIF providers proxy
        Route::prefix('gifs')->group(function () {
            Route::get('trending', [GifController::class, 'trending']);
            Route::get('search', [GifController::class, 'search']);
        });

        // AI generation
        Route::post('ai/generate-post', [AiController::class, 'generatePost']);
        Route::post('ai/generate-image', [AiController::class, 'generateImage']);


        // Group all post-related routes together
        Route::prefix('post')->group(function () {
            // Post CRUD operations
            Route::post('create', [PostController::class, 'add_post']);
            Route::post('save', [PostController::class, 'savePost']);
            Route::get('saved-posts', [PostController::class, 'getSavedPosts']);
            Route::post('delete-post', [PostController::class, 'deletePost']);
            Route::get('detail/{id}', [PostController::class, 'getPostDetail'])->where('id', '[0-9]+');
            Route::post('update/{id}', [PostController::class, 'updatePost'])->where('id', '[0-9]+');
            Route::post('newsfeed', [PostController::class, 'getNewsfeed']);

            Route::post('change-privacy', [PostController::class, 'changePostPrivacy']);

            //post actions
            Route::post('action', [PostController::class, 'postAction']);
            Route::post('post-reaction-detail', [PostController::class, 'getPostReactionsByType']);
            Route::post('post-actions-detail', [PostController::class, 'getPostActionsByType']);
            Route::post('comment-action', [PostController::class, 'postCommentAction']);


            // Feed and filtering
            Route::get('page_posts/{id}', [PostController::class, 'getPagePosts'])->where('id', '[0-9]+');
            Route::get('group_posts/{id}', [PostController::class, 'getGroupPosts'])->where('id', '[0-9]+');
        });
        Route::post('trending-hashtags', [PostController::class, 'trendingHashtags']);

        // Suggested users/people you may know
        Route::get('suggested-users', [FriendController::class, 'getSuggestedUsers']);

        // Suggested pages
        Route::get('suggested-pages', [PageController::class, 'getSuggestedPages']);

        // Suggested groups
        Route::get('suggested-groups', [GroupController::class, 'getSuggestedGroups']);

        // Suggested events
        Route::get('suggested-events', [EventController::class, 'getSuggestedEvents']);

        Route::prefix('profile')->group(function () {
            Route::post('update-notification-setting', [ProfileController::class, 'updateNotificatinSetting'])
                ->name('webapi.profile.update-notification-setting');
        });

        Route::prefix('stories')->group(function () {
            Route::post('/', [StoryController::class, 'createStory'])->name('stories.create');
            Route::get('/', [StoryController::class, 'getStories'])->name('stories.get');
            Route::post('/mute-unmute', [StoryController::class, 'muteUnmuteUser'])->name('stories.muteUnmute');
            Route::post('/seen', [StoryController::class, 'seenStory'])->name('stories.seen');
            Route::get('/seen-users/{id}', [StoryController::class, 'storySeenUser'])->name('stories.seenUsers');
            Route::delete('/{id}', [StoryController::class, 'deleteStory'])->name('stories.delete');
        });


        Route::prefix('friends')->group(function () {
            Route::get('/get-all', [FriendController::class, 'getFriends']);
            Route::get('/stats', [FriendController::class, 'getStats']);

            Route::get('/get-sent-requests', [FriendController::class, 'getSentFriendRequests']);
            Route::get('/get-received-requests', [FriendController::class, 'getReceivedFriendRequests']);

            Route::post('/send-request', [FriendController::class, 'sendFriendRequest']);
            Route::post('/request-action', [FriendController::class, 'friendRequestAction']);
            Route::post('/unfriend', [FriendController::class, 'unfriend']);
            Route::get('/recommendations', [FriendController::class, 'fetchRecommended']);
            Route::post('/change-role', [FriendController::class, 'changeFriendRole']);
            Route::get('/get-followers', [FriendController::class, 'getFollowers']);
        });

        Route::prefix('page')->group(function () {
            Route::get('get-all', [PageController::class, 'getAllPages']);
            Route::get('user-pages', [PageController::class, 'userPages']);
            Route::post('add-new', [PageController::class, 'addPage']);
            Route::post('like-unlike-page', [PageController::class, 'likeUnlikePage']);
            Route::get('get-liked-pages', [PageController::class, 'getLikedPages']);
            Route::post('get-page-data', [PageController::class, 'getPageData']);
            Route::post('delete-page', [PageController::class, 'deletePage']);
            Route::post('update-page', [PageController::class, 'updatePage']);
            Route::get('liked-users', [PageController::class, 'getUsersWhoLikedPage']);
            Route::get('stats', [PageController::class, 'getPageStats']);
            Route::post('check-page-existence', [PageController::class, 'checkPageExistence']);
            Route::post('user-pages', [PageController::class, 'myPages']);
        });

        Route::middleware(['moduleStatus:job_system'])->prefix('jobs')->group(function () {

            // Job management
            Route::get('detail/{id}', [JobController::class, 'getJobDetail']);
            Route::post('create', [JobController::class, 'createJob']);
            Route::post('update/{id}', [JobController::class, 'updateJob']);
            Route::delete('delete/{id}', [JobController::class, 'deleteJob']);
            Route::patch('toggle-status/{id}', [JobController::class, 'toggleJobStatus']);
            Route::patch('update-expiry/{id}', [JobController::class, 'updateJobExpiry']);


            // Public routes
            Route::get('dashboard-stats', [JobController::class, 'getDashboardStats']);
            Route::post('all', [JobController::class, 'getJobs']);
            Route::get('recommended', [JobController::class, 'getRecommendedJobs']);
            Route::get('categories', [JobController::class, 'getJobCategories']);
            Route::get('trending-keywords', [JobController::class, 'getTrendingKeywords']);

            Route::post('save', [JobController::class, 'saveJob']);
            Route::delete('unsave/{id}', [JobController::class, 'unsaveJob']);
            Route::get('saved', [JobController::class, 'getSavedJobs']);

            // Job statistics and analytics
            Route::get('stats/{id}', [JobController::class, 'getJobStats']);

            // Application management
            Route::post('apply', [JobController::class, 'applyJob']);
            Route::delete('withdraw-application/{id}', [JobController::class, 'withdrawApplication']);
            Route::get('my-applications', [JobController::class, 'getMyApplications']);
            Route::patch('application/{id}/status', [JobController::class, 'updateApplicationStatus']);

            // Candidate management
            Route::get('candidates/{id}', [JobController::class, 'appliedCandidates']);

            // Recommendations
            Route::get('recommended', [JobController::class, 'getRecommendedJobs']);

            // Search and filters
            Route::get('search', [JobController::class, 'searchJobs']);
            Route::get('filters', [JobController::class, 'getJobFilters']); // Get available filter options



        });

        Route::prefix('groups')->group(function () {
            Route::post('create', [GroupController::class, 'createGroup']);
            Route::get('all', [GroupController::class, 'getAllGroups']);
            Route::post('join', [GroupController::class, 'joinGroup']);
            Route::post('join-leave', [GroupController::class, 'joinLeaveGroup']);
            Route::post('invite-users', [GroupController::class, 'inviteUsers']);
            Route::post('add-members', [GroupController::class, 'addMembers']);
            Route::get('user-groups', [GroupController::class, 'getUserGroups']);
            Route::get('stats', [GroupController::class, 'getGroupStats']);
        });


        Route::prefix('events')->group(function () {
            Route::post('create', [EventController::class, 'addEvent'])->name('events.create');
            Route::get('all', [EventController::class, 'getEvents']);
            Route::post('join', [EventController::class, 'joinEvent']);
        });
    });

    Route::get('upgrade-to-pro', [UserWalletController::class, 'upgradeToProWeb'])->name('upgradetoproweb');






    // Language Switch
    Route::get('language/{language}', [LanguageController::class, 'switch'])->name('language.switch');

    // Route::get('dashboard', 'App\Http\Controllers\Frontend\FrontendController@index')->name('dashboard');


    // Route::group(['namespace' => 'App\Http\Controllers\Frontend', 'as' => 'frontend.'], function () {
    //     //Route::get('/', 'FrontendController@index')->name('index');

    //     Route::group(['middleware' => ['auth']], function () {
    //         /*
    //     *
    //     *  Users Routes
    //     *
    //     * ---------------------------------------------------------------------
    //     */
    //             $module_name = 'users';
    //             $controller_name = 'UserController';
    //             Route::get('profile/edit', ['as' => "{$module_name}.profileEdit", 'uses' => "{$controller_name}@profileEdit"]);
    //             Route::patch('profile/edit', ['as' => "{$module_name}.profileUpdate", 'uses' => "{$controller_name}@profileUpdate"]);
    //             Route::get('profile/changePassword', ['as' => "{$module_name}.changePassword", 'uses' => "{$controller_name}@changePassword"]);
    //             Route::patch('profile/changePassword', ['as' => "{$module_name}.changePasswordUpdate", 'uses' => "{$controller_name}@changePasswordUpdate"]);
    //             // Route::get('profile/{username?}', ['as' => "{$module_name}.profile", 'uses' => "{$controller_name}@profile"]);
    //             Route::get("{$module_name}/emailConfirmationResend", ['as' => "{$module_name}.emailConfirmationResend", 'uses' => "{$controller_name}@emailConfirmationResend"]);
    //             Route::delete("{$module_name}/userProviderDestroy", ['as' => "{$module_name}.userProviderDestroy", 'uses' => "{$controller_name}@userProviderDestroy"]);
    //         });
    //     });
    // });

    /*
*
* Backend Routes
* These routes need view-backend permission
* --------------------------------------------------------------------
*/
    Route::group(['namespace' => 'App\Http\Controllers\Backend', 'prefix' => 'admin', 'as' => 'backend.', 'middleware' => ['auth']], function () {
        /**
         * Backend Dashboard
         * Namespaces indicate folder structure.
         */
        Route::get('/', 'BackendController@index')->name('home');
        Route::get('dashboard', 'BackendController@index')->name('dashboard');
        Route::get('general-settings', 'BackendController@generalSettings')->name('general_settings');
        Route::POST('update-general-settings', 'BackendController@updateSettings')->name('settings.update');
        Route::post('/upload', [BackendController::class, 'upload'])->name('uploadFile');
        Route::get('/file/{folder}/{filename}', [BackendController::class, 'getFile']);

        /*
     *
     *  Settings Routes
     *
     * ---------------------------------------------------------------------
     */
        Route::group(['middleware' => ['can:edit_settings']], function () {
            $module_name = 'settings';
            $controller_name = 'SettingController';
            Route::get("{$module_name}", "{$controller_name}@index")->name("{$module_name}.index");
            Route::post("{$module_name}", "{$controller_name}@store")->name("{$module_name}.store");
        });

        /*
    *
    *  Notification Routes
    *
    * ---------------------------------------------------------------------
    */
        $module_name = 'notifications';
        $controller_name = 'NotificationsController';
        Route::get("{$module_name}", ['as' => "{$module_name}.index", 'uses' => "{$controller_name}@index"]);
        Route::get("{$module_name}/markAllAsRead", ['as' => "{$module_name}.markAllAsRead", 'uses' => "{$controller_name}@markAllAsRead"]);
        Route::delete("{$module_name}/deleteAll", ['as' => "{$module_name}.deleteAll", 'uses' => "{$controller_name}@deleteAll"]);
        Route::get("{$module_name}/{id}", ['as' => "{$module_name}.show", 'uses' => "{$controller_name}@show"]);

        /*
    *
    *  Backup Routes
    *
    * ---------------------------------------------------------------------
    */
        $module_name = 'backups';
        $controller_name = 'BackupController';
        Route::get("{$module_name}", ['as' => "{$module_name}.index", 'uses' => "{$controller_name}@index"]);
        Route::get("{$module_name}/create", ['as' => "{$module_name}.create", 'uses' => "{$controller_name}@create"]);
        Route::get("{$module_name}/download/{file_name}", ['as' => "{$module_name}.download", 'uses' => "{$controller_name}@download"]);
        Route::get("{$module_name}/delete/{file_name}", ['as' => "{$module_name}.delete", 'uses' => "{$controller_name}@delete"]);

        /*
    *
    *  Roles Routes
    *
    * ---------------------------------------------------------------------
    // */
        //     $module_name = 'roles';
        //     $controller_name = 'RolesController';
        //     Route::resource("{$module_name}", "{$controller_name}");

        /*
    *
    *  Users Routes
    *
    * ---------------------------------------------------------------------
    */
        $module_name = 'users';
        $controller_name = 'UserController';
        Route::get("{$module_name}/{id}/resend-email-confirmation", ['as' => "{$module_name}.emailConfirmationResend", 'uses' => "{$controller_name}@emailConfirmationResend"]);
        Route::delete("{$module_name}/user-provider-destroy", ['as' => "{$module_name}.userProviderDestroy", 'uses' => "{$controller_name}@userProviderDestroy"]);
        Route::get("{$module_name}/{id}/change-password", ['as' => "{$module_name}.changePassword", 'uses' => "{$controller_name}@changePassword"]);
        Route::patch("{$module_name}/{id}/change-password", ['as' => "{$module_name}.changePasswordUpdate", 'uses' => "{$controller_name}@changePasswordUpdate"]);
        Route::get("{$module_name}/trashed", ['as' => "{$module_name}.trashed", 'uses' => "{$controller_name}@trashed"]);
        Route::patch("{$module_name}/{id}/trashed", ['as' => "{$module_name}.restore", 'uses' => "{$controller_name}@restore"]);
        Route::get("{$module_name}/index_data", ['as' => "{$module_name}.index_data", 'uses' => "{$controller_name}@index_data"]);
        Route::get("{$module_name}/index_list", ['as' => "{$module_name}.index_list", 'uses' => "{$controller_name}@index_list"]);
        Route::patch("{$module_name}/{id}/block", ['as' => "{$module_name}.block", 'uses' => "{$controller_name}@block", 'middleware' => ['can:block_users']]);
        Route::patch("{$module_name}/{id}/unblock", ['as' => "{$module_name}.unblock", 'uses' => "{$controller_name}@unblock", 'middleware' => ['can:block_users']]);
        Route::resource("{$module_name}", "{$controller_name}");
    });

    /**
     * File Manager Routes.
     */
    Route::group(['prefix' => 'laravel-filemanager', 'middleware' => ['web', 'auth', 'can:view_backend']], function () {
        Lfm::routes();
    });

    // Blog routes
    Route::middleware(['moduleStatus:blogs'])->prefix('blogs')->name('blogs.')->group(function () {
        Route::get('/', [BlogController::class, 'index'])->name('index');
        Route::get('/category/{slug}', [BlogController::class, 'category'])->name('category');
        Route::get('/{slug}', [BlogController::class, 'show'])->name('show');
    });

    Route::get('/blogs/category/{slug}', [BlogController::class, 'category'])->name('blogs.category');

    // Wallet Routes (for authenticated users)
    Route::middleware(['auth'])->prefix('wallet')->name('wallet.')->group(function () {
        Route::get('/', [UserWalletController::class, 'index'])->name('index');
        Route::get('/transactions', [WalletController::class, 'transactions'])->name('transactions');
        Route::get('/withdrawals', [WalletController::class, 'withdrawals'])->name('withdrawals');
        Route::post('/withdraw', [WalletController::class, 'requestWithdrawal'])->name('withdraw');

        // New wallet pages
        Route::get('/transfer', function () {
            return view('front_end.pages.wallet.transfer');
        })->name('transfer');
        Route::get('/withdraw', function () {
            return view('front_end.pages.wallet.withdraw');
        })->name('withdraw.form');

        // Select2 users endpoint
        Route::get('/get-users', [UserWalletController::class, 'getUsers'])->name('get_users');
    });

    /**
     * Frontend Pages Routes
     */
    // Custom Pages - handled by WebController@detail_page now
    // Route::get('/page/{slug}', [PageController::class, 'showCustomPage'])->name('page.show');

    // Help Center
    Route::get('/help-center', [HelpCenterController::class, 'index'])->name('help-center.index');
    Route::get('/help-center/{slug}', [HelpCenterController::class, 'topic'])->name('help-center.topic');
    Route::get('/help-center/{topicSlug}/articles/{articleSlug}', [HelpCenterController::class, 'article'])->name('help-center.article');


    // Maintenance Mode Route
    Route::get('/maintenance', function () {
        return view('front_end.pages.maintenance');
    })->name('maintenance');

    // Search route
    Route::get('/search', function () {
        return view('front_end.search');
    })->name('search');

    // Messenger routes (requires authentication)
    Route::middleware(['auth'])->group(function () {
        Route::get('/messenger', [App\Http\Controllers\MessengerController::class, 'index'])->name('messenger');

        // Messenger API routes for frontend
        Route::prefix('web_api/messenger')->group(function () {
            Route::get('/conversations', [App\Http\Controllers\MessengerController::class, 'getConversations']);
            Route::post('/conversations', [App\Http\Controllers\MessengerController::class, 'createConversation']);
            Route::get('/conversations/search', [App\Http\Controllers\MessengerController::class, 'searchConversations']);
            Route::get('/conversations/{conversation}', [App\Http\Controllers\MessengerController::class, 'getConversation']);
            Route::get('/conversations/{conversation}/participants', [App\Http\Controllers\MessengerController::class, 'getParticipants']);
            Route::post('/conversations/{conversation}/leave', [App\Http\Controllers\MessengerController::class, 'leaveConversation']);

            Route::get('/conversations/{conversation}/messages', [App\Http\Controllers\MessengerController::class, 'getMessages']);
            Route::post('/conversations/{conversation}/messages', [App\Http\Controllers\MessengerController::class, 'sendMessage']);
            Route::get('/conversations/{conversation}/messages/{message}', [App\Http\Controllers\MessengerController::class, 'getMessage']);
            Route::put('/conversations/{conversation}/messages/{message}', [App\Http\Controllers\MessengerController::class, 'updateMessage']);
            Route::delete('/conversations/{conversation}/messages/{message}', [App\Http\Controllers\MessengerController::class, 'deleteMessage']);

            Route::get('/users/search', [App\Http\Controllers\MessengerController::class, 'searchUsers']);
            Route::post('/typing', [App\Http\Controllers\MessengerController::class, 'sendTyping']);
            Route::get('/receipts', [App\Http\Controllers\MessengerController::class, 'getReceipts']);
            Route::post('/receipts', [App\Http\Controllers\MessengerController::class, 'markAsRead']);
            Route::get('/updates', [App\Http\Controllers\MessengerController::class, 'getUpdates']);
        });
    });
});
Route::get('/assets/{path}', [App\Http\Controllers\MediaController::class, 'serve'])
    ->where('path', '.*');
