<?php
    $showRightSidebar = false;
?>
<?php $__env->startSection('title', 'Create Story'); ?>
<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Main Card -->
            <div class="card shadow-sm border-0 rounded-4 overflow-hidden">
                <!-- Header Section -->
                <div class="bg-primary text-white p-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <a href="<?php echo e(url('/')); ?>" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <h4 class="mb-0 text-white">Create New Story</h4>
                        </div>
                        <span class="text-white px-3 py-2">Share your moments</span>
                    </div>
                </div>
                
                <!-- User Info Section -->
                <div class="bg-light p-4 border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="avatar me-3">
                            <img src="<?php echo e(getMedia(Auth::user()->avatar,'avatar')); ?>" class="rounded-circle" width="48" height="48" alt="User Avatar">
                        </div>
                        <div>
                            <h6 class="mb-0 fw-bold"><?php echo e(Auth::user()->name); ?></h6>
                            <small class="text-muted"><?php echo e("@"); ?><?php echo e(Auth::user()->username); ?></small>
                        </div>
                    </div>
                </div>
                
                <!-- Form Section -->
                <div class="p-4">
                    <form id="storyForm">
                        <!-- Story Type Selection -->
                        <div class="mb-4">
                            <label class="form-label fw-semibold">Story Type</label>
                            <div class="btn-group w-100" role="group">
                                <button type="button" class="btn btn-outline-primary active" data-story-type="text">
                                    <i class="fas fa-font me-2"></i>Text
                                </button>
                                <button type="button" class="btn btn-outline-primary" data-story-type="image">
                                    <i class="fas fa-camera me-2"></i>Photo
                                </button>
                                <button type="button" class="btn btn-outline-primary" data-story-type="video">
                                    <i class="fas fa-video me-2"></i>Video
                                </button>
                            </div>
                            <input type="hidden" name="type" id="storyType" value="text">
                        </div>
                        
                        <!-- Text Story Editor (for text-only stories) -->
                        <div class="mb-4 story-editor" id="textStoryEditor">
                            <label class="form-label fw-semibold">Your Story Text</label>
                            <div class="bg-light rounded-3 p-3 border">
                                <div class="mb-3 pb-2 border-bottom">
                                    <button type="button" class="btn btn-sm btn-light me-2" data-text-style="bold">
                                        <i class="fas fa-bold"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-light me-2" data-text-style="italic">
                                        <i class="fas fa-italic"></i>
                                    </button>
                                </div>
                                <textarea name="description" class="form-control border-0 bg-transparent" rows="5" placeholder="What's on your mind?"></textarea>
                            </div>
                        </div>
                        
                        <!-- Media Upload -->
                        <div class="mb-4 story-editor d-none" id="mediaStoryEditor">
                            <label class="form-label fw-semibold">Upload Media</label>
                            <div class="bg-light rounded-3 border p-4">
                                <div class="text-center" id="uploadArea">
                                    <div class="dropzone-preview mb-3">
                                        <i class="fas fa-cloud-upload-alt fa-3x text-muted"></i>
                                    </div>
                                    <h6>Drag and drop your media here</h6>
                                    <p class="small text-muted mb-3">or</p>
                                    <label class="btn btn-primary mb-0">
                                        <span><i class="fas fa-upload me-2"></i>Choose File</span>
                                        <input type="file" name="media" id="mediaInput" class="d-none" accept="image/*,video/*">
                                    </label>
                                </div>
                                <!-- Media Preview with Text Overlay Container -->
                                <div id="mediaPreviewContainer" class="mt-3 d-none">
                                    <div class="position-relative bg-dark rounded-3 overflow-hidden" id="storyCanvasContainer" style="min-height: 400px; max-height: 600px; display: flex; align-items: center; justify-content: center;">
                                        <img id="mediaPreview" class="w-100 h-auto" style="max-height: 600px; object-fit: contain;" alt="Story preview">
                                        <canvas id="storyCanvas" class="position-absolute" style="top: 0; left: 0; pointer-events: none;"></canvas>
                                        <!-- Text Overlay Elements Container -->
                                        <div id="textOverlaysContainer" class="position-absolute w-100 h-100" style="top: 0; left: 0; pointer-events: none;"></div>
                                    </div>
                                    <!-- Text Overlay Editor (shown when image is uploaded) -->
                                    <div class="mt-3 p-3 bg-light rounded-3 border" id="textOverlayEditor">
                                        <label class="form-label fw-semibold mb-2">Add Text Overlay</label>
                                        <div class="input-group mb-2">
                                            <input type="text" id="textOverlayInput" class="form-control" placeholder="Type your text here...">
                                            <button type="button" class="btn btn-primary" id="addTextBtn">
                                                <i class="fas fa-plus me-2"></i>Add Text
                                            </button>
                                        </div>
                                        <div class="d-flex flex-wrap gap-2 mb-2">
                                            <button type="button" class="btn btn-sm btn-outline-primary" data-text-color="#FFFFFF">
                                                <i class="fas fa-palette me-1"></i> White
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-danger" data-text-color="#FF0000">
                                                <i class="fas fa-palette me-1"></i> Red
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-success" data-text-color="#00FF00">
                                                <i class="fas fa-palette me-1"></i> Green
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-info" data-text-color="#0000FF">
                                                <i class="fas fa-palette me-1"></i> Blue
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-warning" data-text-color="#FFFF00">
                                                <i class="fas fa-palette me-1"></i> Yellow
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-dark" data-text-color="#000000">
                                                <i class="fas fa-palette me-1"></i> Black
                                            </button>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <button type="button" class="btn btn-sm btn-light" id="increaseFontBtn">
                                                <i class="fas fa-font me-1"></i> Bigger
                                            </button>
                                            <button type="button" class="btn btn-sm btn-light" id="decreaseFontBtn">
                                                <i class="fas fa-font me-1"></i> Smaller
                                            </button>
                                            <button type="button" class="btn btn-sm btn-light" id="boldTextBtn">
                                                <i class="fas fa-bold"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-light" id="italicTextBtn">
                                                <i class="fas fa-italic"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" id="removeTextBtn">
                                                <i class="fas fa-trash me-1"></i> Remove All
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Duration -->
                        <div class="mb-4">
                            <label class="form-label fw-semibold">Story Duration</label>
                            <select class="form-select" name="duration">
                                <option value="24">24 Hours</option>
                                <option value="48">48 Hours</option>
                                <option value="72">72 Hours</option>
                            </select>
                        </div>
                        
                        <!-- Submit Button -->
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end mt-4">
                            <button type="submit" class="btn btn-primary px-5" id="submitStory">
                                <i class="fas fa-paper-plane me-2"></i>Share Story
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .text-overlay-element {
        transition: transform 0.1s ease;
    }
    .text-overlay-element:hover {
        transform: scale(1.05);
        outline: 2px dashed rgba(255, 255, 255, 0.5);
    }
    #textOverlaysContainer {
        pointer-events: none;
    }
    #textOverlaysContainer .text-overlay-element {
        pointer-events: auto;
    }
    #storyCanvasContainer {
        position: relative;
    }
    #mediaPreview {
        display: block;
        margin: 0 auto;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/vendor/zuck.js/dist/zuck.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front_end.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/newsfeed/create_story.blade.php ENDPATH**/ ?>