<div class="quick-links-card shadow-sm rounded-4 mt-4 bg-white">
    <div class="card-body text-center p-3">
        <div class="quick-links-icon mb-3 mx-auto d-flex align-items-center justify-content-center rounded-circle">
            <i class="fas fa-compass"></i>
        </div>
        <h6 class="fw-semibold fs-6 mb-1">Need a quick link?</h6>
        <p class="text-muted small-75 mb-3">Jump straight to the essentials without leaving your feed.</p>

        <div class="d-flex flex-wrap gap-2 justify-content-center">
            <a class="btn btn-xs btn-outline-primary rounded-pill" href="<?php echo e(route('detail_page', 'about-us')); ?>">
                <i class="fas fa-info-circle me-1"></i> About
            </a>
            <?php if(auth()->guard()->check()): ?>
                <a class="btn btn-xs btn-outline-primary rounded-pill" href="<?php echo e(route('settings.account')); ?>">
                    <i class="fas fa-cog me-1"></i> Settings
                </a>
            <?php endif; ?>
            <a class="btn btn-xs btn-outline-primary rounded-pill" href="<?php echo e(route('help-center.index')); ?>">
                <i class="fas fa-life-ring me-1"></i> Help Center
            </a>
            <a class="btn btn-xs btn-outline-primary rounded-pill" href="<?php echo e(route('detail_page', 'privacy-policy')); ?>">
                <i class="fas fa-shield-alt me-1"></i> Privacy & Terms
            </a>
        </div>
    </div>
    <div class="quick-links-footer text-center small-75 text-muted pb-3">
        ©<?php echo e(date('Y')); ?> <a class="text-reset fw-semibold" target="_blank" href="<?php echo e(url('/')); ?>"><?php echo e(setting('site_name')); ?></a>. All rights reserved.
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .quick-links-card {
        background: linear-gradient(160deg, rgba(55, 88, 249, 0.08) 0%, rgba(186, 199, 255, 0.15) 100%);
        border: none;
    }

    .quick-links-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #3758f9 0%, #1e3dfa 100%);
        color: #fff;
        font-size: 1rem;
        box-shadow: 0 0.75rem 2rem rgba(55, 88, 249, 0.25);
    }

    .quick-links-card .btn-outline-primary {
        border-color: rgba(55, 88, 249, 0.35);
        color: #1e2a5a;
        transition: all 0.2s ease;
        background-color: rgba(255, 255, 255, 0.85);
        padding: 0.35rem 0.85rem;
        font-size: 0.82rem;
    }

    .quick-links-card .btn-outline-primary:hover {
        background: linear-gradient(135deg, #3758f9 0%, #1e3dfa 100%);
        border-color: transparent;
        color: #fff;
        box-shadow: 0 0.8rem 1.8rem rgba(55, 88, 249, 0.35);
    }

    .quick-links-footer a {
        text-decoration: none;
    }

    .small-75 {
        font-size: 0.78rem;
        line-height: 1.35;
    }

    .btn-xs {
        padding: 0.3rem 0.75rem;
        font-size: 0.78rem;
        border-radius: 999px;
    }
</style>
<?php $__env->stopPush(); ?>
<?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/components/footer_left_sidebar.blade.php ENDPATH**/ ?>