<?php
$showRightSidebar = false;
?>
<?php $__env->startSection('title', 'Pages'); ?>

<?php $__env->startSection('left_sidebar'); ?>
<?php echo $__env->make('front_end.pages.pages.page_left_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


<div class="bg-white shadow-sm border-0 rounded-3">

    <!-- Create Story Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="<?php echo e(url('/')); ?>" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>

                                <div class="d-flex justify-content-between align-items-center ">
                                    <div>
                                        <h4 class="mb-0 text-white">Pages</h4>
                                        <p class="mb-0 text-white">Discover and connect with businesses, brands, and organizations</p>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">

                                <a href="<?php echo e(route('pages.create')); ?>" class="btn btn-primary btn-info">
                                    <i class="fas fa-plus-circle me-2"></i>Create Page
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <!-- Pages section start -->
    <div class="container mt-4">
        <!-- Stats Overview -->
        <div class="row mb-4">
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-primary bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-primary bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-flag fa-2x text-primary"></i>
                        </div>
                        <h3 class="mb-0" id="total-pages-count">
                            <span class="spinner-border spinner-border-sm me-2" role="status" id="total-pages-spinner"></span>
                            <span id="total-pages-text"><?php echo e($totalPages ?? 0); ?></span>
                        </h3>
                        <p class="mb-0">Total Pages</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-success bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-success bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-heart fa-2x text-success"></i>
                        </div>
                        <h3 class="mb-0" id="following-count-stat">
                            <span class="spinner-border spinner-border-sm me-2" role="status" id="following-spinner"></span>
                            <span id="following-text">-</span>
                        </h3>
                        <p class="mb-0">Pages Following</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-warning bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-warning bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-store fa-2x text-warning"></i>
                        </div>
                        <h3 class="mb-0" id="my-pages-count"><?php echo e($myPages ?? 0); ?></h3>
                        <p class="mb-0">My Pages</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-info bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-info bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-bullhorn fa-2x text-info"></i>
                        </div>
                        <h3 class="mb-0" id="verified-count-stat">
                            <span class="spinner-border spinner-border-sm me-2" role="status" id="verified-spinner"></span>
                            <span id="verified-text">-</span>
                        </h3>
                        <p class="mb-0">Verified Pages</p>
                    </div>
                </div>
            </div>
        </div>


        <!-- Quick Filter Pills -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex flex-wrap gap-2" id="quickFilters">
                    <button class="btn btn-sm btn-outline-primary rounded-pill quick-filter active" data-filter="all">
                        All Pages <span class="badge bg-primary ms-2" id="all-count">-</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill quick-filter" data-filter="following">
                        Following <span class="badge bg-secondary ms-2" id="following-count">-</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill quick-filter" data-filter="verified">
                        Verified <span class="badge bg-secondary ms-2" id="verified-count">-</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill quick-filter" data-filter="popular">
                        Popular <span class="badge bg-secondary ms-2" id="popular-count">-</span>
                    </button>
                    <button class="btn btn-sm btn-outline-primary rounded-pill quick-filter" data-filter="recent">
                        Recent <span class="badge bg-secondary ms-2" id="recent-count">-</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Search and Filter Section -->
        <div class="row mb-4">
            <div class="col-md-6">
                <div class="input-group">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-search"></i>
                    </span>
                    <input type="text" class="form-control search-page" placeholder="Search pages by name or category" id="searchInput">
                    <button class="btn btn-outline-secondary clear-search-btn" type="button" style="display: none;">
                        <i class="fas fa-times"></i>
                    </button>
                    <button class="btn btn-primary search-btn" type="button">Search</button>
                </div>
            </div>
            <div class="col-md-3">
                <select class="form-select category-filter" id="categoryFilter">
                    <option value="">All Categories</option>
                    <option value="business">Business</option>
                    <option value="entertainment">Entertainment</option>
                    <option value="education">Education</option>
                    <option value="technology">Technology</option>
                    <option value="health">Health</option>
                    <option value="sports">Sports</option>
                    <option value="news">News</option>
                    <option value="other">Other</option>
                </select>
            </div>
            <div class="col-md-3">
                <button class="btn btn-outline-secondary w-100" type="button" data-bs-toggle="collapse"
                    data-bs-target="#filterOptions">
                    <i class="fas fa-sliders-h me-2"></i>Advanced Filters
                </button>
            </div>
        </div>

        <!-- Collapsible Filter Options -->
        <div class="collapse mb-4" id="filterOptions">
            <div class="card card-body border-0 bg-light-subtle">
                <div class="row g-4">
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Category</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-business" value="business">
                                <label class="form-check-label" for="filter-business">Business</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-entertainment" value="entertainment">
                                <label class="form-check-label" for="filter-entertainment">Entertainment</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-education" value="education">
                                <label class="form-check-label" for="filter-education">Education</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-technology" value="technology">
                                <label class="form-check-label" for="filter-technology">Technology</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Followers</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-small" value="small">
                                <label class="form-check-label" for="filter-small">
                                    < 1K followers</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-medium" value="medium">
                                <label class="form-check-label" for="filter-medium">1K - 100K followers</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-large" value="large">
                                <label class="form-check-label" for="filter-large">> 100K followers</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Verification</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-verified" value="verified">
                                <label class="form-check-label" for="filter-verified">Verified Pages</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="filter-unverified" value="unverified">
                                <label class="form-check-label" for="filter-unverified">Unverified Pages</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Sort By</label>
                        <select class="form-select" id="sortBy">
                            <option value="newest">Newest First</option>
                            <option value="oldest">Oldest First</option>
                            <option value="most_followers">Most Followers</option>
                            <option value="least_followers">Least Followers</option>
                            <option value="alphabetical">A-Z</option>
                        </select>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-12">
                        <button class="btn btn-primary me-2" id="applyFilters">Apply Filters</button>
                        <button class="btn btn-outline-secondary" id="resetFilters">Reset</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pages Grid -->
        <div class="row" id="pages_list">

        <!-- Card 1 -->
        <div class="col-md-4">
            <div class="card p-3">
                <div class="shimmer placeholder-img"></div>
                <div class="shimmer placeholder-title"></div>
                <div class="shimmer placeholder-text w-100"></div>
                <div class="shimmer placeholder-text w-75"></div>
                <div class="shimmer placeholder-btn mt-3"></div>
            </div>
        </div>

        <!-- Card 2 -->
        <div class="col-md-4">
            <div class="card p-3">
                <div class="shimmer placeholder-img"></div>
                <div class="shimmer placeholder-title"></div>
                <div class="shimmer placeholder-text w-100"></div>
                <div class="shimmer placeholder-text w-75"></div>
                <div class="shimmer placeholder-btn mt-3"></div>
            </div>
        </div>

        <!-- Card 3 -->
        <div class="col-md-4">
            <div class="card p-3">
                <div class="shimmer placeholder-img"></div>
                <div class="shimmer placeholder-title"></div>
                <div class="shimmer placeholder-text w-100"></div>
                <div class="shimmer placeholder-text w-75"></div>
                <div class="shimmer placeholder-btn mt-3"></div>
            </div>
        </div>
         
        </div>

        <!-- Discover More Pages -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card border-0 bg-primary bg-opacity-10 p-4">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="text-primary mb-2">Want to reach more customers?</h4>
                            <p class="mb-md-0">Create your own page and connect with millions of potential customers</p>
                        </div>
                        <div class="col-md-4 text-md-end">
                            <a href="<?php echo e(route('pages.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus-circle me-2"></i>Create Your Page
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pagination -->
        <div class="row mt-4 mb-4">
            <div class="col-12">
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center" id="pagination">
                        <!-- Pagination will be dynamically populated via JavaScript -->
                    </ul>
                </nav>
            </div>
        </div>

    </div>
    <!-- Pages section ends -->

</div>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('assets/js/pages.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .hover-shadow-lg:hover {
        box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.175) !important;
        transform: translateY(-2px);
        transition: all 0.3s ease;
    }
    
    .transition-hover {
        transition: all 0.3s ease;
    }
    
    .shimmer {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: shimmer 1.5s infinite;
    }
    
    @keyframes shimmer {
        0% { background-position: -200% 0; }
        100% { background-position: 200% 0; }
    }
    
    .placeholder-img {
        height: 140px;
        border-radius: 0.375rem 0.375rem 0 0;
        margin-bottom: 1rem;
    }
    
    .placeholder-title {
        height: 1.5rem;
        width: 70%;
        margin-bottom: 0.5rem;
        border-radius: 0.25rem;
    }
    
    .placeholder-text {
        height: 0.875rem;
        margin-bottom: 0.5rem;
        border-radius: 0.25rem;
    }
    
    .placeholder-btn {
        height: 2.5rem;
        width: 100%;
        border-radius: 0.375rem;
    }
    
    .search-page:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    .category-filter:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    .quick-filter.active {
        background-color: #0d6efd;
        border-color: #0d6efd;
        color: white;
    }
    
    .quick-filter.active .badge {
        background-color: rgba(255, 255, 255, 0.2) !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('extra-js'); ?>
<script>
    $(document).ready(function() {
        get_all_pages(1, false);
        loadPageStats();
    });
</script>
<?php $__env->stopSection(); ?>





<?php $__env->stopSection(); ?>
<?php echo $__env->make('front_end.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/pages/all_pages.blade.php ENDPATH**/ ?>