<?php $__env->startSection('title', $customPage->title); ?>

<?php $__env->startSection('meta_description', $customPage->meta_description); ?>
<?php $__env->startSection('meta_keywords', $customPage->meta_keywords); ?>

<?php
    // Ensure sidebars are shown unless explicitly disabled in child views
    $showLeftSidebar = false;
    $showRightSidebar = false;

?>


<?php $__env->startSection('content'); ?>
<section class="custom-page-wrapper py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-9 col-lg-10">
                <div class="custom-page-hero mb-4">
                    <a href="<?php echo e(url()->previous() === url()->current() ? url('/') : url()->previous()); ?>" class="btn btn-outline-light btn-sm mb-3  text-white">
                        <i class="fas fa-arrow-left me-2"></i>Back
                    </a>
                    <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3">
                        <div>
                            <h1 class="fw-bold text-white mb-2 fs-2 fs-lg-1"><?php echo e($customPage->title); ?></h1>
                            <?php if($customPage->meta_description): ?>
                                <p class="text-white-50 mb-0 fs-6"><?php echo e($customPage->meta_description); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="custom-page-meta text-white-50 small text-md-end">
                            <div><i class="far fa-clock me-2"></i>
                                <?php if($customPage->updated_at): ?>
                                    Updated <?php echo e($customPage->updated_at->diffForHumans()); ?>

                                <?php else: ?>
                                    Fresh insights
                                <?php endif; ?>
                            </div>
                            <div><i class="far fa-file-alt me-2"></i><?php echo e(number_format(str_word_count(strip_tags((string) $customPage->content)))); ?> words</div>
                        </div>
                    </div>
                </div>

                <div class="position-relative">
                    <div class="custom-page-progress">
                        <div class="custom-page-progress-bar" id="customPageProgressBar"></div>
                    </div>

                    <div class="custom-page-card shadow-sm bg-white rounded-4 overflow-hidden">
                        <div class="custom-page-card-body p-4 p-md-5">
                            <div class="row g-4 custom-page-layout">
                                <div class="col-lg-8">
                                    <article class="custom-page-content" id="customPageContent">
                                        <?php echo $customPage->content; ?>

                                    </article>
                                </div>
                                <div class="col-lg-4">
                                    <aside class="custom-page-aside h-100">
                                        <div class="custom-page-aside-card mb-4">
                                            <h6 class="fw-semibold mb-2">
                                                <i class="fas fa-list-ul me-2 text-primary"></i>On this page
                                            </h6>
                                            <nav class="toc-list small" id="customPageTOC">
                                                <p class="text-muted mb-0">Headings will appear here after the page loads.</p>
                                            </nav>
                                        </div>
                                        <div class="custom-page-aside-card mb-4">
                                            <h6 class="fw-semibold mb-3">
                                                <i class="fas fa-share-alt me-2 text-primary"></i>Share
                                            </h6>
                                            <div class="d-flex flex-wrap gap-2">
                                                <a class="btn btn-outline-primary btn-sm" target="_blank" href="https://twitter.com/intent/tweet?url=<?php echo e(urlencode(url()->current())); ?>&text=<?php echo e(urlencode($customPage->title)); ?>">
                                                    <i class="fab fa-x-twitter me-1"></i> Tweet
                                                </a>
                                                <a class="btn btn-outline-primary btn-sm" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>">
                                                    <i class="fab fa-facebook-f me-1"></i> Share
                                                </a>
                                                <button class="btn btn-outline-secondary btn-sm" id="copyPageLink">
                                                    <i class="fas fa-link me-1"></i> Copy link
                                                </button>
                                            </div>
                                            <small class="text-muted d-block mt-2">Links open in new tabs.</small>
                                        </div>
                                        <div class="custom-page-aside-card">
                                            <h6 class="fw-semibold mb-3">
                                                <i class="fas fa-comments me-2 text-primary"></i>Feedback
                                            </h6>
                                            <p class="text-muted small mb-3">Notice something outdated? Let our team know so we can keep this page accurate.</p>
                                            <a class="btn btn-primary btn-sm w-100" href="mailto:support@socialink.com?subject=<?php echo e(rawurlencode('Feedback for '.$customPage->title)); ?>">
                                                Send feedback
                                            </a>
                                        </div>
                                    </aside>
                                </div>
                            </div>
                        </div>
                        <div class="custom-page-card-footer border-top px-4 px-md-5 py-3 bg-light">
                            <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-2 text-muted small">
                                <div>
                                    <i class="fas fa-info-circle me-2"></i>
                                    Looking for more? Visit the <a href="<?php echo e(route('help-center.index')); ?>">Help Center</a> for guided resources.
                                </div>
                                <div>
                                    <i class="far fa-calendar-alt me-2"></i>
                                    <?php if($customPage->updated_at): ?>
                                        Last updated on <?php echo e($customPage->updated_at->format('F d, Y')); ?>

                                    <?php else: ?>
                                        Published on <?php echo e($customPage->created_at?->format('F d, Y') ?? '—'); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .custom-page-wrapper {
        background: linear-gradient(180deg, rgba(15,28,63,0.9) 0%, rgba(15,28,63,0.65) 35%, #f6f7fb 35%, #f6f7fb 100%);
        min-height: 100vh;
    }

    .custom-page-hero {
        background: rgba(255, 255, 255, 0.08);
        backdrop-filter: blur(6px);
        border-radius: 2rem;
        border: 1px solid rgba(255, 255, 255, 0.12);
        padding: 2.1rem;
    }

    .custom-page-card {
        border: none;
    }

    .custom-page-card-body {
        font-size: 1rem;
        line-height: 1.7;
        color: #2e3652;
    }

    .custom-page-card-body > *:first-child {
        margin-top: 0;
    }

    .custom-page-content h1,
    .custom-page-content h2,
    .custom-page-content h3,
    .custom-page-content h4,
    .custom-page-content h5 {
        font-weight: 600;
        color: #141c3a;
        margin-top: 2rem;
        margin-bottom: 1rem;
    }

    .custom-page-content h1:first-child,
    .custom-page-content h2:first-child,
    .custom-page-content h3:first-child {
        margin-top: 0;
    }

    .custom-page-content p {
        margin-bottom: 0.9rem;
        color: #46506b;
    }

    .custom-page-content ul,
    .custom-page-content ol {
        margin-bottom: 1rem;
        padding-left: 1.4rem;
    }

    .custom-page-content li + li {
        margin-top: 0.35rem;
    }

    .custom-page-content img {
        max-width: 100%;
        height: auto;
        border-radius: 1rem;
        margin: 1.25rem 0;
        box-shadow: 0 1.5rem 3rem rgba(15, 28, 63, 0.18);
    }

    .custom-page-content a {
        color: #3758f9;
        font-weight: 600;
        text-decoration: underline;
        text-decoration-thickness: 0.1rem;
    }

    .custom-page-content a:hover {
        color: #1e3dfa;
        text-decoration: none;
    }

    .custom-page-content table {
        width: 100%;
        margin-bottom: 1rem;
        border-collapse: collapse;
        border-radius: 0.75rem;
        overflow: hidden;
        box-shadow: 0 0 0 1px rgba(122, 134, 160, 0.1);
    }

    .custom-page-content table th,
    .custom-page-content table td {
        padding: 0.75rem 1rem;
        border: 1px solid rgba(122, 134, 160, 0.18);
        background-color: #fff;
    }

    .custom-page-content table th {
        background-color: #eef2ff;
        font-weight: 700;
        color: #1e2a5a;
    }

    .custom-page-progress {
        position: sticky;
        top: 0;
        height: 4px;
        background: rgba(55, 88, 249, 0.1);
        border-radius: 999px;
        margin-bottom: 1rem;
        overflow: hidden;
        z-index: 10;
    }

    .custom-page-progress-bar {
        height: 100%;
        width: 0;
        background: linear-gradient(90deg, #3758f9 0%, #1e3dfa 100%);
        transition: width 0.2s ease-out;
    }

    .custom-page-aside-card {
        background: rgba(55, 88, 249, 0.05);
        border: 1px solid rgba(55, 88, 249, 0.08);
        border-radius: 1.25rem;
        padding: 1.5rem;
        font-size: 0.92rem;
    }

    .custom-page-aside-card:not(:last-child) {
        box-shadow: 0 1rem 2rem rgba(15, 28, 63, 0.07);
    }

    .custom-page-aside {
        position: sticky;
        top: 6rem;
    }

    .custom-page-aside-card .btn-outline-primary {
        border-color: rgba(55, 88, 249, 0.35);
        color: #1e2a5a;
        background-color: rgba(255, 255, 255, 0.85);
    }

    .custom-page-aside-card .btn-outline-primary:hover {
        background: linear-gradient(135deg, #3758f9 0%, #1e3dfa 100%);
        border-color: transparent;
        color: #fff;
        box-shadow: 0 0.8rem 1.8rem rgba(55, 88, 249, 0.35);
    }

    .toc-list {
        max-height: 320px;
        overflow-y: auto;
        padding-left: 0;
    }

    .toc-list ul {
        list-style: none;
        padding-left: 0;
        margin-bottom: 0;
    }

    .toc-list li {
        margin-bottom: 0.4rem;
    }

    .toc-list a {
        text-decoration: none;
        color: #4a5677;
        display: inline-block;
    }

    .toc-list a:hover,
    .toc-list a.active {
        color: #1e3dfa;
        font-weight: 600;
    }

    @media (max-width: 767px) {
        .custom-page-hero {
            padding: 1.5rem;
            border-radius: 1.5rem;
        }

        .custom-page-card-body {
            padding: 2.25rem;
        }

        .custom-page-progress {
            position: relative;
        }

        .toc-list {
            max-height: none;
        }

        .custom-page-aside {
            position: static;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const content = document.getElementById('customPageContent');
        const toc = document.getElementById('customPageTOC');
        const headings = content ? content.querySelectorAll('h2, h3') : [];

        if (toc && headings.length) {
            const tocList = document.createElement('ul');
            headings.forEach((heading, index) => {
                const slug = heading.id || 'section-' + index;
                heading.id = slug;

                const listItem = document.createElement('li');
                if (heading.tagName === 'H3') {
                    listItem.style.paddingLeft = '1rem';
                }

                const link = document.createElement('a');
                link.href = '#' + slug;
                link.textContent = heading.textContent;
                link.addEventListener('click', function (event) {
                    event.preventDefault();
                    document.querySelectorAll('#customPageTOC a').forEach(a => a.classList.remove('active'));
                    link.classList.add('active');
                    document.getElementById(slug).scrollIntoView({ behavior: 'smooth', block: 'start' });
                });

                listItem.appendChild(link);
                tocList.appendChild(listItem);
            });

            toc.innerHTML = '';
            toc.appendChild(tocList);
        } else if (toc) {
            toc.innerHTML = '<p class="text-muted mb-0">No subheadings were provided on this page.</p>';
        }

        const progressBar = document.getElementById('customPageProgressBar');
        const customPageCard = document.querySelector('.custom-page-card');

        function updateProgress() {
            if (!progressBar || !customPageCard) return;
            const scrollTop = window.scrollY;
            const docHeight = customPageCard.scrollHeight - window.innerHeight;
            const progress = docHeight > 0 ? Math.min(Math.max((scrollTop / docHeight) * 100, 0), 100) : 0;
            progressBar.style.width = progress + '%';
        }

        updateProgress();
        window.addEventListener('scroll', updateProgress);
        window.addEventListener('resize', updateProgress);

        const copyButton = document.getElementById('copyPageLink');
        if (copyButton) {
            copyButton.addEventListener('click', () => {
                navigator.clipboard.writeText(window.location.href).then(() => {
                    copyButton.classList.add('btn-success');
                    copyButton.classList.remove('btn-outline-secondary');
                    copyButton.innerHTML = '<i class="fas fa-check me-1"></i> Copied';
                    setTimeout(() => {
                        copyButton.classList.remove('btn-success');
                        copyButton.classList.add('btn-outline-secondary');
                        copyButton.innerHTML = '<i class="fas fa-link me-1"></i> Copy link';
                    }, 2000);
                });
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('front_end.layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/custom_page.blade.php ENDPATH**/ ?>