<?php
    $showRightSidebar = false;
?>

<?php $__env->startSection('title', 'Liked Groups'); ?>

<?php $__env->startSection('left_sidebar'); ?>
    <?php echo $__env->make('front_end.pages.groups.group_left_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white shadow-sm border-0 rounded-3">

    <!-- Breadcrumb Navigation -->
    <div class="card border-0 mb-3">
        <div class="card-body py-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('/')); ?>" class="text-decoration-none d-flex align-items-center">
                            <i class="fas fa-home me-1 text-primary"></i>
                            <span class="text-primary fw-medium">Home</span>
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('groups')); ?>" class="text-decoration-none text-muted">
                            <i class="fas fa-users me-1"></i>
                            Groups
                        </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <i class="fas fa-heart me-1 text-danger"></i>
                        Liked Groups
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Create Story Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="<?php echo e(url('/')); ?>" class="text-white me-3 d-flex align-items-center">
                                    <i class="fas fa-arrow-left fa-lg me-2"></i>
                                    <span class="fw-medium">Back to Home</span>
                                </a>

                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h4 class="mb-0 text-white">Liked Groups</h4>
                                        <p class="mb-0 text-white">Groups you've joined and are following</p>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <a class="btn btn-light btn-sm me-2" href="<?php echo e(route('create_group')); ?>">
                                    <i class="fas fa-plus-circle me-1"></i>Create Group
                                </a>
                                <a class="btn btn-outline-light btn-sm" href="<?php echo e(url('groups')); ?>">
                                    <i class="fas fa-compass me-1"></i>Explore
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Groups section start -->
    <div class="container mt-4">
        <!-- Search and Filter Section -->
        <div class="row mb-4">
            <div class="col-md-8">
                <div class="input-group">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-search"></i>
                    </span>
                    <input type="text" class="form-control search-group" placeholder="Search your liked groups by name or description" name="search-input">
                    <button class="btn btn-primary search-btn" type="button">Search</button>
                    <button class="btn btn-outline-secondary clear-search-btn" type="button" style="display: none;">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="col-md-4">
                <div class="d-flex gap-2">
                    <select class="form-select category-filter" name="category">
                        <option value="">All Categories</option>
                        <option value="technology">Technology</option>
                        <option value="business">Business</option>
                        <option value="education">Education</option>
                        <option value="entertainment">Entertainment</option>
                        <option value="sports">Sports</option>
                        <option value="health">Health</option>
                        <option value="lifestyle">Lifestyle</option>
                        <option value="other">Other</option>
                    </select>
                    <button class="btn btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#filterOptions">
                        <i class="fas fa-sliders-h"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Collapsible Filter Options -->
        <div class="collapse mb-4" id="filterOptions">
            <div class="card card-body border-0 bg-light-subtle">
                <div class="row g-4">
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Privacy</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="public" data-filter-type="privacy" value="public">
                                <label class="form-check-label" for="public">Public</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="private" data-filter-type="privacy" value="private">
                                <label class="form-check-label" for="private">Private</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Member Count</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="small" data-filter-type="memberCount" value="small">
                                <label class="form-check-label" for="small">< 100 members</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="medium" data-filter-type="memberCount" value="medium">
                                <label class="form-check-label" for="medium">100-1000 members</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input advanced-filter" type="checkbox" id="large" data-filter-type="memberCount" value="large">
                                <label class="form-check-label" for="large">> 1000 members</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Sort By</label>
                        <select class="form-select" id="sort-filter">
                            <option value="newest">Newest First</option>
                            <option value="oldest">Oldest First</option>
                            <option value="most_members">Most Members</option>
                            <option value="least_members">Least Members</option>
                            <option value="alphabetical">Alphabetical</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Categories</label>
                        <select class="form-select" id="category-advanced-filter">
                            <option value="">All Categories</option>
                            <option value="technology">Technology</option>
                            <option value="business">Business</option>
                            <option value="education">Education</option>
                            <option value="entertainment">Entertainment</option>
                            <option value="sports">Sports</option>
                            <option value="health">Health</option>
                            <option value="lifestyle">Lifestyle</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-12">
                        <button class="btn btn-primary me-2 apply-filters-btn">Apply Filters</button>
                        <button class="btn btn-outline-secondary reset-filters-btn">Reset</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Groups Grid -->
        <div class="row groups-grid">
            <!-- Groups will be dynamically populated via JavaScript -->
        </div>

        <!-- Discover Section -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card border-0 bg-primary bg-opacity-10 p-4">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="text-primary mb-2">Looking for more groups to join?</h4>
                            <p class="mb-md-0">Discover new communities and connect with people who share your interests</p>
                        </div>
                        <div class="col-md-4 text-md-end">
                            <a class="btn btn-primary" href="<?php echo e(url('groups')); ?>">
                                <i class="fas fa-compass me-2"></i>Discover Groups
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pagination -->
        <div class="row mt-4 mb-4">
            <div class="col-12">
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center" id="pagination">
                        <!-- Pagination will be dynamically populated via JavaScript -->
                    </ul>
                </nav>
            </div>
        </div>
    </div>
    <!-- Groups section ends -->
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .hover-shadow-md:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
        transform: translateY(-2px);
        transition: all 0.3s ease;
    }
    
    .transition-hover {
        transition: all 0.3s ease;
    }
    
    .search-group:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    .category-filter:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    /* Beautiful breadcrumb styling */
    .breadcrumb {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 0.5rem;
        padding: 0.75rem 1rem;
        margin: 0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    
    .breadcrumb-item a {
        transition: all 0.3s ease;
        border-radius: 0.375rem;
        padding: 0.25rem 0.5rem;
        margin: -0.25rem 0;
    }
    
    .breadcrumb-item a:hover {
        background-color: rgba(13, 110, 253, 0.1);
        transform: translateY(-1px);
    }
    
    .breadcrumb-item.active {
        color: #6c757d;
        font-weight: 500;
    }
    
    .breadcrumb-item + .breadcrumb-item::before {
        content: "›";
        color: #6c757d;
        font-weight: bold;
        font-size: 1.2rem;
    }
    
    /* Enhanced header styling */
    .bg-primary {
        background: linear-gradient(135deg, #0d6efd 0%, #0b5ed7 100%) !important;
    }
    
    .btn-light:hover {
        background-color: rgba(255, 255, 255, 0.9);
        transform: translateY(-1px);
        transition: all 0.3s ease;
    }
    
    .btn-outline-light:hover {
        background-color: rgba(255, 255, 255, 0.2);
        transform: translateY(-1px);
        transition: all 0.3s ease;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('assets/js/groups.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front_end.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/groups/liked_groups.blade.php ENDPATH**/ ?>