<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .space-between{
        justify-content: space-between;
    }
</style>
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-gear fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">General Settings</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="index.html" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">General Settings</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Manage General Settings</h5>
                                <p class="text-muted mb-0">Configure your platform's general settings</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <!-- Main Content Row -->
                <div class="row">
                    <!-- Left Column -->
                    <div class="col-md-6">
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-sliders"></i>
                                    </div>
                                    <h5 class="card-title mb-0">General Configuration</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                
                                <!-- Developer Mode -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-code-slash"></i>
                                            </div>
                                            <strong>Developer Mode</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>By enabling developer mode, error reporting will be enabled.<br>
                                            It's not recommended to enable this mode without the help of a developer.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="developer_mode" name="developer_mode" <?php echo e(active_value_check(setting('developer_mode') ?? 0)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Cache System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-speedometer"></i>
                                            </div>
                                            <strong>Cache System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Speed up your website up to 80%!<br>
                                            Note: Folder cache permission should be set to 777.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="cache_system" name="cache_system" <?php echo e(active_value_check(setting('cache_system') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Maintenance Mode -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-tools"></i>
                                            </div>
                                            <strong>Maintenance Mode</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Turn the whole site under maintenance.<br>
                                            Access via /admincp or /admin-cp.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="maintenance_mode" name="maintenance_mode" <?php echo e(active_value_check(setting('maintenance_mode') ?? 0)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- SEO Friendly URL -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-link"></i>
                                            </div>
                                            <strong>SEO Friendly URL</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable smooth loading to save bandwidth.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="seo_friendly_url" name="seo_friendly_url" <?php echo e(active_value_check(setting('seo_friendly_url') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Default Language -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-translate"></i>
                                            </div>
                                            <strong>Default Language</strong>
                                        </div>
                                        <select class="form-select mt-2" id="default_language" name="default_language">
                                            <option value="en" <?php echo e(setting('default_language') == 'en' ? 'selected' : ''); ?>>English</option>
                                            <option value="es" <?php echo e(setting('default_language') == 'es' ? 'selected' : ''); ?>>Spanish</option>
                                            <option value="fr" <?php echo e(setting('default_language') == 'fr' ? 'selected' : ''); ?>>French</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Date Format -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-calendar"></i>
                                            </div>
                                            <strong>Date Format</strong>
                                        </div>
                                        <select class="form-select mt-2" id="date_format" name="date_format">
                                            <option value="dd-mm-yyyy" <?php echo e(setting('date_format') == 'dd-mm-yyyy' ? 'selected' : ''); ?>>DD-MM-YYYY</option>
                                            <option value="mm-dd-yyyy" <?php echo e(setting('date_format') == 'mm-dd-yyyy' ? 'selected' : ''); ?>>MM-DD-YYYY</option>
                                            <option value="yyyy-mm-dd" <?php echo e(setting('date_format') == 'yyyy-mm-dd' ? 'selected' : ''); ?>>YYYY-MM-DD</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Landing Page -->
                                <div class="row mb-3">
                                    <div class="col-12">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-house-door"></i>
                                            </div>
                                            <strong>Landing Page</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Redirect for non-logged users.</small>
                                        </p>
                                        <select class="form-select mt-2" id="landing_page" name="landing_page">
                                            <option value="login" <?php echo e(setting('landing_page') == 'login' ? 'selected' : ''); ?>>Login Page</option>
                                            <option value="register" <?php echo e(setting('landing_page') == 'register' ? 'selected' : ''); ?>>Register Page</option>
                                            <option value="home" <?php echo e(setting('landing_page') == 'home' ? 'selected' : ''); ?>>Home Page</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card show-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-person-gear"></i>
                                    </div>
                                    <h5 class="card-title mb-0">User Configuration</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-people"></i>
                                            </div>
                                            <strong>Online Users</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Show current active users in home page.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="show_online_users" name="show_online_users" <?php echo e(active_value_check(setting('show_online_users') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- User Last Seen Status -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-clock-history"></i>
                                            </div>
                                            <strong>User Last Seen Status</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow users to set their status, online & last active.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="user_last_seen" name="user_last_seen" <?php echo e(active_value_check(setting('user_last_seen') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- User Account Deletion -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-person-x"></i>
                                            </div>
                                            <strong>User Account Deletion</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow users to delete their accounts.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="allow_account_deletion" name="allow_account_deletion" <?php echo e(active_value_check(setting('allow_account_deletion') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Profile Background Change -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-image"></i>
                                            </div>
                                            <strong>Profile Background Change</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow users to change their profile backgrounds by uploading an image.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="allow_profile_background" name="allow_profile_background" <?php echo e(active_value_check(setting('allow_profile_background') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Friends System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-people-fill"></i>
                                            </div>
                                            <strong>Friends System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Choose between Follow & Friend system.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="friends_system" name="friends_system" <?php echo e(active_value_check(setting('friends_system') ?? 0)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="alert alert-warning mt-2">
                                            <small>If you change the system to another one, all existing followings, followers, friends will be deleted.</small>
                                        </div>
                                    </div>
                                    <div class="col-12 mt-2">
                                        <label class="form-label">Connectivity System Limit</label>
                                        <input type="number" class="form-control" id="connectivity_limit" name="connectivity_limit" value="<?php echo e(setting('connectivity_limit') ?? 5000); ?>" placeholder="How many friends can have each user?">
                                    </div>
                                </div>

                                <!-- User Invite System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-envelope-plus"></i>
                                            </div>
                                            <strong>User Invite System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow users to invite other users to your site.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="invite_system" name="invite_system" <?php echo e(active_value_check(setting('invite_system') ?? 0)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12 mt-2">
                                        <div class="form-group mb-3">
                                            <label for="">How many links can a user generate?</label>
                                            <input type="number" class="form-control mb-2" id="invite_links_limit" name="invite_links_limit" value="<?php echo e(setting('invite_links_limit') ?? 10); ?>" placeholder="How many links can a user generate?">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="">User can generate X links within?</label>
                                            <select class="form-select" id="invite_links_expiry" name="invite_links_expiry">
                                                <option value="1" <?php echo e(setting('invite_links_expiry') == '1' ? 'selected' : ''); ?>>1 Month</option>
                                                <option value="2" <?php echo e(setting('invite_links_expiry') == '2' ? 'selected' : ''); ?>>2 Months</option>
                                                <option value="3" <?php echo e(setting('invite_links_expiry') == '3' ? 'selected' : ''); ?>>3 Months</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-gear-fill"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Other Settings</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Censored Words -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-exclamation-triangle"></i>
                                            </div>
                                            <strong>Censored Words</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Words to be censored and replaced with *** in messages, posts, comments etc, separated by a comma.</small>
                                        </p>
                                        <textarea class="form-control mt-2" id="censored_words" name="censored_words" rows="3"><?php echo e(setting('censored_words')); ?></textarea>
                                    </div>
                                </div>

                                <!-- Home Page Caching -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-speedometer2"></i>
                                            </div>
                                            <strong>Home Page Caching</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable this feature to save MySQL usage and increase the speed of home page.</small>
                                        </p>
                                        <select class="form-select mt-2" id="home_page_cache" name="home_page_cache">
                                            <option value="2" <?php echo e(setting('home_page_cache') == '2' ? 'selected' : ''); ?>>Update home page sidebar data every 2 minutes (faster load)</option>
                                            <option value="5" <?php echo e(setting('home_page_cache') == '5' ? 'selected' : ''); ?>>Update home page sidebar data every 5 minutes</option>
                                            <option value="10" <?php echo e(setting('home_page_cache') == '10' ? 'selected' : ''); ?>>Update home page sidebar data every 10 minutes</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Profile Page Caching -->
                                <div class="row mb-3">
                                    <div class="col-12">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-person-badge"></i>
                                            </div>
                                            <strong>Profile Page Caching</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Update sidebar data every X, this is related to cache system to save MySQL usage.</small>
                                        </p>
                                        <select class="form-select mt-2" id="profile_page_cache" name="profile_page_cache">
                                            <option value="30" <?php echo e(setting('profile_page_cache') == '30' ? 'selected' : ''); ?>>Every 30 seconds</option>
                                            <option value="60" <?php echo e(setting('profile_page_cache') == '60' ? 'selected' : ''); ?>>Every 60 seconds</option>
                                            <option value="120" <?php echo e(setting('profile_page_cache') == '120' ? 'selected' : ''); ?>>Every 2 minutes</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Right Column -->
                    <div class="col-md-6">
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-person-lock"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Login & Registration</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- User Registration -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-person-plus"></i>
                                            </div>
                                            <strong>User Registration</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow users to create accounts on your site.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="user_registration" name="user_registration" <?php echo e(active_value_check(setting('user_registration') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Auto Username On Register -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-person-badge"></i>
                                            </div>
                                            <strong>Auto Username On Register</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Generate an auto username on sign up.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="auto_username" name="auto_username" <?php echo e(active_value_check(setting('auto_username') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Password Complexity Settings -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-shield-lock"></i>
                                            </div>
                                            <strong>Password Complexity Settings</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>This option will require a strong password on sign up.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="password_complexity" name="password_complexity" <?php echo e(active_value_check(setting('password_complexity') ?? 0)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Ultimate Login -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-box-arrow-in-right"></i>
                                            </div>
                                            <strong>Ultimate Login</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Send a notification when the user logs from a new location.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="ultimate_login" name="ultimate_login" <?php echo e(active_value_check(setting('ultimate_login') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Remember This Device -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-phone"></i>
                                            </div>
                                            <strong>Remember This Device</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Remember this device in welcome page.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="remember_device" name="remember_device" <?php echo e(active_value_check(setting('remember_device') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Two-factor Authentication -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-shield-check"></i>
                                            </div>
                                            <strong>Two-factor Authentication</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Send authentication code to verify when user login.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="two_factor_auth" name="two_factor_auth" <?php echo e(active_value_check(setting('two_factor_auth') ?? 1)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <select class="form-select mt-2" id="two_factor_method" name="two_factor_method">
                                            <option value="email" <?php echo e(setting('two_factor_method') == 'email' ? 'selected' : ''); ?>>E-mail Address</option>
                                            <option value="sms" <?php echo e(setting('two_factor_method') == 'sms' ? 'selected' : ''); ?>>SMS</option>
                                        </select>
                                    </div>
                                    
                                </div>

                                <!-- Google Authenticator Settings -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-google"></i>
                                            </div>
                                            <strong>Google Authenticator Settings</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Google authenticator code when user login.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="google_auth" name="google_auth" <?php echo e(active_value_check(setting('google_auth') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Account Validation -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-patch-check"></i>
                                            </div>
                                            <strong>Account Validation</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Send an activation link after registration.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="account_validation" name="account_validation" <?php echo e(active_value_check(setting('account_validation') ?? 0)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <select class="form-select mt-2" id="account_validation_method" name="account_validation_method">
                                            <option value="email" <?php echo e(setting('account_validation_method') == 'email' ? 'selected' : ''); ?>>E-mail Address</option>
                                            <option value="sms" <?php echo e(setting('account_validation_method') == 'sms' ? 'selected' : ''); ?>>SMS</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- reCaptcha Settings -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-robot"></i>
                                            </div>
                                            <strong>reCaptcha</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable reCaptcha to prevent spam.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="recaptcha" name="recaptcha" <?php echo e(active_value_check(setting('recaptcha') ?? 0)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <input type="text" class="form-control mt-2" id="recaptcha_key" name="recaptcha_key" placeholder="reCaptcha Public Key" value="<?php echo e(setting('recaptcha_key')); ?>">
                                        <input type="text" class="form-control mt-2" id="recaptcha_secret" name="recaptcha_secret" placeholder="reCaptcha Secret Key" value="<?php echo e(setting('recaptcha_secret')); ?>">
                                    </div>
                                </div>

                                <!-- Prevent Bad Login Attempts -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-shield-exclamation"></i>
                                            </div>
                                            <strong>Prevent Bad Login Attempts</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable this feature to track and stop brute force attacks.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="prevent_login_attempts" name="prevent_login_attempts" <?php echo e(active_value_check(setting('prevent_login_attempts') ?? 1)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group mb-3">
                                            <label for="login_attempts" class="mb-0">Login Limits</label>
                                            <input type="number" class="form-control" id="login_attempts" name="login_attempts" placeholder="Login Lock" value="<?php echo e(setting('login_attempts') ?? 5); ?>">
                                        </div>
                                        <div class="from-group mb-3">
                                            <label for="" class="mb-0">Lockout Time (In Minutes)</label>
                                            <input type="number" class="form-control" id="login_locktime" name="login_locktime" placeholder="Locked Time In Minutes" value="<?php echo e(setting('login_locktime') ?? 30); ?>">
                                        </div>
                                    </div>
                                </div>

                                <!-- Registration Limits -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-12">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-person-lines-fill"></i>
                                            </div>
                                            <strong>Registration Limits</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>How many times a user can create accounts per hour.</small>
                                        </p>
                                        <input type="number" class="form-control mt-2" id="registration_limit" name="registration_limit" value="<?php echo e(setting('registration_limit') ?? 3); ?>">
                                    </div>
                                </div>

                                <!-- Reserved Usernames System -->
                                <div class="row mb-3">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-person-slash"></i>
                                            </div>
                                            <strong>Reserved Usernames System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Block reserved usernames.</small>
                                        </p>
                                        
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="reserved_usernames_system" name="reserved_usernames_system" <?php echo e(active_value_check(setting('reserved_usernames_system') ?? 0)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <textarea class="form-control mt-2" id="reserved_usernames" name="reserved_usernames" rows="3" placeholder="Enter comma-separated usernames"><?php echo e(setting('reserved_usernames')); ?></textarea>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-bell"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Notifications Settings</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Email Notifications -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-envelope"></i>
                                            </div>
                                            <strong>E-mail Notifications</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Send E-mail notifications to users after getting site notifications.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="email_notifications" name="email_notifications" <?php echo e(active_value_check(setting('email_notifications') ?? 0)); ?>>
                                        </div>
                                    </div>
                                </div>

                                <!-- Profile Visit Notifications -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-person-badge"></i>
                                            </div>
                                            <strong>Profile Visit Notifications</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Send a notification to a user when someone visits his profile.</small>
                                        </p>
                                        
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="profile_visit_notifications" name="profile_visit_notifications" <?php echo e(active_value_check(setting('profile_visit_notifications') ?? 1)); ?>>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="alert alert-warning mt-2">
                                            <small>Note that this feature will require the user to become a Pro member if you enable Pro System.</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- New Post Notifications -->
                                <div class="row mb-3">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                                <i class="bi bi-file-post"></i>
                                            </div>
                                            <strong>Notification On New Post</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Send a notification to followers when a user creates a new post.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="new_post_notifications" name="new_post_notifications" <?php echo e(active_value_check(setting('new_post_notifications') ?? 1)); ?>>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
<?php echo $__env->make('admin.update_settings', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/pages/settings/general_settings.blade.php ENDPATH**/ ?>