<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'SocialLink'); ?>-Admin Panel</title>
    <!-- Bootstrap 5.3 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.5/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/admin.css')); ?>">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Additional Styles from Components -->
    <?php echo $__env->yieldPushContent('styles'); ?>

    <!-- Extra Page-Specific CSS -->
    <?php echo $__env->yieldContent('extra-css'); ?>
</head>

<body>
    <div class="wrapper">

        <!-- Sidebar -->
        <?php echo $__env->make('admin.components.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <div class="main">
            <!-- Top Navbar -->
            <?php echo $__env->make('admin.components.topbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <main class="content">
                <?php echo $__env->yieldContent('content'); ?>
            </main>

            <!-- Footer -->
            <?php echo $__env->make('admin.components.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>


    <script src="<?php echo e(asset('assets/js/admin.js')); ?>"></script>

    <!-- Custom JS -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Toggle sidebar
            const sidebarToggle = document.querySelector(".js-sidebar-toggle");
            const sidebar = document.querySelector(".js-sidebar");
            const wrapper = document.querySelector(".wrapper");

            if (sidebarToggle) {
                sidebarToggle.addEventListener("click", function() {
                    wrapper.classList.toggle("sidebar-collapsed");
                });
            }



            // Handle responsive behavior
            function handleResponsive() {
                if (window.innerWidth < 992) {
                    wrapper.classList.add("sidebar-collapsed");
                } else {
                    wrapper.classList.remove("sidebar-collapsed");
                }
            }

            // Initial check
            handleResponsive();

            // Listen for window resize
            window.addEventListener("resize", handleResponsive);
        });
    </script>

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Additional Scripts from Components -->
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <?php echo $__env->yieldContent('extraJs'); ?>

</body>

</html>
<?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/layouts/home.blade.php ENDPATH**/ ?>