<?php $__env->startSection('title', 'Manage Jobs'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">All Jobs</h4>
                    <a href="<?php echo e(route('admin.jobs.stats')); ?>" class="btn btn-info btn-sm">
                        <i class="fas fa-chart-bar"></i> Job Statistics
                    </a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Company</th>
                                    <th>Category</th>
                                    <th>Posted By</th>
                                    <th>Status</th>
                                    <th>Expires</th>
                                    <th>Applications</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($job->id); ?></td>
                                        <td><?php echo e($job->job_title); ?></td>
                                        <td><?php echo e($job->company_name); ?></td>
                                        <td><?php echo e($job->category->name ?? 'N/A'); ?></td>
                                        <td><?php echo e($job->user->name ?? 'N/A'); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo e($job->status == 'approved' ? 'success' : ($job->status == 'pending' ? 'warning' : 'danger')); ?>">
                                                <?php echo e(ucfirst($job->status)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e(\Carbon\Carbon::parse($job->expiry_date)->format('M d, Y')); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('admin.jobs.applications', $job->id)); ?>" class="btn btn-sm btn-info">
                                                View Applications
                                            </a>
                                        </td>
                                        <td class="d-flex">
                                            <a href="<?php echo e(route('admin.jobs.show', $job->id)); ?>" class="btn btn-sm btn-info me-1">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.jobs.edit', $job->id)); ?>" class="btn btn-sm btn-primary me-1">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.jobs.toggle-status', $job->id)); ?>" method="POST" class="d-inline me-1">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <button type="submit" class="btn btn-sm <?php echo e($job->status == 'approved' ? 'btn-warning' : 'btn-success'); ?>">
                                                    <i class="fas <?php echo e($job->status == 'approved' ? 'fa-ban' : 'fa-check'); ?>"></i>
                                                </button>
                                            </form>
                                            <form action="<?php echo e(route('admin.jobs.destroy', $job->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this job?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">No jobs found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <?php echo e($jobs->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/pages/jobs/index.blade.php ENDPATH**/ ?>