   <!-- Header START -->
   <header class="navbar-light fixed-top header-static bg-mode">
        <!-- Logo Nav START -->
        <nav class="navbar navbar-expand-lg">
            <div class="container">
                <!-- Logo START -->
                <a class="navbar-brand p-0" href="<?php echo e(url('/')); ?>">
                    <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Socialink Logo" class="socialink-logo">
                </a>
                <!-- Logo END -->

                <!-- Responsive navbar toggler -->
                <button class="navbar-toggler ms-auto icon-md btn btn-light p-0" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false"
                    aria-label="Toggle navigation">
                    <span class="navbar-toggler-animation">
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </button>

                <!-- Main navbar START -->
                <div class="collapse navbar-collapse" id="navbarCollapse">
                    <!-- Nav Search START - Simplified for public -->
                    <div class="nav mt-3 mt-lg-0 flex-nowrap align-items-center w-100 d-flex justify-content-center">
                        <div class="nav-item w-75 position-relative">
                            <form action="<?php echo e(route('search')); ?>" method="GET" class="rounded position-relative">
                                <input 
                                    name="query"
                                    class="form-control ps-5 bg-light" 
                                    type="search"
                                    placeholder="Search..." 
                                    aria-label="Search"
                                    autocomplete="off"
                                >
                                <button
                                    class="btn bg-transparent px-2 py-0 position-absolute top-50 start-0 translate-middle-y"
                                    type="submit">
                                    <i class="bi bi-search fs-5"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                    <!-- Nav Search END -->
                </div>
                <!-- Main navbar END -->

                <!-- Nav right START -->
                <ul class="nav flex-nowrap align-items-center ms-sm-3 list-unstyled">
                    <!-- Login Button -->
                    <li class="nav-item ms-2">
                        <a class="nav-link btn btn-primary-soft btn-sm" href="<?php echo e(route('login')); ?>">
                            <i class="bi bi-box-arrow-in-right"></i> Login
                        </a>
                    </li>

                    <!-- Register Button -->
                    <li class="nav-item ms-2">
                        <a class="nav-link btn btn-primary btn-sm" href="<?php echo e(route('register')); ?>">
                            <i class="bi bi-person-plus"></i> Sign Up
                        </a>
                    </li>

                    <!-- Dark mode toggle -->
                    <li class="nav-item ms-2">
                        <div class="modeswitch-wrap" id="darkModeSwitch">
                            <div class="modeswitch-item">
                                <div class="modeswitch-icon"></div>
                            </div>
                        </div>
                    </li>
                </ul>
                <!-- Nav right END -->
            </div>
        </nav>
    </header>
    <!-- Header END -->

    <style>
        .modeswitch-wrap {
            cursor: pointer;
            padding: 8px;
            border-radius: 6px;
            transition: background-color 0.3s;
        }
        
        .modeswitch-wrap:hover {
            background-color: rgba(var(--bs-light-rgb), 0.5);
        }
        
        .modeswitch-item {
            position: relative;
            width: 24px;
            height: 24px;
        }
        
        .modeswitch-icon {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='currentColor' class='bi bi-moon-stars' viewBox='0 0 16 16'%3E%3Cpath d='M6 .278a.768.768 0 0 1 .08.858 7.208 7.208 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277.527 0 1.04-.055 1.533-.16a.787.787 0 0 1 .81.316.733.733 0 0 1-.031.893A8.349 8.349 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71 0 4.266 2.114 1.312 5.124.06A.752.752 0 0 1 6 .278z'/%3E%3Cpath d='M10.794 3.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387a1.734 1.734 0 0 0-1.097 1.097l-.387 1.162a.217.217 0 0 1-.412 0l-.387-1.162A1.734 1.734 0 0 0 9.31 6.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387a1.734 1.734 0 0 0 1.097-1.097l.387-1.162zM13.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732l-.774-.258a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L13.863.1z'/%3E%3C/svg%3E") no-repeat center;
            background-size: contain;
            opacity: 0.7;
            transition: opacity 0.3s;
        }
        
        .modeswitch-wrap:hover .modeswitch-icon {
            opacity: 1;
        }
        
        [data-bs-theme="dark"] .modeswitch-icon {
            background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='currentColor' class='bi bi-sun' viewBox='0 0 16 16'%3E%3Cpath d='M8 11a3 3 0 1 1 0-6 3 3 0 0 1 0 6zm0 1a4 4 0 1 0 0-8 4 4 0 0 0 0 8zM8 0a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 0zm0 13a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 13zm8-5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5zM3 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2A.5.5 0 0 1 3 8zm10.657-5.657a.5.5 0 0 1 0 .707l-1.414 1.415a.5.5 0 1 1-.707-.708l1.414-1.414a.5.5 0 0 1 .707 0zm-9.193 9.193a.5.5 0 0 1 0 .707L3.05 13.657a.5.5 0 0 1-.707-.707l1.414-1.414a.5.5 0 0 1 .707 0zm9.193 2.121a.5.5 0 0 1-.707 0l-1.414-1.414a.5.5 0 0 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .707zM4.464 4.465a.5.5 0 0 1-.707 0L2.343 3.05a.5.5 0 1 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .708z'/%3E%3C/svg%3E") no-repeat center;
            background-size: contain;
        }
    </style>

    <script>
        // Simple dark mode toggle for public pages
        document.addEventListener('DOMContentLoaded', function() {
            const darkModeSwitch = document.getElementById('darkModeSwitch');
            const currentTheme = localStorage.getItem('theme') || 'light';
            
            // Set initial theme
            document.documentElement.setAttribute('data-bs-theme', currentTheme);
            
            darkModeSwitch.addEventListener('click', function() {
                const currentTheme = document.documentElement.getAttribute('data-bs-theme');
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                
                document.documentElement.setAttribute('data-bs-theme', newTheme);
                localStorage.setItem('theme', newTheme);
            });
        });
    </script>
<?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/components/public_header.blade.php ENDPATH**/ ?>